/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.util;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.util.OsUtils;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SvnRepositoryPathUtil {
    private static final Pattern WINDOWS_FILE_PATH_START_PATTERN = Pattern.compile("file://[A-Z]:");
    private final OsUtils osUtils;

    public SvnRepositoryPathUtil(OsUtils osUtils) {
        this.osUtils = osUtils;
    }

    public SvnRepositoryPathUtil() {
        this(new OsUtils());
    }

    public String getPathURL(String repositoryURL, Path basePath, Path path) {
        repositoryURL = this.normalizeURL(repositoryURL);
        Path location = new Path(basePath, path).normalize();
        String urlPath = location.getAsUrl();
        if (Strings.isNullOrEmpty((String)urlPath)) {
            return repositoryURL;
        }
        return repositoryURL + "/" + urlPath;
    }

    public String normalizeURL(String repositoryURL) {
        String normalized = repositoryURL.endsWith("/") ? repositoryURL.substring(0, repositoryURL.length() - 1) : repositoryURL;
        if (normalized.startsWith("/")) {
            normalized = "file://" + normalized;
        }
        if (this.osUtils.isWindows() && normalized.startsWith("file://")) {
            normalized = this.lowerCaseWindowsDriveLetter(normalized);
        }
        return normalized;
    }

    private String lowerCaseWindowsDriveLetter(String url) {
        Matcher m2 = WINDOWS_FILE_PATH_START_PATTERN.matcher(url);
        return m2.find() ? m2.replaceFirst(m2.group(0).toLowerCase()) : url;
    }
}

