/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.util;

import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class SvnPropertyUtil {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public static String getStringValue(byte[] propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        return new String(propertyValue, UTF8_CHARSET);
    }

    public static byte[] getPropertyValue(String value) {
        return value.getBytes(UTF8_CHARSET);
    }

    public static String getAuthor(Map<String, byte[]> revProps) {
        return SvnPropertyUtil.getStringValue(revProps.get("svn:author"));
    }

    public static Date getDate(Map<String, byte[]> revProps) {
        try {
            String dateString = SvnPropertyUtil.getStringValue(revProps.get("svn:date"));
            if (dateString == null) {
                return null;
            }
            if (dateString.length() != 27 || dateString.charAt(26) != 'Z') {
                throw new ParseException("String " + dateString + " is not a valid Subversion date", 0);
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
            return formatter.parse(dateString.substring(0, 23) + " UTC");
        }
        catch (ParseException e2) {
            return null;
        }
    }

    public static String getLog(Map<String, byte[]> revProps) {
        return SvnPropertyUtil.getStringValue(revProps.get("svn:log"));
    }
}

