/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.util;

import com.cenqua.fisheye.svn.util.SvnLibraryState;
import java.util.Locale;
import org.apache.subversion.javahl.types.Version;

public class SvnLoaderConfiguration {
    private SvnLibraryState libraryState = SvnLibraryState.UNKNOWN;
    private boolean changed;
    private Version version;
    private String location;

    public String getSvnLibraryStateDescription() {
        switch (this.libraryState) {
            case UNKNOWN: {
                return "The Subversion client has not yet been loaded.";
            }
            case CLASSPATH: {
                return "The Subversion client has been loaded from the system classpath. The configured client will not be used.";
            }
            case SVNKIT: {
                return "The bundled Subversion client, SVNKit, is being used for Subversion operations.";
            }
            case NATIVE: {
                return "The configured Subversion client, native JavaHL, is being used for Subversion operations.";
            }
            case NATIVE_OLD: {
                return "The configured Subversion client, a pre 1.7 native JavaHL client, is no longer supported. ";
            }
            case NATIVE_FAILED: {
                return "The configured native JavaHL Subversion client could not be loaded and is not being used. ";
            }
        }
        return "The state of the Subversion client could not be determined.";
    }

    public boolean isSvnStateWarning() {
        return this.libraryState == SvnLibraryState.NATIVE_FAILED || this.libraryState == SvnLibraryState.NATIVE_OLD;
    }

    public void setLibraryState(SvnLibraryState state) {
        this.libraryState = state;
    }

    public SvnLibraryState getLibraryState() {
        return this.libraryState;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public boolean isSvnkit() {
        switch (this.libraryState) {
            case SVNKIT: 
            case NATIVE_OLD: 
            case NATIVE_FAILED: {
                return true;
            }
            case NATIVE: {
                return false;
            }
        }
        return this.version != null && this.version.toString().toLowerCase(Locale.US).contains("svnkit") || this.location != null && this.location.toLowerCase(Locale.US).contains("svnkit");
    }
}

