/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.util;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeClassLoader;
import com.cenqua.fisheye.FishEyeCtl;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.SvnConfigType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.svn.util.SvnLibraryState;
import com.cenqua.fisheye.svn.util.SvnLoaderConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.subversion.javahl.SVNClient;
import org.apache.subversion.javahl.types.Version;

public class SvnLoader {
    private static boolean loaded = false;
    private static SvnLoaderConfiguration configuration = new SvnLoaderConfiguration();
    public static final String JAVAHL_INTERFACE = "org/apache/subversion/javahl/ISVNClient.class";
    private static final String OLD_JAVAHL_INTERFACE = "org/tigris/subversion/javahl/SVNClientInterface.class";

    public static void checkLoaded() throws ConfigException {
        if (loaded) {
            return;
        }
        SvnLoader.onLoaded();
        loaded = true;
    }

    private static void onLoaded() throws ConfigException {
        try {
            System.setProperty("svnkit.symlinks", "false");
            if (System.getProperty("file.encoding") == null) {
                System.setProperty("file.encoding", "UTF-8");
            }
            System.setProperty("svnkit.http.methods", "Digest,Basic,Negotiate,NTLM");
            if (System.getProperty("q.sequence.memory-threshold") == null) {
                System.setProperty("q.sequence.memory-threshold", "64M");
            }
            SVNClient client = new SVNClient();
            Version version = client.getVersion();
            Logs.APP_LOG.debug((Object)("Loaded svn-javahl, version: " + version));
            String svnLibLocation = SvnLoader.getResourceSource(SVNClient.class);
            Logs.APP_LOG.debug((Object)("javaHL loaded from " + svnLibLocation));
            configuration.setVersion(version);
            configuration.setLocation(svnLibLocation);
            SvnLoader.dumpSvnLoader();
        }
        catch (Throwable e2) {
            Logs.APP_LOG.warn((Object)"Could not load svn-javahl", e2);
            throw new ConfigException("Could not load svn-javahl: " + e2.getClass().getName() + "-" + e2.getMessage(), e2);
        }
    }

    private static void dumpSvnLoader() {
        ClassLoader loader = SVNClient.class.getClassLoader();
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlLoader = (URLClassLoader)loader;
            URL[] urls = urlLoader.getURLs();
            StringBuilder loaderPath = new StringBuilder();
            for (URL url : urls) {
                loaderPath.append(url.toString()).append(':');
            }
            Logs.APP_LOG.debug((Object)("SVN Loader Path is " + loaderPath.toString()));
        } else {
            Logs.APP_LOG.debug((Object)("SVN Loader is not a URLClassLoader, it is a " + loader.getClass().getName()));
        }
    }

    public static String getResourceSource(Class c2) {
        String resource = c2.getName().replace('.', '/') + ".class";
        return SvnLoader.getResourceSource(c2.getClassLoader(), resource);
    }

    public static String getResourceSource(ClassLoader loader, String resource) {
        URL url = loader == null ? ClassLoader.getSystemResource(resource) : loader.getResource(resource);
        if (url != null) {
            String u2 = url.toString();
            if (u2.startsWith("jar:file:")) {
                int pling = u2.indexOf("!");
                return u2.substring(4, pling);
            }
            if (u2.startsWith("file:")) {
                int tail = u2.indexOf(resource);
                return u2.substring(0, tail);
            }
        }
        return null;
    }

    private static void testSvnLibrary() {
        String specifiedLibraryName = System.getProperty("subversion.native.library");
        if (specifiedLibraryName != null) {
            try {
                System.load(specifiedLibraryName);
                Logs.APP_LOG.debug((Object)("SVN Library loaded successfully from " + specifiedLibraryName));
                return;
            }
            catch (UnsatisfiedLinkError ex) {
                Logs.APP_LOG.debug((Object)("Unable to load specified library: " + specifiedLibraryName), (Throwable)ex);
            }
        }
        try {
            System.loadLibrary("svnjavahl-1");
            Logs.APP_LOG.debug((Object)"SVN Library loaded successfully from svnjavahl-1");
        }
        catch (UnsatisfiedLinkError ex) {
            Logs.APP_LOG.debug((Object)"Unable to load library as svnjavahl-1", (Throwable)ex);
            try {
                System.loadLibrary("libsvnjavahl-1");
                Logs.APP_LOG.debug((Object)"SVN Library loaded successfully from libsvnjavahl-1");
            }
            catch (UnsatisfiedLinkError e2) {
                Logs.APP_LOG.debug((Object)"Unable to load library as libsvnjavahl-1", (Throwable)ex);
                System.loadLibrary("svnjavahl");
                Logs.APP_LOG.debug((Object)"SVN Library loaded successfully from svnjavahl");
            }
        }
    }

    public static void setup(SvnConfigType cfg) {
        boolean javaHLAvailable;
        boolean bl = javaHLAvailable = SvnLoader.getResourceSource((ClassLoader)FishEyeCtl.CLASSLOADER, JAVAHL_INTERFACE) != null;
        if (cfg != null) {
            try {
                if (cfg.isSetJar()) {
                    if (javaHLAvailable) {
                        configuration.setLibraryState(SvnLibraryState.CLASSPATH);
                        Logs.APP_LOG.info((Object)"Ignoring svn configuration for JavaHL jar location as JavaHL found in classpath");
                    } else {
                        JarFile svnJar = SvnLoader.getSvnJar(cfg.getJar());
                        if (svnJar == null) {
                            Logs.APP_LOG.error((Object)("Unable to load the configured JavaHL jar from " + cfg.getJar()));
                            configuration.setLibraryState(SvnLibraryState.NATIVE_FAILED);
                        } else {
                            JarEntry newInterface = svnJar.getJarEntry(JAVAHL_INTERFACE);
                            if (newInterface != null) {
                                configuration.setLibraryState(SvnLibraryState.NATIVE);
                                FishEyeCtl.CLASSLOADER.addJar(new File(cfg.getJar()));
                            } else {
                                JarEntry oldInterface = svnJar.getJarEntry(OLD_JAVAHL_INTERFACE);
                                if (oldInterface != null) {
                                    Logs.APP_LOG.error((Object)"The version of the configured native JavaHL jar is prior to 1.7 and is no longer compatible - using SVNKit client");
                                    configuration.setLibraryState(SvnLibraryState.NATIVE_OLD);
                                } else {
                                    Logs.APP_LOG.error((Object)"The configured native JavaHL jar could not be loaded - using SVNKit client");
                                    configuration.setLibraryState(SvnLibraryState.NATIVE_FAILED);
                                }
                            }
                        }
                        boolean bl2 = javaHLAvailable = SvnLoader.getResourceSource((ClassLoader)FishEyeCtl.CLASSLOADER, JAVAHL_INTERFACE) != null;
                    }
                }
                if (cfg.isSetJnilib() && javaHLAvailable) {
                    Logs.APP_LOG.debug((Object)("Setting Subversion library location to " + cfg.getJnilib()));
                    System.setProperty("subversion.native.library", cfg.getJnilib());
                }
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)"Error configuring Svn library", (Throwable)e2);
            }
        } else if (javaHLAvailable) {
            configuration.setLibraryState(SvnLibraryState.CLASSPATH);
        }
        if (!javaHLAvailable) {
            Logs.APP_LOG.debug((Object)"Loading included SvnKit from lib/svn");
            if (configuration.getLibraryState() == SvnLibraryState.UNKNOWN) {
                configuration.setLibraryState(SvnLibraryState.SVNKIT);
            }
            SvnLoader.setupJarsFromDir(new File(AppConfig.getAppHome(), "lib/svn"));
        }
    }

    private static void setupJarsFromDir(File dir) {
        if (!dir.isDirectory()) {
            Logs.APP_LOG.error((Object)("could not find SVN lib directory " + dir));
            return;
        }
        FishEyeClassLoader fcl = FishEyeCtl.CLASSLOADER;
        if (fcl == null) {
            Logs.APP_LOG.error((Object)"Internal FishEye problem: could not load svn jar because we couldn't find our classloader.");
            return;
        }
        try {
            fcl.addJarsFromDir(dir);
            Logs.APP_LOG.debug((Object)("Loaded svn jar from directory " + dir));
        }
        catch (MalformedURLException e2) {
            Logs.APP_LOG.error((Object)"problem loading jar", (Throwable)e2);
        }
    }

    private static JarFile getSvnJar(String jar) throws IOException {
        File jarfile = new File(jar);
        if (!jarfile.exists() || !jarfile.isFile()) {
            Logs.APP_LOG.error((Object)("SVN jar does not exist: " + jarfile));
            return null;
        }
        return new JarFile(jarfile);
    }

    public static SvnLoaderConfiguration getConfiguration() {
        return configuration;
    }
}

