/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.diff;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.svn.diff.PushbackLineReader;
import com.cenqua.fisheye.svn.diff.SectionCallback;
import com.cenqua.fisheye.svn.diff.SectionReader;
import com.cenqua.fisheye.svn.diff.SvnDiffListener;
import com.cenqua.fisheye.svn.diff.SvnDiffParsingException;
import com.cenqua.fisheye.util.diff.SectionSpec;
import com.cenqua.fisheye.util.diff.UnifiedDiffSectionSpec;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SvnDiffParser {
    public static final String PROP_SECTION_DELIMITER = "##";
    private final RepositoryStatus status;
    private PushbackLineReader reader;
    private SvnDiffListener listener;
    private long revision;
    private File diffFile;
    private Path contextPath;
    private static final Map<String, Map<String, Pattern>> localePatterns = new HashMap<String, Map<String, Pattern>>();
    private static final String INDEX_KEY = "index";
    private static final String PROPCHANGE_KEY = "propchange";
    private static final String NONDISPLAY_KEY = "nondisplay";
    private static final String FROM_KEY = "fromheader";
    private static final String TO_KEY = "toheader";
    private static final String PROPNAME_KEY = "name";
    private static final String PROP_ADD_KEY = "propAdd";
    private static final String PROP_DEL_KEY = "propDel";
    private static final String PROP_MERGINFO_KEY = "propMerge";
    private static final String[] KEYS = new String[]{"index", "propchange", "nondisplay", "fromheader", "toheader", "name", "propAdd", "propDel", "propMerge"};
    private final Map<String, Pattern> patternMap;
    private static final Map<String, Pattern> defaultMap = new HashMap<String, Pattern>();
    private static final String REGEX_BUNDLE = "com.cenqua.fisheye.svn.diff.DiffRegex";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnDiffParser(Locale locale, RepositoryStatus status) {
        this.status = status;
        String localeKey = locale.toString();
        Map<String, Map<String, Pattern>> map = localePatterns;
        synchronized (map) {
            if (!localePatterns.containsKey(localeKey)) {
                Map<String, Pattern> patterns;
                ResourceBundle bundle = ResourceBundle.getBundle(REGEX_BUNDLE, locale);
                if (bundle.getLocale().getLanguage().length() == 0) {
                    patterns = defaultMap;
                } else {
                    patterns = new HashMap<String, Pattern>();
                    SvnDiffParser.loadBundleMap(bundle, patterns);
                }
                localePatterns.put(localeKey, patterns);
            }
        }
        this.patternMap = localePatterns.get(localeKey);
    }

    private static void loadBundleMap(ResourceBundle bundle, Map<String, Pattern> patterns) {
        for (String key : KEYS) {
            String patternString = bundle.getString(key);
            Pattern pattern = Pattern.compile(patternString);
            patterns.put(key, pattern);
        }
    }

    public void setContext(File diffFile, long revision) {
        this.revision = revision;
        this.diffFile = diffFile;
    }

    public void setContextPath(Path path) {
        this.contextPath = path;
    }

    private Matcher matches(String text, String patternKey) {
        Matcher matcher = this.matchPattern(this.patternMap, patternKey, text);
        if (matcher == null && this.patternMap != defaultMap) {
            matcher = this.matchPattern(defaultMap, patternKey, text);
        }
        return matcher;
    }

    private Matcher matchPattern(Map<String, Pattern> patternMap, String patternKey, String text) {
        Matcher matcher = null;
        Pattern pattern = patternMap.get(patternKey);
        if (pattern != null && !(matcher = pattern.matcher(text)).find()) {
            matcher = null;
        }
        return matcher;
    }

    private void reportException(Throwable e2) throws SvnDiffParsingException {
        if (e2 instanceof SvnDiffParsingException) {
            throw (SvnDiffParsingException)e2;
        }
        String message = e2.getClass().toString() + ":" + e2.getMessage();
        Logs.APP_LOG.error((Object)("Error processing diff " + (this.revision - 1L) + ":" + this.revision + " in " + this.diffFile + " - " + message));
        throw new SvnDiffParsingException(message, e2);
    }

    private void reportError(String message) throws SvnDiffParsingException {
        String fullMessage = "Error processing diff " + (this.revision - 1L) + ":" + this.revision + " in " + this.diffFile + " - " + message;
        throw new SvnDiffParsingException(fullMessage);
    }

    public void process(ReaderLineReader lineReader, SvnDiffListener listener) throws SvnDiffParsingException {
        this.reader = new PushbackLineReader(lineReader, new PushbackLineReader.OnReadCallback(){

            @Override
            public void onRead() {
                SvnDiffParser.this.status.throwOnStopRequested();
            }
        });
        this.listener = listener;
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                Matcher indexMatcher = this.matches(line, INDEX_KEY);
                if (indexMatcher != null) {
                    this.processFileChange(indexMatcher.group(1));
                    continue;
                }
                Matcher propChangeMatcher = this.matches(line, PROPCHANGE_KEY);
                if (propChangeMatcher != null) {
                    this.processPropertyChange(propChangeMatcher.group(1));
                    continue;
                }
                if (line.trim().length() == 0) continue;
                this.reportError("Unexpected line in overall diff at " + this.reader.getLineCount());
            }
        }
        catch (Exception e2) {
            this.reportException(e2);
        }
    }

    private void processFileChange(String indexPath) throws IOException {
        String line;
        Path path = this.getPath(indexPath);
        this.listener.indexMark(path);
        this.reader.readLine();
        while ((line = this.reader.readLine()) != null) {
            if (this.matches(line, FROM_KEY) != null) {
                this.listener.fromHeader(path, line.substring(4));
                continue;
            }
            if (this.matches(line, TO_KEY) != null) {
                this.listener.toHeader(path, line.substring(4));
                continue;
            }
            if (this.matches(line, NONDISPLAY_KEY) != null) {
                this.reader.readLine();
                continue;
            }
            if (UnifiedDiffSectionSpec.isValidSection(line)) {
                this.processSection(path, line);
                continue;
            }
            if (line.startsWith("\\") || line.trim().length() == 0 || this.matches(line, INDEX_KEY) == null && this.matches(line, PROPCHANGE_KEY) == null) continue;
            this.reader.pushBack(line);
            break;
        }
        this.listener.endFile();
    }

    private Path getPath(String indexLine) {
        Path path = this.contextPath == null ? new Path(indexLine.replace('\\', '/')) : new Path(this.contextPath, indexLine.replace('\\', '/'));
        if (path.getPath().equals(".")) {
            path = Path.ROOT;
        }
        return path;
    }

    private String readPropertyValue(String startLine, Matcher matcher) throws IOException {
        String line;
        StringBuilder buffer = new StringBuilder(startLine.substring(matcher.end()).trim());
        while ((line = this.reader.readLine()) != null) {
            if (this.isStartOfNextBlock(line)) {
                this.reader.pushBack(line);
                break;
            }
            buffer.append("\n");
            buffer.append(line);
        }
        return buffer.toString().trim();
    }

    private boolean isStartOfNextBlock(String line) throws IOException {
        String nextLine;
        if (this.matches(line, PROP_ADD_KEY) != null || this.matches(line, PROP_DEL_KEY) != null || this.matches(line, INDEX_KEY) != null || this.matches(line, PROPCHANGE_KEY) != null) {
            return true;
        }
        if (this.matches(line, PROPNAME_KEY) != null && (nextLine = this.reader.readLine()) != null) {
            this.reader.pushBack(nextLine);
            if (this.matches(nextLine, PROPNAME_KEY) != null || this.matches(nextLine, PROP_ADD_KEY) != null || this.matches(nextLine, PROP_DEL_KEY) != null || this.matches(nextLine, PROP_MERGINFO_KEY) != null) {
                return true;
            }
        }
        return false;
    }

    private void processPropertyChange(String propertyPath) throws IOException {
        String line;
        Path path = this.getPath(propertyPath);
        this.listener.propertyIndexMark(path);
        this.reader.readLine();
        String propertyName = null;
        while ((line = this.reader.readLine()) != null) {
            Matcher matcher = this.matches(line, PROPNAME_KEY);
            if (matcher != null) {
                propertyName = matcher.group(2);
                continue;
            }
            matcher = this.matches(line, PROP_ADD_KEY);
            if (matcher != null) {
                this.listener.updateProperty(path, propertyName, this.readPropertyValue(line, matcher));
                continue;
            }
            matcher = this.matches(line, PROP_DEL_KEY);
            if (matcher != null) {
                this.listener.removeProperty(path, propertyName, this.readPropertyValue(line, matcher));
                continue;
            }
            matcher = this.matches(line, PROP_MERGINFO_KEY);
            if (matcher != null) {
                this.listener.appendProperty(path, propertyName, this.readPropertyValue(line, matcher));
                continue;
            }
            if (UnifiedDiffSectionSpec.isValidSection(PROP_SECTION_DELIMITER, line)) {
                this.processPropertySection(propertyName, line);
                continue;
            }
            if (line.startsWith("\\")) continue;
            this.reader.pushBack(line);
            return;
        }
    }

    private void processPropertySection(String propertyName, String sectionLine) throws IOException {
        UnifiedDiffSectionSpec spec = new UnifiedDiffSectionSpec(PROP_SECTION_DELIMITER, sectionLine);
        SectionReader sectionReader = new SectionReader();
        sectionReader.process(this.reader, spec, new SectionCallback(){

            @Override
            public void startSection(SectionSpec spec) {
            }

            @Override
            public void addLine(String line) {
            }

            @Override
            public void removeLine(String line) {
            }

            @Override
            public void contextLine(String line) {
            }

            @Override
            public boolean isTerminalLine(String line) {
                return false;
            }

            @Override
            public void endSection() {
            }
        });
    }

    private void processSection(final Path path, String sectionLine) throws IOException {
        UnifiedDiffSectionSpec spec = new UnifiedDiffSectionSpec(sectionLine);
        SectionReader sectionReader = new SectionReader();
        sectionReader.process(this.reader, spec, new SectionCallback(){

            @Override
            public void startSection(SectionSpec spec) {
                SvnDiffParser.this.listener.section(path, spec, SvnDiffParser.this.revision);
            }

            @Override
            public void addLine(String line) {
                SvnDiffParser.this.listener.addLine(path, line);
            }

            @Override
            public void removeLine(String line) {
                SvnDiffParser.this.listener.removeLine(path, line);
            }

            @Override
            public void contextLine(String line) {
                SvnDiffParser.this.listener.contextLine(path, line);
            }

            @Override
            public boolean isTerminalLine(String line) {
                return SvnDiffParser.this.matches(line, SvnDiffParser.INDEX_KEY) != null || SvnDiffParser.this.matches(line, SvnDiffParser.PROPCHANGE_KEY) != null;
            }

            @Override
            public void endSection() {
                SvnDiffParser.this.listener.endSection();
            }
        });
    }

    static {
        ResourceBundle defaultBundle = ResourceBundle.getBundle(REGEX_BUNDLE, new Locale(""));
        SvnDiffParser.loadBundleMap(defaultBundle, defaultMap);
        localePatterns.put(Locale.US.toString(), defaultMap);
    }
}

