/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.diff;

import com.cenqua.fisheye.svn.diff.PushbackLineReader;
import com.cenqua.fisheye.svn.diff.SectionCallback;
import com.cenqua.fisheye.util.diff.SectionSpec;
import java.io.IOException;

public class SectionReader {
    public void process(PushbackLineReader reader, SectionSpec sectionSpec, SectionCallback callback) throws IOException {
        String line;
        callback.startSection(sectionSpec);
        int toCount = 0;
        int fromCount = 0;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("+")) {
                callback.addLine(line.substring(1));
                ++toCount;
                continue;
            }
            if (line.startsWith("-")) {
                callback.removeLine(line.substring(1));
                ++fromCount;
                continue;
            }
            if (line.startsWith(" ")) {
                callback.contextLine(line.substring(1));
                ++toCount;
                ++fromCount;
                continue;
            }
            if (line.startsWith("\\")) continue;
            if (fromCount == sectionSpec.getFromCount() && toCount == sectionSpec.getToCount() || fromCount > sectionSpec.getFromCount() || toCount > sectionSpec.getToCount()) {
                reader.pushBack(line);
                break;
            }
            if (!callback.isTerminalLine(line)) continue;
            reader.pushBack(line);
            break;
        }
        callback.endSection();
    }
}

