/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.diff;

import com.atlassian.utils.process.LineReadable;
import com.cenqua.fisheye.io.LineReader;
import java.io.IOException;
import java.util.LinkedList;

public class PushbackLineReader
implements LineReadable {
    private final LineReader baseReader;
    private final LinkedList<String> readAhead = new LinkedList();
    private int lineCount;
    private final OnReadCallback callback;

    public PushbackLineReader(LineReader baseReader, OnReadCallback callback) {
        this.baseReader = baseReader;
        this.callback = callback;
    }

    public PushbackLineReader(LineReader reader) {
        this(reader, null);
    }

    public String readLine() throws IOException {
        if (this.callback != null) {
            this.callback.onRead();
        }
        String result = !this.readAhead.isEmpty() ? this.readAhead.pop() : this.baseReader.readLine(1000);
        ++this.lineCount;
        return result;
    }

    public void pushBack(String line) {
        --this.lineCount;
        this.readAhead.push(line);
    }

    public void close() throws IOException {
        this.baseReader.close();
        this.readAhead.clear();
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public static interface OnReadCallback {
        public void onRead();
    }
}

