/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.diff;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.diff.ChangeInfo;
import com.cenqua.fisheye.svn.diff.SvnDiffAdapter;
import com.cenqua.fisheye.util.diff.HunkFactory;
import com.cenqua.fisheye.util.diff.SectionSpec;
import java.util.HashMap;
import java.util.Map;

public class DiffListener
extends SvnDiffAdapter {
    private Map<Path, ChangeInfo> changeInfos = new HashMap<Path, ChangeInfo>();
    private HunkFactory hunkFactory;
    private Path currentSectionPath;
    private final DiffTextCache diffTextCache;
    private SvnLogicalPathMatcher matcher;
    private boolean storeCurrentSection;

    public DiffListener(DiffTextCache diffTextCache, SvnLogicalPathMatcher matcher) {
        this.diffTextCache = diffTextCache;
        this.matcher = matcher;
        this.hunkFactory = new HunkFactory(){

            @Override
            public void addHunk(Hunk hunk) {
                DiffListener.this.getPathChangeInfo(DiffListener.this.currentSectionPath).addHunk(hunk);
            }
        };
    }

    private ChangeInfo getPathChangeInfo(Path path) {
        if (!this.changeInfos.containsKey(path)) {
            ChangeInfo changeInfo = new ChangeInfo();
            changeInfo.setDiffGenerated(true);
            this.changeInfos.put(path, changeInfo);
        }
        return this.getInfo(path);
    }

    @Override
    public void indexMark(Path path) {
        this.getPathChangeInfo(path).setFileDiff(true);
        boolean bl = this.storeCurrentSection = this.matcher != null && this.matcher.getContainerId(path) != "tag:";
        if (this.storeCurrentSection) {
            this.diffTextCache.startFileRevision(false, this.changeInfos.get(path));
        }
    }

    @Override
    public void addLine(Path path, String line) {
        this.getPathChangeInfo(path).incAdded(1);
        if (this.storeCurrentSection) {
            this.diffTextCache.addLine(line);
        }
        this.hunkFactory.addLine();
    }

    @Override
    public void removeLine(Path path, String line) {
        this.getPathChangeInfo(path).incRemoved(1);
        if (this.storeCurrentSection) {
            this.diffTextCache.removeLine(line);
        }
        this.hunkFactory.removeLine();
    }

    @Override
    public void contextLine(Path path, String line) {
        this.hunkFactory.contextLine();
    }

    @Override
    public void updateProperty(Path path, String name, String value) {
    }

    @Override
    public void section(Path path, SectionSpec spec, long changeSetId) {
        this.currentSectionPath = path;
        this.hunkFactory.startSection(spec);
    }

    @Override
    public void endSection() {
        this.hunkFactory.endSection();
    }

    @Override
    public void removeProperty(Path path, String name, String value) {
    }

    @Override
    public void appendProperty(Path path, String propertyName, String value) {
    }

    public ChangeInfo getInfo(Path path) {
        return this.changeInfos.get(path);
    }

    public void reset() {
        this.changeInfos.clear();
    }

    public Map<Path, ChangeInfo> getChangeInfos() {
        return this.changeInfos;
    }

    public void setChangeSetId(long revisionNumber) {
    }

    @Override
    public void endFile() {
        this.diffTextCache.finishFileRevision();
    }
}

