/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.db;

import com.atlassian.fisheye.db.BaseFileRevisionDAO;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexableFileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.LineCountState;
import com.cenqua.fisheye.rep.impl.NumberBasedRevisionUtil;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnSchema;
import com.cenqua.fisheye.svn.db.SvnStringTables;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.ag;
import com.cenqua.obfuscate.idb.m;
import com.cenqua.obfuscate.idb.n;
import com.cenqua.obfuscate.idb.y;
import com.google.common.collect.TreeMultimap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class SvnRevInfoDAO
extends BaseFileRevisionDAO<SvnRevInfo, SvnStringTables> {
    private final SvnLogicalPathMatcher pathMatcher;

    public SvnRevInfoDAO(InfinityDbHandle dbh, SvnStringTables stringTables, SvnLogicalPathMatcher pathMatcher, String repositoryName, LicenseEnforcer licenseEnforcer) {
        super(repositoryName, dbh, stringTables, true, true, licenseEnforcer);
        this.pathMatcher = pathMatcher;
    }

    @Override
    public int insertNew(SvnRevInfo rev, AncestorLink ancestorLink, boolean storeDiffs) throws DbException, LicensePolicyException {
        int revid = this.commonDAO.insertNew(rev, ancestorLink, storeDiffs, this.isStoreSuffixPaths());
        this.storeSvnProperties(revid, rev.getProperties());
        this.commonDAO.addRevidLongIndex(SvnSchema.I_CHANGESETID_REVID, rev.getSvnRevision(), revid);
        this.commonDAO.addPathLongProperty(SvnSchema.I_PATHID_CHANGESETID, rev.getPath(), rev.getSvnRevision());
        long pathId = this.commonDAO.getPathId(rev.getPath());
        this.commonDAO.addRevIdLongProperty(SvnSchema.I_REVID_TO_PATHID, revid, pathId);
        if (rev.getCopySourcePath() != null) {
            long srcPathId = this.commonDAO.addPathId(rev.getCopySourcePath());
            this.commonDAO.setLongAttribute(revid, SvnSchema.SvnRevInfoAttrs.A_COPY_SRC_PATH, srcPathId);
            this.commonDAO.setLongAttribute(revid, SvnSchema.SvnRevInfoAttrs.A_COPY_SRC_REV, rev.getCopySourceRevision());
        }
        if (rev.getLogicalPath() != null) {
            this.updateLogicalPathInfo(rev, revid);
        }
        return revid;
    }

    public void storeSvnProperties(int revid, Map<String, String> properties) throws DbException {
        y cu = y.a();
        try {
            ac db = this.dbh.get();
            cu.a(SvnSchema.E_PROPERTIES).b((long)revid);
            int pl = cu.e();
            while (db.a(cu, pl)) {
                db.c(cu);
            }
            if (properties != null) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    long keyId = ((SvnStringTables)this.stringTables).propertyKeyDB.add(key);
                    long valueId = ((SvnStringTables)this.stringTables).propertyValueDB.add(value);
                    cu.f().a(SvnSchema.E_PROPERTIES);
                    cu.b((long)revid).b(keyId);
                    pl = cu.e();
                    cu.b(valueId);
                    db.e(cu, pl);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    public void storeRemovedSvnProperties(int revid, Set<String> removedProperties) {
        try {
            ac db = this.dbh.get();
            for (String property : removedProperties) {
                long keyId = ((SvnStringTables)this.stringTables).propertyKeyDB.add(property);
                y cu = y.a().a(SvnSchema.E_REMOVED_PROPERTIES);
                cu.b((long)revid).b(keyId);
                int pl = cu.e();
                db.e(cu, pl);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public Set<String> loadRemovedSvnProperties(int revId) throws DbException {
        try {
            ac db = this.dbh.get();
            HashSet<String> result = new HashSet<String>();
            y cu = y.a().a(SvnSchema.E_REMOVED_PROPERTIES).b((long)revId);
            int keyLength = cu.e();
            while (db.a(cu, keyLength)) {
                long keyId = cu.v(keyLength);
                String key = ((SvnStringTables)this.stringTables).propertyKeyDB.get(keyId);
                result.add(key);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void storeTagRevision(String tag, Path tagPath, long taggingRevNumber, Path taggedPath, long taggedRevNumber) throws DbException {
        try {
            ac db = this.dbh.get();
            long tagPathId = ((SvnStringTables)this.stringTables).tagPathDB.add(tagPath.getPath());
            y cu = y.a().a(SvnSchema.I_TAGPATHID_CHANGESETID);
            cu.b(tagPathId).b(taggingRevNumber);
            db.b(cu);
            cu.f();
            cu.a(SvnSchema.I_TAGGEDPATHID_TAGGEDCHANGESET_TAGGINGCHANGESET);
            long taggedPathId = ((SvnStringTables)this.stringTables).pathDB.find(taggedPath.getPath());
            long tagId = ((SvnStringTables)this.stringTables).tagDB.find(tag);
            cu.b(taggedPathId).b(tagId).b(taggedRevNumber).b(taggingRevNumber);
            db.b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private long getTaggingChangeSet(String tag, Path path, long taggedChangeset) throws DbException {
        try {
            ac db = this.dbh.get();
            long result = -1L;
            long taggedPathId = ((SvnStringTables)this.stringTables).pathDB.find(path.getPath());
            long tagId = ((SvnStringTables)this.stringTables).tagDB.find(tag);
            y cu = y.a().a(SvnSchema.I_TAGGEDPATHID_TAGGEDCHANGESET_TAGGINGCHANGESET);
            cu.b(taggedPathId).b(tagId).b(taggedChangeset);
            int keyLength = cu.e();
            if (db.a(cu, keyLength)) {
                result = cu.v(keyLength);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void updateLogicalPathInfo(SvnRevInfo revision, int revid) throws DbException {
        try {
            ac db = this.dbh.get();
            Path logicalPath = revision.getLogicalPath();
            long logicalPathId = ((SvnStringTables)this.stringTables).logicalPathDB.add(logicalPath.getPath());
            y cu = y.a().a(SvnSchema.I_LOGICALPATHID_CSID_REVID);
            cu.b(logicalPathId).b(revision.getSvnRevision()).b((long)revid);
            db.b(cu);
            cu.f().a(SvnSchema.I_LOGICALPATHID_REVID);
            cu.b(logicalPathId).b((long)revid);
            db.b(cu);
            long parentDirId = ((SvnStringTables)this.stringTables).logicalPathDB.add(logicalPath.getParent().getPath());
            cu.f().a(SvnSchema.I_LOGICALDIRID_REVID);
            cu.b(parentDirId).b((long)revid);
            db.b(cu);
            db.b(cu.f().a(SvnSchema.I_LOGICALPARENTPATHS_TO_REVID).b(logicalPathId).b((long)revid));
            if (!logicalPath.isRoot()) {
                Path parent = logicalPath.getParent();
                long parentPathId = ((SvnStringTables)this.stringTables).logicalPathDB.add(parent.getPath());
                cu.f().a(SvnSchema.I_LOGICALDIR_FILETYPE_REVID);
                cu.b(parentPathId).b((long)revision.getFileType()).b((long)revid);
                db.b(cu);
                parent = logicalPath;
                do {
                    parent = parent.getParent();
                    long parentid = ((SvnStringTables)this.stringTables).logicalPathDB.add(parent.getPath());
                    cu.f().a(SvnSchema.I_LOGICALPARENTPATHS_TO_REVID);
                    cu.b(parentid).b((long)revid);
                    db.b(cu);
                } while (!parent.isRoot());
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public TreeMultimap<Long, Integer> getLogicalPathRevisions(Path logicalPath) throws DbException {
        TreeMultimap result = TreeMultimap.create();
        try {
            ac db = this.dbh.get();
            long logicalPathId = ((SvnStringTables)this.stringTables).logicalPathDB.find(logicalPath.getPath());
            if (logicalPathId != -1L) {
                y cu = y.a();
                cu.a(SvnSchema.I_LOGICALPATHID_CSID_REVID);
                cu.b(logicalPathId);
                int pl = cu.e();
                while (db.a(cu, pl)) {
                    long csid = cu.v(pl);
                    int revid = (int)cu.v(cu.w(pl));
                    result.put((Object)csid, (Object)revid);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return result;
    }

    public int getLogicalPathRevid(Path logicalPath, long rev) {
        int result = -1;
        try {
            ac db = this.dbh.get();
            long logicalPathId = ((SvnStringTables)this.stringTables).logicalPathDB.find(logicalPath.getPath());
            if (logicalPathId != -1L) {
                y cu = y.a();
                cu.a(SvnSchema.I_LOGICALPATHID_CSID_REVID);
                cu.b(logicalPathId);
                cu.b(rev);
                int pl = cu.e();
                if (db.a(cu, pl)) {
                    result = (int)cu.v(pl);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return result;
    }

    public Set<Integer> getRevidsForLogicalPath(Path logicalPath) throws DbException {
        IntArraySet result = new IntArraySet();
        try {
            ac db = this.dbh.get();
            long logicalPathId = ((SvnStringTables)this.stringTables).logicalPathDB.find(logicalPath.getPath());
            if (logicalPathId != -1L) {
                y cu = y.a();
                cu.a(SvnSchema.I_LOGICALPATHID_REVID);
                cu.b(logicalPathId);
                int pl = cu.e();
                while (db.a(cu, pl)) {
                    int revid = (int)cu.v(pl);
                    result.add(revid);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return result;
    }

    public IntList getTaggedDirEntries(Path logicalDir, int filetype, String tag, long changesetLimit) throws DbException {
        IntArrayList revids;
        block4: {
            revids = new IntArrayList();
            try {
                ac db = this.dbh.get();
                long logicalDirId = ((SvnStringTables)this.stringTables).logicalPathDB.find(logicalDir.getPath());
                long tagId = ((SvnStringTables)this.stringTables).tagDB.find(tag);
                if (logicalDirId == -1L || tagId == -1L) break block4;
                y cu1 = y.a().a(SvnSchema.I_LOGICALDIR_FILETYPE_REVID).b(logicalDirId).b((long)filetype);
                ag logicalRevids = new ag(db, cu1);
                y cu2 = y.a().a(CommonSchema.E_TAG_TO_REVID).b(tagId);
                ag taggedRevids = new ag(db, cu2);
                m andSpace = new n().g(logicalRevids).g(taggedRevids);
                y cu = y.a();
                while (andSpace.d(cu)) {
                    int revid = (int)cu.v(0);
                    RevInfoKey key = this.commonDAO.getKey(revid);
                    long changeset = Long.parseLong(key.getRev());
                    if (changesetLimit == -1L || changeset < changesetLimit) {
                        revids.add(revid);
                    }
                    if (changesetLimit == -1L || changeset < changesetLimit) continue;
                    break;
                }
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
        return revids;
    }

    private void visitTaggedTree(Path physicalPath, long changesetLimit, CommonRevInfoDAO.DirectoryTreeVisitor visitor) throws DbException {
        long tagCSID;
        String tag = this.pathMatcher.getTag(physicalPath);
        Path logicalPath = this.getLogicalPath(physicalPath);
        Path tagRoot = this.pathMatcher.getTagRoot(physicalPath);
        int tagRootRevid = this.getRevId(tagRoot, tagCSID = this.getLatestPathChangeUpto(tagRoot, changesetLimit, true));
        if (tagRootRevid == -1) {
            return;
        }
        RevInfoKey tagRootKey = this.commonDAO.getKey(tagRootRevid);
        long tagRootCSID = Long.parseLong(tagRootKey.getRev());
        try {
            ac db = this.dbh.get();
            long logicalPathId = ((SvnStringTables)this.stringTables).logicalPathDB.find(logicalPath.getPath());
            long tagId = ((SvnStringTables)this.stringTables).tagDB.find(tag);
            if (logicalPathId != -1L && tagId != -1L) {
                y cu1 = y.a().a(SvnSchema.I_LOGICALPARENTPATHS_TO_REVID).b(logicalPathId);
                ag treeRevids = new ag(db, cu1);
                y cu2 = y.a().a(CommonSchema.E_TAG_TO_REVID).b(tagId);
                ag taggedRevids = new ag(db, cu2);
                m andSpace = new n().g(treeRevids).g(taggedRevids);
                y cu = y.a();
                LongOpenHashSet pathIds = new LongOpenHashSet();
                while (andSpace.d(cu)) {
                    int revid = (int)cu.v(0);
                    RevInfoKey key = this.commonDAO.getKey(revid);
                    long changeset = Long.parseLong(key.getRev());
                    if (changesetLimit != -1L && changeset > changesetLimit) continue;
                    Path realPath = key.getPath();
                    Path realLogicalPath = this.pathMatcher.getLogicalTail(realPath);
                    Path rebased = new Path(tagRoot, realLogicalPath);
                    long rebasedPathId = ((SvnStringTables)this.stringTables).pathDB.add(rebased.getPath());
                    long latest = this.getLatestPathUpTo(((SvnStringTables)this.stringTables).pathDB, SvnSchema.I_PATHID_CHANGESETID, rebased, changesetLimit);
                    if (pathIds.contains(rebasedPathId)) continue;
                    if (latest != -1L) {
                        if (latest != changeset) continue;
                        pathIds.add(rebasedPathId);
                        visitor.visit(rebasedPathId, changeset);
                        continue;
                    }
                    pathIds.add(rebasedPathId);
                    visitor.visit(rebasedPathId, tagRootCSID);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public boolean isVirtualPath(Path p2, long changeset) throws DbException {
        try {
            long latest = this.getLatestPathUpTo(((SvnStringTables)this.stringTables).pathDB, SvnSchema.I_PATHID_CHANGESETID, p2, changeset);
            return latest == -1L;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int getTaggedPathRevid(Path logicalPath, String tag, long changesetLimit) throws DbException {
        int result = -1;
        try {
            ac db = this.dbh.get();
            long logicalPathId = ((SvnStringTables)this.stringTables).logicalPathDB.find(logicalPath.getPath());
            long tagId = ((SvnStringTables)this.stringTables).tagDB.find(tag);
            if (logicalPathId != -1L && tagId != -1L) {
                y cu1 = y.a().a(SvnSchema.I_LOGICALPATHID_REVID).b(logicalPathId);
                ag logicalRevids = new ag(db, cu1);
                y cu2 = y.a().a(CommonSchema.E_TAG_TO_REVID).b(tagId);
                ag taggedRevids = new ag(db, cu2);
                m andSpace = new n().g(logicalRevids).g(taggedRevids);
                y cu = y.a();
                while (andSpace.d(cu)) {
                    int revid = (int)cu.v(0);
                    RevInfoKey key = this.commonDAO.getKey(revid);
                    long taggedChangeset = Long.parseLong(key.getRev());
                    long taggingChangeset = this.getTaggingChangeSet(tag, key.getPath(), taggedChangeset);
                    if (taggingChangeset == -1L) {
                        taggingChangeset = taggedChangeset;
                    }
                    if (changesetLimit != -1L && taggingChangeset > changesetLimit) continue;
                    if (result != -1) {
                        Logs.APP_LOG.debug((Object)("Multiple revisions found at '" + logicalPath + "' for tag '" + tag + "'. This may indicate that the symbolic settings are wrong."));
                    }
                    result = revid;
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return result;
    }

    public long getLatestPathChangeUpto(Path physicalPath, long limitRevision, boolean includeTags) throws DbException {
        try {
            long tagcsid;
            long csid = this.getLatestPathUpTo(((SvnStringTables)this.stringTables).pathDB, SvnSchema.I_PATHID_CHANGESETID, physicalPath, limitRevision);
            if (includeTags && this.pathMatcher.isTag(physicalPath) && (tagcsid = this.getLatestPathUpTo(((SvnStringTables)this.stringTables).tagPathDB, SvnSchema.I_TAGPATHID_CHANGESETID, physicalPath, limitRevision)) > csid) {
                csid = tagcsid;
            }
            return csid;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long getLatestLogicalPathChangeUpto(Path logicalPath, long limitRevision) throws DbException {
        try {
            return this.getLatestPathUpTo(((SvnStringTables)this.stringTables).logicalPathDB, SvnSchema.I_LOGICALPATHID_CSID_REVID, logicalPath, limitRevision);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private long getLatestPathUpTo(UniqueStringTable pathTable, I pathIndexTable, Path path, long limitRevision) throws IOException, DbException {
        return NumberBasedRevisionUtil.getLatestCsIdOnPathUpTo(this.dbh.get(), pathTable, pathIndexTable, path, limitRevision);
    }

    public long getLatestPathChange(Path physicalPath) throws DbException {
        return this.getLatestPathChangeUpto(physicalPath, -1L, true);
    }

    public long getLatestLogicalPathChange(Path logicalPath) throws DbException {
        return this.getLatestLogicalPathChangeUpto(logicalPath, -1L);
    }

    public int getRevId(Path path, long changesetId) throws DbException {
        int revid = this.getPureRevId(path, changesetId);
        if (revid == -1 && this.pathMatcher.isTag(path)) {
            String tag = this.pathMatcher.getTag(path);
            Path logicalPath = this.getLogicalPath(path);
            revid = this.getTaggedPathRevid(logicalPath, tag, changesetId);
        }
        return revid;
    }

    public int getPureRevId(Path path, long changesetId) throws DbException {
        int revid = -1;
        long pathId = this.commonDAO.getPathId(path);
        if (pathId != -1L) {
            revid = this.commonDAO.getRevId(pathId, Long.toString(changesetId));
        }
        return revid;
    }

    public SortedMap<Long, Integer> getPathRevisions(Path physicalPath) throws DbException {
        Map<String, Integer> revMap = this.commonDAO.getPathRevisions(physicalPath);
        TreeMap<Long, Integer> result = new TreeMap<Long, Integer>();
        for (Map.Entry<String, Integer> entry : revMap.entrySet()) {
            result.put(Long.valueOf(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public void visitDirectoryTree(Path physicalPath, final long changesetId, final CommonRevInfoDAO.DirectoryTreeVisitor visitor) throws DbException {
        final LinkedList<Boolean> visitingTags = new LinkedList<Boolean>();
        CommonRevInfoDAO.DirectoryTreeVisitor deletedFilter = new CommonRevInfoDAO.DirectoryTreeVisitor(){

            @Override
            public void visit(long pathId, long csid) throws DbException {
                int revid;
                if (!((Boolean)visitingTags.peek()).booleanValue()) {
                    Path path = SvnRevInfoDAO.this.getPath(pathId);
                    if (SvnRevInfoDAO.this.pathMatcher.isTag(path)) {
                        visitingTags.push(true);
                        SvnRevInfoDAO.this.visitTaggedTree(path, changesetId, this);
                        visitingTags.pop();
                        return;
                    }
                }
                if ((revid = SvnRevInfoDAO.this.commonDAO.getRevId(pathId, Long.toString(csid))) != -1 && SvnRevInfoDAO.this.isDeleted(revid)) {
                    return;
                }
                visitor.visit(pathId, csid);
            }
        };
        if (this.pathMatcher.isTag(physicalPath)) {
            visitingTags.push(true);
            this.visitTaggedTree(physicalPath, changesetId, deletedFilter);
            visitingTags.pop();
        } else {
            visitingTags.push(false);
            this.commonDAO.visitRevisionTree(physicalPath, SvnSchema.I_PATHID_CHANGESETID, changesetId, deletedFilter);
            visitingTags.pop();
        }
    }

    @Override
    public Path getPath(long pathId) throws DbException {
        Path path = null;
        String pathStr = ((SvnStringTables)this.stringTables).pathDB.get(pathId);
        if (pathStr != null) {
            path = new Path(pathStr);
        }
        return path;
    }

    @Override
    public SvnRevInfo load(int revId) throws DbException {
        SvnRevInfo revInfo = null;
        if (this.commonDAO.exists(revId)) {
            try {
                revInfo = new SvnRevInfo();
                this.commonDAO.load(revId, revInfo);
                revInfo.setStringProperties(this.loadSvnProperties(revId), null);
                revInfo.setLogicalPath(this.getLogicalPath(revInfo.getPath()));
                long copySourcePathId = this.commonDAO.getLongAttribute(revId, SvnSchema.SvnRevInfoAttrs.A_COPY_SRC_PATH, -1L);
                if (copySourcePathId == -1L) {
                    revInfo.setCopySourcePath(null);
                    revInfo.setCopySourceRevision(-1L);
                } else {
                    revInfo.setCopySourcePath(this.commonDAO.getPath(copySourcePathId));
                    revInfo.setCopySourceRevision(this.commonDAO.getLongAttribute(revId, SvnSchema.SvnRevInfoAttrs.A_COPY_SRC_REV, -1L));
                }
                revInfo.setDiffValid(this.commonDAO.getBooleanAttribute(revId, SvnSchema.SvnRevInfoAttrs.A_DIFF_VALID, false));
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)("Exception when loading revId (" + revId + "): " + e2.getMessage()), (Throwable)e2);
                revInfo = null;
            }
        }
        return revInfo;
    }

    @Override
    public Path getLogicalPath(Path path) {
        return this.pathMatcher.getLogicalPath(path);
    }

    public Map<String, String> loadSvnProperties(int revId) throws DbException {
        try {
            ac db = this.dbh.get();
            HashMap<String, String> result = new HashMap<String, String>();
            y cu = y.a().a(SvnSchema.E_PROPERTIES).b((long)revId);
            int keyLength = cu.e();
            while (db.a(cu, keyLength)) {
                long keyId = cu.v(keyLength);
                int offset = cu.w(keyLength);
                long valueId = cu.v(offset);
                String key = ((SvnStringTables)this.stringTables).propertyKeyDB.get(keyId);
                String value = ((SvnStringTables)this.stringTables).propertyValueDB.get(valueId);
                result.put(key, value);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public SvnRevisionSummary loadSummary(int revID) throws DbException {
        return new SvnRevisionSummary(revID);
    }

    public String getSvnProperty(int revid, String key) throws DbException {
        try {
            ac db = this.dbh.get();
            String result = null;
            y cu = y.a().a(SvnSchema.E_PROPERTIES).b((long)revid);
            long keyId = ((SvnStringTables)this.stringTables).propertyKeyDB.add(key);
            cu.b(keyId);
            int keyLength = cu.e();
            while (db.a(cu, keyLength)) {
                long valueId = cu.v(keyLength);
                result = ((SvnStringTables)this.stringTables).propertyValueDB.get(valueId);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public boolean exists(Path path, long revisionNumber) throws DbException {
        return this.commonDAO.exists(this.getRevId(path, revisionNumber));
    }

    public void removeTag(int taggedRevId, String tag) throws DbException {
        this.commonDAO.removeTagData(taggedRevId, tag);
    }

    public SortedIntSet getRevidsInChangeSetRange(long fromCSID, long toCSID) throws DbException {
        return this.commonDAO.getRevidsInLongIndexRange(SvnSchema.I_CHANGESETID_REVID, fromCSID, toCSID);
    }

    public SortedIntSet getPhysicalPaths(SortedIntSet revids) throws DbException {
        return this.commonDAO.getLongProperySet(SvnSchema.I_REVID_TO_PATHID, revids);
    }

    public Path getPhysicalPath(long physicalPathId) throws DbException {
        return new Path(((SvnStringTables)this.stringTables).pathDB.get(physicalPathId));
    }

    public LongSet getChangeSets(long start, long end) throws DbException {
        return this.commonDAO.getLongIndexKeyRange(SvnSchema.I_CHANGESETID_REVID, start, end);
    }

    public void updateComment(int revid, String comment) throws DbException {
        this.commonDAO.updateComment(revid, comment);
    }

    public void updateAuthor(int revid, String author) throws DbException {
        this.commonDAO.updateAuthor(revid, author);
    }

    public void updateDate(int revid, long date) throws DbException {
        this.commonDAO.updateDate(revid, date);
    }

    @Override
    public SvnRevInfo getDiffRevision(SvnRevInfo rev) throws DbException {
        int revid;
        if (rev != null && rev.getDiffRevision() != null && (revid = this.getId(rev.getDiffRevision())) != -1) {
            return this.load(revid);
        }
        return null;
    }

    public void addTagRemoval(Path tagPath, Path logicalPath, String tag, long revision) {
        ac db = this.dbh.get();
        long pathId = ((SvnStringTables)this.stringTables).tagPathDB.add(tagPath.getPath());
        y cu = y.a();
        try {
            cu.a(SvnSchema.E_TAGOPS).b(pathId);
            int keyLength = cu.e();
            long currentRevision = -1L;
            if (db.a(cu, keyLength)) {
                currentRevision = cu.v(keyLength);
            }
            if (revision > currentRevision) {
                cu.d(keyLength).b(revision);
                db.e(cu, keyLength);
                int taggedRevid = this.getTaggedPathRevid(logicalPath, tag, revision);
                if (taggedRevid != -1) {
                    this.removeTag(taggedRevid, tag);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    public void addTagAddition(int taggedRevid, Path tagPath, String tag, long revision) {
        ac db = this.dbh.get();
        long pathId = ((SvnStringTables)this.stringTables).tagPathDB.add(tagPath.getPath());
        y cu = y.a();
        try {
            cu.a(SvnSchema.E_TAGOPS).b(pathId);
            int keyLength = cu.e();
            long currentRevision = -1L;
            if (db.a(cu, keyLength)) {
                currentRevision = cu.v(keyLength);
            }
            if (revision > currentRevision) {
                cu.d(keyLength).b(revision);
                db.e(cu, keyLength);
                this.addTag(taggedRevid, tag);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            y.c(cu);
        }
    }

    public void updateCopySource(int revid, SvnRevInfo revision) {
        Path copySourcePath = revision.getCopySourcePath();
        if (copySourcePath == null) {
            this.commonDAO.setLongAttribute(revid, SvnSchema.SvnRevInfoAttrs.A_COPY_SRC_PATH, -1L);
        } else {
            long pathId = this.commonDAO.getPathId(copySourcePath);
            this.commonDAO.setLongAttribute(revid, SvnSchema.SvnRevInfoAttrs.A_COPY_SRC_PATH, pathId);
            this.commonDAO.setLongAttribute(revid, SvnSchema.SvnRevInfoAttrs.A_COPY_SRC_REV, revision.getCopySourceRevision());
        }
    }

    public void updateLineCount(int revId, int total, int numAdded, int numRemoved, LineCountState state) {
        this.commonDAO.updateLineCount(revId, total, numAdded, numRemoved, state);
    }

    public void updateDiffValid(int revId, boolean diffValid) {
        this.commonDAO.setBooleanAttribute(revId, SvnSchema.SvnRevInfoAttrs.A_DIFF_VALID, diffValid);
    }

    @Override
    public boolean isStoreSuffixPaths() {
        return true;
    }

    public class SvnRevisionSummary
    implements IndexableFileRevision {
        private int revID;
        private String revision;
        private long date;
        private boolean added;
        private boolean dead;
        private Path path;
        private Map<String, String> properties;
        private int lineCount;
        private int fileType;
        private boolean oversize;
        private boolean binary;

        public SvnRevisionSummary(int revID) {
            try {
                String pathStr;
                this.revID = revID;
                this.properties = SvnRevInfoDAO.this.loadSvnProperties(revID);
                EavEntityCu eav = SvnRevInfoDAO.this.commonDAO.makeEav(revID);
                y revkey = y.a();
                if (!eav.getValue(CommonSchema.RevInfo.A_REVKEY, revkey)) {
                    throw new DbException("Revkey not found for revid " + revID);
                }
                long pathid = revkey.v(0);
                this.revision = revkey.m(revkey.w(0));
                this.date = eav.getLong(CommonSchema.RevInfo.A_DATE, 0L);
                this.added = eav.getBoolean(CommonSchema.RevInfo.A_ISADDED, false);
                this.dead = eav.getBoolean(CommonSchema.RevInfo.A_ISDELETED, false);
                this.fileType = eav.getInt(CommonSchema.RevInfo.A_FILETYPE, 1);
                this.oversize = eav.getBoolean(CommonSchema.RevInfo.A_IS_OVERSIZE, false);
                this.binary = eav.getBoolean(CommonSchema.RevInfo.A_ISBINARY, false);
                y cu = y.a();
                if (eav.getValue(CommonSchema.RevInfo.A_LINEDATA, cu)) {
                    this.lineCount = (int)cu.v(0);
                }
                if ((pathStr = ((SvnStringTables)((SvnRevInfoDAO)SvnRevInfoDAO.this).stringTables).pathDB.get(pathid)) == null) {
                    throw new DbException("Path not found for revid " + revID);
                }
                this.path = new Path(pathStr);
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }

        @Override
        public int getRevID() {
            return this.revID;
        }

        public boolean isAdded() {
            return this.added;
        }

        public boolean isDead() {
            return this.dead;
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public long getDate() {
            return this.date;
        }

        @Override
        public String getChangeSetId() {
            return this.getRevision();
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public int getLineCount() {
            return this.lineCount;
        }

        public int getFileType() {
            return this.fileType;
        }

        public boolean isOversize() {
            return this.oversize;
        }

        public boolean isBinary() {
            return this.binary;
        }

        public boolean isBinaryOrOversize() {
            return this.isBinary() || this.isOversize();
        }

        @Override
        public RevInfoKey getRevInfoKey() {
            return new RevInfoKey(this.getPath(), this.getRevision());
        }

        @Override
        public String getRevision() {
            return this.revision;
        }

        public long getSvnRevision() {
            return Long.parseLong(this.revision);
        }
    }
}

