/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.db;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import com.cenqua.fisheye.svn.SvnMimeUtils;
import com.cenqua.fisheye.svn.util.SvnPropertyUtil;
import com.cenqua.fisheye.util.CustomFileNameMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SvnRevInfo
extends CommonFileRevision
implements CommonFileRevisionInput {
    private long svnRevision;
    private Path logicalPath;
    private Map<String, String> properties = new HashMap<String, String>();
    private Path copySourcePath;
    private long copySourceRevision;
    private boolean diffValid;

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SvnRevInfo revInfo = (SvnRevInfo)o2;
        if (this.svnRevision != revInfo.svnRevision) {
            return false;
        }
        return this.getPath().equals(revInfo.getPath());
    }

    @Override
    public int hashCode() {
        int result = (int)(this.svnRevision ^ this.svnRevision >>> 32);
        result = 31 * result + this.getPath().hashCode();
        return result;
    }

    public void setProperties(Map<String, byte[]> properties, CustomFileNameMap mimeMap) {
        if (properties != null) {
            for (Map.Entry<String, byte[]> entry : properties.entrySet()) {
                String value = SvnPropertyUtil.getStringValue(entry.getValue());
                this.properties.put(entry.getKey(), value);
            }
        }
        this.updateBinary(mimeMap);
    }

    public void setStringProperties(Map<String, String> properties, CustomFileNameMap mimeMap) {
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }
        this.updateBinary(mimeMap);
    }

    public void setSVNRevision(long revision) {
        this.svnRevision = revision;
        super.setRevision(Long.toString(revision));
    }

    @Override
    public void setRevision(String revision) {
        super.setRevision(revision);
        this.svnRevision = Long.parseLong(revision);
    }

    public long getSvnRevision() {
        return this.svnRevision;
    }

    @Override
    public Path getLogicalPath() {
        return this.logicalPath;
    }

    public void setLogicalPath(Path logicalPath) {
        this.logicalPath = logicalPath;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Collection<String> getPropertyKeys() {
        ArrayList<String> l2 = new ArrayList<String>(this.properties.keySet());
        Collections.sort(l2);
        return l2;
    }

    public int getNumberOfProperties() {
        return this.getProperties().size();
    }

    @Override
    public boolean isAnnotatable() {
        return this.isFile() && !this.isBinary() && !this.isOversize();
    }

    public String getProperty(String propName) {
        return this.properties.get(propName);
    }

    private void updateBinary(CustomFileNameMap mimeMap) {
        if (mimeMap != null && !this.isBinary() && SvnMimeUtils.isBinaryMimeType(mimeMap, this.getProperty("svn:mime-type"))) {
            this.setBinary(true);
        }
    }

    public void setCopySourcePath(Path srcPath) {
        this.copySourcePath = srcPath;
    }

    public Path getCopySourcePath() {
        return this.copySourcePath;
    }

    public void setCopySourceRevision(long copySourceRevision) {
        this.copySourceRevision = copySourceRevision;
    }

    public long getCopySourceRevision() {
        return this.copySourceRevision;
    }

    public void setDiffValid(boolean diffValid) {
        this.diffValid = diffValid;
    }

    public boolean isDiffValid() {
        return this.diffValid;
    }
}

