/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.db;

import com.atlassian.fecru.util.ListIterable;
import com.atlassian.fisheye.db.FileRevisionDAO;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfDbIterable;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.CommonChangeSetDAO;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import com.cenqua.fisheye.svn.db.SvnSchema;
import com.cenqua.fisheye.svn.db.SvnStringTables;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongRBTreeSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class SvnChangeSetDAO
extends CommonChangeSetDAO<SvnRevInfo, SvnChangeSet, SvnStringTables> {
    private volatile long lastCsid = -1L;
    private final LongLinkedOpenHashSet EMPTY_LONG_SORTED_SET = new LongLinkedOpenHashSet();

    public SvnChangeSetDAO(RepositoryStatus status, InfinityDbHandle dbh, SvnStringTables stringTables, FileRevisionDAO<SvnRevInfo> fileRevDAO, LicenseEnforcer licenseEnforcer) {
        super(status, dbh, stringTables, fileRevDAO, licenseEnforcer);
    }

    @Override
    public SvnChangeSet createChangeSet(String csid) {
        return new SvnChangeSet(Long.parseLong(csid), this, (SvnRevInfoDAO)this.fileRevDAO);
    }

    @Override
    protected void loadAttributes(EavEntityCu eav, SvnChangeSet svnCs) throws DbException, IOException {
        super.loadAttributes(eav, svnCs);
        svnCs.setRevProps(this.getRevProps(svnCs.getLongId()));
        svnCs.setTagParents(eav.getStrings(((SvnStringTables)this.stringTables).changeSetIdDB, SvnSchema.SvnChangeSetInfo.A_TAG_PARENT));
    }

    @Override
    protected void storeAttributes(EavEntityCu eav, long csDbId, SvnChangeSet svnCs) throws DbException, IOException {
        super.storeAttributes(eav, csDbId, svnCs);
        this.storeRevProps(svnCs);
        eav.updateStrings(((SvnStringTables)this.stringTables).changeSetIdDB, SvnSchema.SvnChangeSetInfo.A_TAG_PARENT, svnCs.getTagParents());
        this.storeCsid(svnCs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCsid(SvnChangeSet svnCs) throws IOException {
        y cu = y.a();
        try {
            long longId = svnCs.getLongId();
            cu.a(SvnSchema.E_SVN_CSID).b(longId);
            ac db = this.dbh.get();
            if (!db.a_(cu)) {
                db.e(cu, cu.e());
                if (this.lastCsid != -1L && longId > this.lastCsid) {
                    this.lastCsid = longId;
                }
            }
        }
        finally {
            cu.b();
        }
    }

    protected void storeRevProps(SvnChangeSet svnCs) throws DbException {
        long csid = svnCs.getLongId();
        try {
            ac db = this.dbh.get();
            y cu = y.a();
            cu.a(SvnSchema.E_CHANGESET_REV_PROPERTIES).b(csid);
            int keyLength = cu.e();
            while (db.a(cu, keyLength)) {
                db.c(cu);
            }
            Map<String, String> properties = svnCs.getRevProps();
            if (properties != null) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    long keyId = ((SvnStringTables)this.stringTables).propertyKeyDB.add(entry.getKey());
                    long valueId = ((SvnStringTables)this.stringTables).propertyValueDB.add(entry.getValue());
                    cu.f().a(SvnSchema.E_CHANGESET_REV_PROPERTIES).b(csid).b(keyId);
                    keyLength = cu.e();
                    cu.b(valueId);
                    db.e(cu, keyLength);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateRevProp(long csid, String key, String value) throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a();
            long keyId = ((SvnStringTables)this.stringTables).propertyKeyDB.add(key);
            long valueId = ((SvnStringTables)this.stringTables).propertyValueDB.add(value);
            cu.f().a(SvnSchema.E_CHANGESET_REV_PROPERTIES).b(csid).b(keyId);
            int keyLength = cu.e();
            cu.b(valueId);
            db.e(cu, keyLength);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void removeRevProps(long csid, Set<String> set) throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a();
            for (String key : set) {
                long keyId = ((SvnStringTables)this.stringTables).propertyKeyDB.find(key);
                if (keyId == -1L) continue;
                cu.f().a(SvnSchema.E_CHANGESET_REV_PROPERTIES).b(csid).b(keyId);
                int keyLength = cu.e();
                if (!db.a(cu, keyLength)) continue;
                db.c(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public Map<String, String> getRevProps(long csid) throws DbException {
        try {
            ac db = this.dbh.get();
            HashMap<String, String> result = new HashMap<String, String>();
            y cu = y.a().a(SvnSchema.E_CHANGESET_REV_PROPERTIES).b(csid);
            int keyLength = cu.e();
            while (db.a(cu, keyLength)) {
                long keyId = cu.v(keyLength);
                int offset = cu.w(keyLength);
                long valueId = cu.v(offset);
                String key = ((SvnStringTables)this.stringTables).propertyKeyDB.get(keyId);
                String value = ((SvnStringTables)this.stringTables).propertyValueDB.get(valueId);
                result.put(key, value);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public LongSortedSet getSvnChangeSetIds(long start, long end) {
        LongRBTreeSet result = new LongRBTreeSet();
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(SvnSchema.E_SVN_CSID);
            int pl = cu.e();
            cu.b(start - 1L).j();
            while (db.a(cu, pl)) {
                long csid = cu.v(pl);
                if (csid > end) {
                    break;
                }
                result.add(csid);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
        return result;
    }

    public ListIterable<Long> getCsidsFrom(long start) {
        if (start > this.getLastCsid()) {
            return ListIterable.UTILS.emptyListIterable();
        }
        y cu = y.a().a(SvnSchema.E_SVN_CSID);
        int l2 = cu.e();
        cu.b(start - 1L).j();
        return new InfDbIterable<Long>(this.dbh, cu, l2){

            @Override
            public Long getElement(y cu, int offset) throws IOException, DbException {
                return cu.v(offset);
            }
        };
    }

    public SortedSet<Long> getSvnChangeSetIdsWithLimit(long start, long limit, boolean reverse) {
        if (start > this.getLastCsid()) {
            return this.EMPTY_LONG_SORTED_SET;
        }
        return this.getLongIndexKeysWithLimit(SvnSchema.E_SVN_CSID, start, limit, reverse);
    }

    public long getPreviousCsid(long csid) {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(SvnSchema.E_SVN_CSID);
            int pl = cu.e();
            cu.b(csid);
            if (db.c(cu, pl)) {
                long l2 = cu.v(pl);
                return l2;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
        return -1L;
    }

    public long getLastCsid() {
        if (this.lastCsid != -1L) {
            return this.lastCsid;
        }
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(SvnSchema.E_SVN_CSID);
            int pl = cu.e();
            cu.j();
            if (db.c(cu, pl)) {
                long l2 = this.lastCsid = cu.v(pl);
                return l2;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
        return -1L;
    }

    public boolean isIndexed(long csid) {
        ac db = this.dbh.get();
        y cu = y.a();
        try {
            cu.a(SvnSchema.E_SVN_CSID);
            cu.b(csid);
            int pl = cu.e();
            boolean bl = db.b(cu, pl);
            return bl;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        finally {
            cu.b();
        }
    }
}

