/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.svn.MonitoredSvnThrottledClient;
import com.cenqua.fisheye.svn.SvnClientFactory;
import com.cenqua.fisheye.svn.SvnPasswordSupplier;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.util.RecentHistory;
import com.cenqua.fisheye.util.Throttle;
import org.apache.commons.pool.PoolableObjectFactory;

public class SvnThrottledClientFactory
implements PoolableObjectFactory {
    private final Throttle throttle;
    private final long timeout;
    private final String repoDescriptor;
    private RecentHistory recentActivities;
    private final SvnClientFactory svnClientFactory;

    public SvnThrottledClientFactory(String repoDescriptor, Throttle throttle, String repoURL, SvnPasswordSupplier passwordSupplier, long timeout, RecentHistory recentActivities) {
        this.svnClientFactory = new SvnClientFactory(passwordSupplier, repoURL);
        this.repoDescriptor = repoDescriptor;
        this.throttle = throttle;
        this.timeout = timeout;
        this.recentActivities = recentActivities;
    }

    public Object makeObject() throws Exception {
        return this.createThrottledClient();
    }

    public SvnThrottledClient createThrottledClient() {
        if (this.throttle == null) {
            throw new IllegalStateException("SVN client factory throttle not set");
        }
        return new MonitoredSvnThrottledClient(this.recentActivities, this.repoDescriptor, this.throttle, this.svnClientFactory, this.timeout);
    }

    public void destroyObject(Object object) throws Exception {
        if (object instanceof SvnThrottledClient) {
            SvnThrottledClient client = (SvnThrottledClient)object;
            client.dispose();
        }
    }

    public boolean validateObject(Object object) {
        return true;
    }

    public void activateObject(Object object) throws Exception {
    }

    public void passivateObject(Object object) throws Exception {
    }
}

