/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.RuntimeWrappedException;
import com.atlassian.util.IndexingStats;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.StopRequestedException;
import com.cenqua.fisheye.svn.DecoupledBlameCallback;
import com.cenqua.fisheye.svn.DecoupledDiffSummaryCallback;
import com.cenqua.fisheye.svn.DecoupledInfoCallback;
import com.cenqua.fisheye.svn.DecoupledListCallback;
import com.cenqua.fisheye.svn.DecoupledLogMessageCallback;
import com.cenqua.fisheye.svn.DecoupledProplistCallback;
import com.cenqua.fisheye.svn.SvnClientFactory;
import com.cenqua.fisheye.svn.SvnConstants;
import com.cenqua.fisheye.svn.SvnTask;
import com.cenqua.fisheye.util.ConfigurableThreadFactory;
import com.cenqua.fisheye.util.Throttle;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.callback.BlameCallback;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.ProplistCallback;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;

public class SvnThrottledClient {
    private final Throttle throttle;
    private final long timeout;
    private final String repoDescriptor;
    private final SvnClientFactory clientFactory;
    private static final ExecutorService executor;
    private ISVNClient client;
    public static final int MAX_SVNTHREADPOOL = 50;
    public static final long SVN_THREAD_KEEPALIVE_SECONDS = 60L;
    private SvnTask<?> currentTask;
    private IndexingStats stats = new IndexingStats();
    private boolean failOnTimeout;

    public SvnThrottledClient(String repoDescriptor, Throttle throttle, SvnClientFactory clientFactory, long timeout) {
        this.throttle = throttle;
        this.repoDescriptor = repoDescriptor;
        this.clientFactory = clientFactory;
        this.client = clientFactory.createSvnClient();
        this.timeout = timeout == -1L ? SvnConstants.DEFAULT_SVN_COMMAND_TIMEOUT : timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void resetStats() {
        this.stats.clear();
    }

    public IndexingStats getStats() {
        return this.stats;
    }

    protected void startOperation(String operationDescription) {
    }

    protected void finishOperation() {
    }

    public void info(final String repoPath, final Revision revision, final Revision pegRevision, final Depth depth, final InfoCallback callback) throws RepositoryClientException {
        StringBuilder command = new StringBuilder("svn info");
        if (depth == Depth.infinity) {
            command.append(" -R");
        }
        command.append(" -r ").append(revision).append(' ').append(repoPath).append('@').append(pegRevision);
        this.execute("info", command.toString(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DecoupledInfoCallback decoupled = new DecoupledInfoCallback(callback);
                try {
                    SvnThrottledClient.this.client.info2(repoPath, revision, pegRevision, depth, null, (InfoCallback)decoupled);
                }
                finally {
                    decoupled.decouple();
                }
                return null;
            }
        });
    }

    public void logMessages(final String path, final Revision pegRevision, final List<RevisionRange> ranges, final boolean stopOnCopy, final boolean discoverPath, final boolean includeMergedRevisions, final Set<String> revProps, final long limit, final LogMessageCallback callback) throws RepositoryClientException {
        StringBuilder command = new StringBuilder("svn log");
        if (discoverPath) {
            command.append(" -v");
        }
        if (stopOnCopy) {
            command.append(" --stop-on-copy");
        }
        if (limit != 0L) {
            command.append(" --limit ").append(limit);
        }
        command.append(" -r ").append(ranges.get(0).getFromRevision()).append(':').append(ranges.get(0).getToRevision()).append(' ').append(path).append('@').append(pegRevision);
        this.execute("log", command.toString(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DecoupledLogMessageCallback decoupledCallback = new DecoupledLogMessageCallback(callback);
                try {
                    SvnThrottledClient.this.client.logMessages(path, pegRevision, ranges, stopOnCopy, discoverPath, includeMergedRevisions, revProps, limit, (LogMessageCallback)decoupledCallback);
                }
                finally {
                    decoupledCallback.decouple();
                }
                return null;
            }
        });
    }

    private <V> V execute(String opName, String description, Callable<V> callable) throws RepositoryClientException {
        this.throttle.apply();
        return this.executeNoThrottle(opName, description, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V executeNoThrottle(String opName, String description, Callable<V> callable) throws RepositoryClientException {
        V result = null;
        SvnTask<V> task = new SvnTask<V>(this.repoDescriptor, "(" + Thread.currentThread().getName() + ") " + description, this.client, callable);
        this.startOperation(description);
        long startTime = System.currentTimeMillis();
        try {
            this.currentTask = task;
            executor.execute(task);
            result = task.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e2) {
            task.cancel(true);
            throw new RepositoryClientException("Operation cancelled", e2);
        }
        catch (ExecutionException e3) {
            Throwable cause = e3.getCause();
            if (cause instanceof RuntimeWrappedException) {
                cause = cause.getCause();
            }
            if (cause instanceof RepositoryClientException) {
                throw (RepositoryClientException)cause;
            }
            if (cause instanceof StopRequestedException) {
                throw (StopRequestedException)cause;
            }
            if (!(cause instanceof BreakException)) {
                throw new RepositoryClientException(cause);
            }
        }
        catch (RejectedExecutionException e4) {
            throw new RepositoryClientException(e4);
        }
        catch (TimeoutException e5) {
            task.cancel(true);
            this.client = this.clientFactory.createSvnClient();
            if (this.failOnTimeout) {
                throw new RepositoryClientException(e5);
            }
        }
        finally {
            this.currentTask = null;
            this.finishOperation();
            long duration = System.currentTimeMillis() - startTime;
            this.stats.addOperation(opName, description, duration);
        }
        return result;
    }

    public void diff(final String target, final Revision pegRevision, final Revision startRevision, final Revision endRevision, final String relativeToDir, final String outFileName, final Depth depth, final Collection<String> changelists, final boolean ignoreAncestry, final boolean noDiffDeleted, final boolean force, final boolean copiesAsAdds) throws RepositoryClientException {
        this.execute("diff", "svn diff -r " + startRevision + ":" + endRevision + " " + target + "@" + pegRevision, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SvnThrottledClient.this.client.diff(target, pegRevision, startRevision, endRevision, relativeToDir, outFileName, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds);
                return null;
            }
        });
    }

    public void diffSummarize(final String target, final Revision pegRevision, final Revision startRevision, final Revision endRevision, final Depth depth, final Collection<String> changelists, final boolean ignoreAncestry, final DiffSummaryCallback callback) throws RepositoryClientException {
        this.execute("diff summarize", "svn diff --summarize -r " + startRevision + ":" + endRevision + " " + target + "@" + pegRevision, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DecoupledDiffSummaryCallback decoupled = new DecoupledDiffSummaryCallback(callback);
                try {
                    SvnThrottledClient.this.client.diffSummarize(target, pegRevision, startRevision, endRevision, depth, changelists, ignoreAncestry, (DiffSummaryCallback)decoupled);
                }
                finally {
                    decoupled.decouple();
                }
                return null;
            }
        });
    }

    public void list(final String url, final Revision revision, final Revision pegRevision, final Depth depth, final int direntFields, final boolean fetchLocks, final ListCallback callback) throws RepositoryClientException {
        StringBuilder command = new StringBuilder("svn ls");
        if (depth == Depth.infinity) {
            command.append(" -R");
        }
        command.append(" -r ").append(revision).append(' ').append(url).append('@').append(pegRevision);
        this.execute("ls", command.toString(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DecoupledListCallback decoupled = new DecoupledListCallback(callback);
                try {
                    SvnThrottledClient.this.client.list(url, revision, pegRevision, depth, direntFields, fetchLocks, (ListCallback)decoupled);
                }
                finally {
                    decoupled.decouple();
                }
                return null;
            }
        });
    }

    public byte[] propertyGet(final String path, final String propertyName, final Revision rev, final Revision pegRevision) throws RepositoryClientException {
        return this.execute("propget", "svn propget " + propertyName + " -r " + rev + " " + path + "@" + pegRevision, new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return SvnThrottledClient.this.client.propertyGet(path, propertyName, rev, pegRevision);
            }
        });
    }

    public void blame(final String pathURL, final Revision pegRevision, final Revision start, final Revision end, final boolean ignoreMimeType, final boolean includeMergedRevisions, final BlameCallback callback) throws RepositoryClientException {
        this.execute("blame", "svn blame -r " + start + ":" + end + " " + pathURL + "@" + pegRevision, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DecoupledBlameCallback decoupled = new DecoupledBlameCallback(callback);
                try {
                    SvnThrottledClient.this.client.blame(pathURL, pegRevision, start, end, ignoreMimeType, includeMergedRevisions, (BlameCallback)decoupled);
                }
                finally {
                    decoupled.decouple();
                }
                return null;
            }
        });
    }

    public void doExport(final String pathURL, final String destPath, final Revision rev, final Revision pegRevision, final boolean force, final boolean ignoreExternals, final Depth depth, final String nativeEOL) throws RepositoryClientException {
        this.execute("cat", "svn cat -r " + rev + " " + pathURL + "@" + pegRevision, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SvnThrottledClient.this.client.doExport(pathURL, destPath, rev, pegRevision, force, ignoreExternals, depth, nativeEOL);
                return null;
            }
        });
    }

    public void properties(final String path, final Revision revision, final Revision pegRevision, final Depth depth, final Collection<String> changelists, final ProplistCallback callback) throws RepositoryClientException {
        StringBuilder command = new StringBuilder("svn proplist");
        if (depth == Depth.infinity) {
            command.append(" -R");
        }
        command.append(" -r ").append(revision).append(' ').append(path).append('@').append(pegRevision);
        this.execute("proplist", command.toString(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DecoupledProplistCallback decoupled = new DecoupledProplistCallback(callback);
                try {
                    SvnThrottledClient.this.client.properties(path, revision, pegRevision, depth, changelists, (ProplistCallback)decoupled);
                }
                finally {
                    decoupled.decouple();
                }
                return null;
            }
        });
    }

    public void streamFileContent(final String pathURL, final Revision revision, final Revision pegRevision, final OutputStream stream) throws RepositoryClientException {
        this.execute("cat", "svn cat -r " + revision + " " + pathURL + "@" + revision, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SvnThrottledClient.this.client.streamFileContent(pathURL, revision, pegRevision, stream);
                return null;
            }
        });
    }

    public Map<String, byte[]> revProperties(final String url, final Revision rev) throws RepositoryClientException {
        return this.execute("revprop proplist", "svn proplist --revprop -r " + rev + " " + url, new Callable<Map<String, byte[]>>(){

            @Override
            public Map<String, byte[]> call() throws Exception {
                return SvnThrottledClient.this.client.revProperties(url, rev);
            }
        });
    }

    public long checkout(final String moduleName, final String destPath, final Revision rev, final Revision pegRev, final Depth depth, final boolean ignoreExternals, final boolean allowUnverObstructions) throws RepositoryClientException {
        return this.execute("co", "svn co -r " + rev + " " + moduleName + "@" + pegRev, new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return SvnThrottledClient.this.client.checkout(moduleName, destPath, rev, pegRev, depth, ignoreExternals, allowUnverObstructions);
            }
        });
    }

    public void cancel() {
        SvnTask<?> task = this.currentTask;
        if (task != null) {
            Logs.APP_LOG.debug((Object)("Cancelling task on thread " + task.getExecutionThread()));
            task.cancel(true);
            this.currentTask = null;
        }
    }

    public void dispose() {
        this.client.dispose();
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    static {
        ConfigurableThreadFactory tf = new ConfigurableThreadFactory("SvnExecution", true);
        executor = new ThreadPoolExecutor(0, 50, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), tf);
    }

    public static class BreakException
    extends RuntimeException {
    }
}

