/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.NamedExecution;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ISVNClient;

public class SvnTask<V>
extends FutureTask<V> {
    private final String description;
    private final String context;
    private final ISVNClient client;
    private volatile Thread executionThread;

    public SvnTask(String context, String description, ISVNClient client, Callable<V> callable) {
        super(callable);
        this.context = context;
        this.client = client;
        this.description = description;
    }

    @Override
    public void run() {
        this.executionThread = Thread.currentThread();
        new NamedExecution(this.context).run(new Runnable(){

            @Override
            public void run() {
                try {
                    Logs.APP_LOG.debug((Object)("Executing " + SvnTask.this.description));
                    SvnTask.super.run();
                }
                finally {
                    SvnTask.this.executionThread = null;
                }
            }
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Logs.APP_LOG.info((Object)("Cancelling Subversion operation : " + this.description));
        try {
            this.client.cancelOperation();
        }
        catch (ClientException e2) {
            Logs.APP_LOG.debug((Object)"Problem cancelling svn operation", (Throwable)e2);
        }
        Thread blockedThread = this.executionThread;
        if (blockedThread != null) {
            StackTraceElement[] stackTrace = blockedThread.getStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Svn Thread stack:");
            for (StackTraceElement element : stackTrace) {
                pw.println("\tat " + element);
            }
            pw.close();
            Logs.APP_LOG.debug((Object)sw.toString());
        }
        return super.cancel(mayInterruptIfRunning);
    }

    public Thread getExecutionThread() {
        return this.executionThread;
    }
}

