/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.pipeline.ChangeSetEntry;
import com.atlassian.fisheye.pipeline.ChangeSetProcessor;
import com.atlassian.fisheye.pipeline.PipelinePhase;
import com.atlassian.fisheye.scmapi.BaseScmConfig;
import com.atlassian.fisheye.spi.admin.data.ImportMode;
import com.atlassian.fisheye.svn.Svn2ContentProcessor;
import com.atlassian.fisheye.svn.Svn2MetadataProcessor;
import com.atlassian.fisheye.svn.Svn2RepositoryEngine;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.RepositorySystemType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.config1.UserPassAuthType;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.NetworkRepositorySettings;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.svn.SvnConstants;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnRepositoryTester;
import com.cenqua.fisheye.svn.util.SvnLoader;
import com.cenqua.fisheye.util.Interval;
import com.google.common.base.Strings;
import java.nio.charset.Charset;

public class SvnScmConfig
extends BaseScmConfig {
    public static final int CACHE_VERSION = 33;
    private static final ChangeSetProcessor metadataProcessor = new Svn2MetadataProcessor();
    private static final ChangeSetProcessor contentProcessor = new Svn2ContentProcessor();
    private String mUrl;
    private String mRepoPath;
    private long blocksize;
    private Charset defaultCharset;
    private String accessKey;
    private SvnLogicalPathMatcher mPathMatcher;
    private NetworkRepositorySettings networkSettings;
    private long startRev;
    private ImportMode importMode;
    private Interval commandTimeout;
    private boolean followBase;
    private final SvnRepType svnConfig;

    public SvnScmConfig(String name, RootConfig rootConfig, RepositorySystemType scmConfig) {
        super(33, rootConfig);
        this.svnConfig = (SvnRepType)scmConfig;
        if (this.svnConfig == null) {
            throw new IllegalStateException(name + " did not contain expected <svn>");
        }
        this.mUrl = this.svnConfig.getUrl();
        this.mRepoPath = this.svnConfig.getPath();
        this.blocksize = this.svnConfig.isSetBlocksize() ? this.svnConfig.getBlocksize().longValue() : 400L;
        if (this.svnConfig.isSetCharset()) {
            String cs = this.svnConfig.getCharset();
            try {
                this.defaultCharset = Charset.forName(cs);
            }
            catch (IllegalArgumentException e2) {
                this.setConfigException(new ConfigException("Not a valid encoding name: '" + cs + "'. Valid names are " + Charset.availableCharsets().keySet(), e2));
            }
        } else {
            this.defaultCharset = SvnConstants.DEFAULT_SVN_ENCODING;
        }
        this.accessKey = this.svnConfig.isSetAccess() ? this.svnConfig.getAccess() : null;
        if (this.svnConfig.isSetSymbolic()) {
            SvnSymbolicType symbolic = this.svnConfig.getSymbolic();
            try {
                this.mPathMatcher = new SvnLogicalPathMatcher(symbolic);
            }
            catch (ConfigException e3) {
                this.setConfigException(e3);
            }
        } else {
            this.mPathMatcher = new SvnLogicalPathMatcher();
        }
        UserPassAuthType auth = this.svnConfig.isSetAuth() ? this.svnConfig.getAuth() : null;
        float cpsLimit = this.svnConfig.isSetCps() ? this.svnConfig.getCps() : 0.0f;
        this.networkSettings = new NetworkRepositorySettings(auth, this.parseUpdateSettings(), cpsLimit);
        this.startRev = this.svnConfig.isSetStartRev() ? this.svnConfig.getStartRev().longValue() : 0L;
        if (this.svnConfig.isSetInitialImport()) {
            this.importMode = ImportMode.fromString((String)this.svnConfig.getInitialImport());
        }
        if (this.svnConfig.isSetCommandTimeout() && !Strings.isNullOrEmpty((String)this.svnConfig.getCommandTimeout().trim())) {
            String commandTimeoutStr = this.svnConfig.getCommandTimeout();
            try {
                this.commandTimeout = new Interval(commandTimeoutStr);
            }
            catch (NumberFormatException e4) {
                this.setConfigException("Command timeout interval is not valid: " + commandTimeoutStr);
            }
        } else {
            this.commandTimeout = null;
        }
        this.followBase = this.svnConfig.isSetFollowBase() && this.svnConfig.getFollowBase();
        try {
            SvnLoader.checkLoaded();
        }
        catch (ConfigException e5) {
            this.setConfigException(e5);
        }
    }

    @Override
    public RepositoryEngine createRepositoryEngine(RepositoryConfig repoConfig, UpgradeManager upgradeManager, IndexingContext indexingContext) {
        return new Svn2RepositoryEngine(repoConfig, upgradeManager, indexingContext);
    }

    @Override
    public void reloadUpdateSettings() {
        String pollPeriod = this.parseUpdateSettings();
        this.networkSettings.setPollPeriod(pollPeriod);
    }

    private String parseUpdateSettings() {
        String pollPeriod = null;
        if (this.svnConfig.isSetUpdater()) {
            pollPeriod = this.svnConfig.getUpdater().getPollPeriod();
        } else if (this.defaults != null && this.defaults.isSetUpdater()) {
            pollPeriod = this.defaults.getUpdater().getPolled().getPollPeriod();
        }
        return pollPeriod;
    }

    @Override
    public void testConnection(RepositoryConfig config) throws ConfigException {
        SvnRepositoryTester tester = new SvnRepositoryTester(config);
        try {
            tester.testConnection();
        }
        finally {
            tester.dispose();
        }
    }

    @Override
    public ScmType getRepositoryType() {
        return ScmType.SVN;
    }

    public NetworkRepositorySettings getNetworkSettings() {
        return this.networkSettings;
    }

    public String getRepoUrl() {
        return this.mUrl;
    }

    public String getRepoPath() {
        return this.mRepoPath;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public SvnLogicalPathMatcher getPathMatcher() {
        return this.mPathMatcher;
    }

    public long getBlocksize() {
        return this.blocksize;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public long getStartRev() {
        return this.startRev;
    }

    public ImportMode getImportMode() {
        return this.importMode;
    }

    public boolean isFollowBase() {
        return this.followBase;
    }

    public Interval getCommandTimeout() {
        return this.commandTimeout;
    }

    @Override
    public ChangeSetProcessor getProcessorForPhase(PipelinePhase phase) {
        switch (phase) {
            case METADATA: {
                return metadataProcessor;
            }
            case INDEXING: {
                return contentProcessor;
            }
        }
        return new ChangeSetProcessor(){

            @Override
            public boolean processChangesetEntry(RepositoryHandle handle, ChangeSetEntry entry) throws Exception {
                return true;
            }
        };
    }
}

