/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.NetworkRepositorySettings;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RepositoryTester;
import com.cenqua.fisheye.svn.SvnClientFactory;
import com.cenqua.fisheye.svn.SvnPasswordSupplier;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnScmConfig;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.util.SvnPropertyUtil;
import com.cenqua.fisheye.util.FileUtils;
import com.cenqua.fisheye.util.MD5;
import com.cenqua.fisheye.util.Throttle;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Revision;

public class SvnRepositoryTester
extends RepositoryTester {
    private final SvnThrottledClient svnClient;
    private final SvnRepositoryInfo repInfo;
    private final String accessKey;

    public SvnRepositoryTester(RepositoryConfig config) {
        this.repInfo = new SvnRepositoryInfo(config);
        SvnScmConfig svnConfig = (SvnScmConfig)config.getScmConfig();
        NetworkRepositorySettings networkSettings = svnConfig.getNetworkSettings();
        SvnPasswordSupplier passwordSupplier = new SvnPasswordSupplier(networkSettings.getUsername(), networkSettings.getPassword(), new RepositoryStatus(this.repInfo.getName()));
        Throttle throttle = new Throttle();
        SvnClientFactory factory = new SvnClientFactory(passwordSupplier, this.repInfo.getRepositoryURL());
        this.svnClient = new SvnThrottledClient("testing", throttle, factory, 300000L);
        this.accessKey = svnConfig.getAccessKey();
    }

    public SvnRepositoryTester(SvnThrottledClient svnClient, SvnRepositoryInfo repInfo, String accessKey) {
        this.svnClient = svnClient;
        this.repInfo = repInfo;
        this.accessKey = accessKey;
    }

    @Override
    public void testConnection() throws ConfigException {
        RepositoryStatus status = new RepositoryStatus(this.repInfo.getName());
        this.checkRepoSettings();
        this.pingAndValidateAccess(this.repInfo.getLatestRepositoryRoot(), status);
    }

    public void checkRepoSettings() throws ConfigException {
        Logs.APP_LOG.debug((Object)("Checking repository:  " + this.repInfo.getRepositoryDescriptor()));
        String rootURL = this.getServerRootURL(this.svnClient);
        if (rootURL != null && !FileUtils.normaliseSeparators(rootURL).equalsIgnoreCase(FileUtils.normaliseSeparators(this.repInfo.getRepositoryURL()))) {
            Logs.APP_LOG.warn((Object)("Repository URL " + this.repInfo.getRepositoryURL() + " does not match URL returned from repository: " + rootURL));
        }
    }

    public String getServerRootURL(SvnThrottledClient svnClient) {
        String rootURL;
        final AtomicReference infoRef = new AtomicReference();
        try {
            svnClient.info(this.repInfo.getLatestRepositoryRoot(), Revision.HEAD, Revision.HEAD, Depth.empty, new InfoCallback(){

                public void singleInfo(Info info) {
                    infoRef.set(info);
                }
            });
        }
        catch (RepositoryClientException e2) {
            Logs.APP_LOG.warn((Object)("Unable to get info for the repository root for " + this.repInfo.getName()), (Throwable)e2);
        }
        if (infoRef.get() == null) {
            try {
                final AtomicReference dirEntryRef = new AtomicReference();
                svnClient.list(this.repInfo.getRepositoryRoot(-1L), Revision.HEAD, Revision.HEAD, Depth.immediates, -1, false, new ListCallback(){

                    public void doEntry(DirEntry dirEntry, Lock lock) {
                        dirEntryRef.set(dirEntry);
                        throw new SvnThrottledClient.BreakException();
                    }
                });
                if (dirEntryRef.get() != null) {
                    String entryURL = this.repInfo.getPathURL(this.repInfo.getLocalPath(((DirEntry)dirEntryRef.get()).getPath(), -1L), -1L);
                    svnClient.info(entryURL, Revision.HEAD, Revision.HEAD, Depth.empty, new InfoCallback(){

                        public void singleInfo(Info info) {
                            infoRef.set(info);
                        }
                    });
                }
            }
            catch (RepositoryClientException repositoryClientException) {
                // empty catch block
            }
        }
        if (infoRef.get() != null) {
            rootURL = ((Info)infoRef.get()).getReposRootUrl();
        } else {
            rootURL = null;
            Logs.APP_LOG.warn((Object)("Unable to get Repository Root URL for " + this.repInfo.getRepositoryDescriptor()));
        }
        return rootURL;
    }

    void pingAndValidateAccess(String repoPath, RepositoryStatus statusReporter) throws ConfigException {
        String accessData;
        try {
            Logs.APP_LOG.debug((Object)("Validating access to " + repoPath));
            byte[] feAccess = this.svnClient.propertyGet(repoPath, "fisheye.access", Revision.HEAD, Revision.HEAD);
            if (feAccess != null) {
                accessData = SvnPropertyUtil.getStringValue(feAccess);
                Logs.APP_LOG.debug((Object)("FishEye Access property found [" + accessData + "]"));
            } else {
                Logs.APP_LOG.debug((Object)"FishEye Access property is null");
                accessData = null;
            }
        }
        catch (Exception e2) {
            statusReporter.setMessage("Could not access " + repoPath);
            Logs.APP_LOG.error((Object)"Exception getting FishEye access control", (Throwable)e2);
            throw new ConfigException("Could not access " + repoPath + " : " + e2.getMessage(), e2);
        }
        if (!this.isAccessGranted(accessData)) {
            statusReporter.setMessage("Unable to scan repository as it is not configured for remote FishEye access");
            throw new ConfigException("The repository " + repoPath + " is not configured for remote FishEye access." + " It needs a " + "fisheye.access" + " property, see the documentation.");
        }
    }

    private boolean isAccessGranted(String accessData) {
        if (accessData == null) {
            return true;
        }
        String serverAccessKey = accessData.trim();
        if (serverAccessKey.equals("allow")) {
            return true;
        }
        if (serverAccessKey.equals("deny")) {
            return false;
        }
        if (serverAccessKey.toLowerCase().startsWith("md5:") && this.accessKey != null) {
            String serverHash = serverAccessKey.substring("md5:".length());
            String computedHash = MD5.hash(this.accessKey);
            if (computedHash.equalsIgnoreCase(serverHash)) {
                return true;
            }
            Logs.APP_LOG.warn((Object)"Access denied by server - hash mismatch");
        }
        return false;
    }

    public void dispose() {
        this.svnClient.dispose();
    }
}

