/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.rep.RepositoryInfo;
import com.cenqua.fisheye.svn.RepositoryHistoryTraversal;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnScmConfig;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.util.SvnRepositoryPathUtil;
import com.cenqua.fisheye.svn.util.SvnURLDecoder;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.subversion.javahl.types.Info;

public class SvnRepositoryInfo
extends RepositoryInfo {
    public static final int LATEST_ROOT_SENTINEL = -1;
    private Locale locale = Locale.getDefault();
    private SortedMap<Long, String> repositoryBaseHistory = new TreeMap<Long, String>();
    private boolean isCaseSensitive = true;
    private SvnScmConfig svnConfig;
    private String repositoryURL;
    private String repositoryBase;
    private final SvnRepositoryPathUtil svnRepositoryPathUtil = new SvnRepositoryPathUtil();

    public SvnRepositoryInfo(RepositoryConfig config) {
        super(config);
        this.svnConfig = (SvnScmConfig)config.getScmConfig();
        this.setRepositoryLocation(this.svnConfig.getRepoUrl(), this.svnConfig.getRepoPath());
        this.setStartRev(this.svnConfig.getStartRev());
        this.setImportMode(this.svnConfig.getImportMode());
        if (this.svnConfig.getCommandTimeout() != null) {
            this.setCommandTimeout(this.svnConfig.getCommandTimeout().getValueInMillis());
        }
    }

    public boolean isFollowBaseHistory() {
        return this.svnConfig.isFollowBase();
    }

    private void setRepositoryLocation(String repositoryURL, String repositoryBase) {
        this.repositoryURL = this.svnRepositoryPathUtil.normalizeURL(repositoryURL);
        this.repositoryBase = new Path(repositoryBase).normalize().getPath();
        this.repositoryBaseHistory.clear();
        this.repositoryBaseHistory.put(0L, repositoryBase);
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    public String getRepositoryRoot(long rev) {
        return this.getRepositoryURL() + "/" + this.getRepositoryBase(rev);
    }

    public String getLatestRepositoryRoot() {
        return this.getRepositoryURL() + "/" + this.getRepositoryBase(-1L);
    }

    public String getPathURL(Path path, long rev) {
        Path basePath = new Path(this.getRepositoryBase(rev));
        return this.svnRepositoryPathUtil.getPathURL(this.repositoryURL, basePath, path);
    }

    @Override
    public Path getLocalPath(String serverPath, long rev) {
        return new Path(serverPath).getRelativePath(new Path(this.getRepositoryBase(rev)));
    }

    public Path pathFromInfo(Info info, long rev) {
        try {
            String url = info.getUrl();
            String rootUrl = info.getReposRootUrl();
            return this.pathFromURL(url, rootUrl, rev);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
    }

    public Path pathFromURL(String url, String rootUrl, long rev) throws UnsupportedEncodingException {
        String serverPath = url.substring(rootUrl.length());
        serverPath = SvnURLDecoder.decode(serverPath, "UTF-8");
        return this.getLocalPath(serverPath, rev);
    }

    @Override
    public String getRepositoryDescriptor() {
        Long last = this.repositoryBaseHistory.lastKey();
        return this.getName() + ":" + this.getRepositoryURL() + "/" + this.getRepositoryBase(last);
    }

    @Override
    public String getServerPath(Path localPath, long rev) {
        Path basePath = new Path(this.getRepositoryBase(rev));
        return "/" + new Path(basePath, localPath).normalize().getPath();
    }

    public SvnLogicalPathMatcher getPathMatcher() {
        return this.svnConfig.getPathMatcher();
    }

    public Charset getDefaultCharset() {
        return this.svnConfig.getDefaultCharset();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getRepositoryBase(long rev) {
        Long actualRev;
        if (rev == -1L) {
            actualRev = this.repositoryBaseHistory.lastKey();
        } else {
            SortedMap<Long, String> headMap = this.repositoryBaseHistory.headMap(rev + 1L);
            actualRev = headMap.lastKey();
        }
        return (String)this.repositoryBaseHistory.get(actualRev);
    }

    public void fillInRepositoryBasePathHistory(SvnThrottledClient svnClient) throws ConfigException {
        if (!this.svnConfig.isFollowBase()) {
            return;
        }
        RepositoryHistoryTraversal traversal = new RepositoryHistoryTraversal();
        this.repositoryBaseHistory = traversal.traverse(svnClient, this.repositoryURL, this.repositoryBase);
    }

    public SvnScmConfig getSvnConfig() {
        return this.svnConfig;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }
}

