/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.util.VariableSubstituter;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SvnPathRule {
    private final Pattern regex;
    private final String namePattern;
    private final String pathPattern;

    public SvnPathRule(Pattern regex, String namePattern, String pathPattern) {
        this.regex = regex;
        this.namePattern = namePattern;
        this.pathPattern = pathPattern;
    }

    public Match apply(Path path, String id) {
        String input = path.getPath();
        Matcher m2 = this.regex.matcher(input);
        if (m2.lookingAt()) {
            int end = m2.end();
            String tail = null;
            String root = null;
            if (end <= input.length()) {
                root = input.substring(0, end);
                tail = input.substring(end, input.length());
            }
            return new Match(m2, root, tail, id);
        }
        return null;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((String)this.regex.pattern());
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SvnPathRule that = (SvnPathRule)o2;
        if (this.namePattern != null ? !this.namePattern.equals(that.namePattern) : that.namePattern != null) {
            return false;
        }
        if (this.pathPattern != null ? !this.pathPattern.equals(that.pathPattern) : that.pathPattern != null) {
            return false;
        }
        return !(this.regex != null ? !this.regex.pattern().equals(that.regex.pattern()) : that.regex != null);
    }

    public int hashCode() {
        int result = this.regex != null ? this.regex.pattern().hashCode() : 0;
        result = 31 * result + (this.namePattern != null ? this.namePattern.hashCode() : 0);
        result = 31 * result + (this.pathPattern != null ? this.pathPattern.hashCode() : 0);
        return result;
    }

    public class Match {
        private final Matcher match;
        private final String tail;
        private final String root;
        private String id;

        public Match(Matcher match, String root, String tail, String id) {
            this.match = match;
            this.root = root;
            this.tail = tail;
            this.id = id;
        }

        public String getName() {
            return this.evaluate(SvnPathRule.this.namePattern);
        }

        public String getId() {
            return this.id;
        }

        public Path getLogicalPath() {
            String p2 = this.evaluate(SvnPathRule.this.pathPattern);
            Path logicalPath = new Path(p2);
            if (this.tail != null) {
                logicalPath = new Path(logicalPath, this.tail);
            }
            return logicalPath;
        }

        public Path getLogicalTail() {
            return new Path(this.tail);
        }

        public Path getRoot() {
            return new Path(this.root);
        }

        private String evaluate(String pattern) {
            HashMap<String, String> vars = new HashMap<String, String>();
            for (int i2 = 1; i2 <= this.match.groupCount(); ++i2) {
                vars.put(Integer.toString(i2), this.match.group(i2));
            }
            return VariableSubstituter.substituteRefs((CharSequence)pattern, vars);
        }
    }
}

