/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryStatus;
import org.apache.subversion.javahl.callback.UserPasswordCallback;

public class SvnPasswordSupplier
implements UserPasswordCallback {
    private static final int MAX_PASSWD_REQUEST = 50;
    private static final int PASSWD_REQUEST_WINDOW = 10000;
    private String username;
    private String password;
    private long start;
    private int count;
    private RepositoryStatus status;

    public SvnPasswordSupplier(String username, String password, RepositoryStatus status) {
        this.username = username;
        this.password = password;
        this.status = status;
    }

    public boolean prompt(String realm, String user, boolean maySave) {
        if (this.status.isStopRequested()) {
            return false;
        }
        Logs.APP_LOG.debug((Object)("prompting for realm: " + realm + " with username: " + user + ", maySave = " + maySave));
        if (this.username == null) {
            throw new RuntimeException("Subversion username and password required for " + realm + " but not provided in config.");
        }
        if (!this.username.equals(user)) {
            Logs.APP_LOG.debug((Object)("System prompted for user " + user + ", which does not match configured username " + this.username));
        }
        if (this.count < 50) {
            return true;
        }
        Logs.APP_LOG.warn((Object)("SVN is requesting password too often for realm '" + realm + "' and user '" + user + "'"));
        return false;
    }

    public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
        return null;
    }

    public boolean userAllowedSave() {
        return false;
    }

    public int askTrustSSLServer(String info, boolean allowPermanently) {
        return 2;
    }

    public boolean prompt(String realm, String user) {
        return false;
    }

    public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
        return yesIsDefault;
    }

    public String askQuestion(String realm, String question, boolean showAnswer) {
        return null;
    }

    public String getUsername() {
        if (this.status.isStopRequested()) {
            throw new RuntimeException("Repository is stopping");
        }
        return this.username;
    }

    public String getPassword() {
        Logs.APP_LOG.debug((Object)"Getting password");
        if (this.status.isStopRequested()) {
            throw new RuntimeException("Repository is stopping");
        }
        long now = System.currentTimeMillis();
        if (now - this.start < 10000L) {
            ++this.count;
        } else {
            this.start = now;
            this.count = 1;
        }
        return this.password;
    }

    public void resetCount() {
        this.count = 0;
    }
}

