/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.CustomFileNameMap;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SvnMimeUtils {
    public static final Pattern SVN_MIME_REGEX = Pattern.compile("([^;]*)(;.*)?");
    public static final Pattern SVN_CHARSET_REGEX = Pattern.compile(".*;\\s*charset\\s*=\\s*\"?([^;\"]*).*");

    public static boolean isBinaryMimeType(CustomFileNameMap mimeMap, String mimeType) {
        if (mimeType == null || mimeMap == null) {
            return false;
        }
        Matcher m2 = SVN_MIME_REGEX.matcher(mimeType.toLowerCase());
        if (m2.matches() && m2.group(1) != null) {
            String rawMimeType = m2.group(1);
            return mimeMap.isBinaryMimeType(rawMimeType.toLowerCase());
        }
        return false;
    }

    public static Charset getMimeTypeCharset(String mimeType) {
        Matcher m2;
        Charset result = null;
        if (mimeType != null && (m2 = SVN_CHARSET_REGEX.matcher(mimeType.toLowerCase())).matches() && m2.group(1) != null) {
            String charset = m2.group(1);
            try {
                result = Charset.forName(charset);
            }
            catch (UnsupportedCharsetException e2) {
                Logs.APP_LOG.error((Object)("Charset from " + mimeType + " is not supported."));
            }
        }
        return result;
    }
}

