/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.SvnSymbolicRuleType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.rep.LogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnPathRule;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SvnLogicalPathMatcher
implements LogicalPathMatcher {
    public static final String TRUNK_ID = "trunk:";
    public static final String BRANCH_ID = "branch:";
    public static final String TAG_ID = "tag:";
    public static final String ROOT_ID = "root:";
    private List<SvnPathRule> trunkRules = new ArrayList<SvnPathRule>();
    private List<SvnPathRule> branchRules = new ArrayList<SvnPathRule>();
    private List<SvnPathRule> tagRules = new ArrayList<SvnPathRule>();
    private boolean autorules = false;
    private static final Interner<String> nameCache = Interners.newWeakInterner();
    private static final Interner<Path> pathCache = Interners.newWeakInterner();

    public SvnLogicalPathMatcher() {
    }

    public boolean isEmpty() {
        return this.trunkRules.isEmpty() && this.branchRules.isEmpty() && this.tagRules.isEmpty();
    }

    public SvnLogicalPathMatcher(SvnSymbolicType symbolic) throws ConfigException {
        if (symbolic != null) {
            SvnSymbolicRuleType[] tagRules;
            SvnSymbolicRuleType[] branchRules;
            SvnSymbolicRuleType[] trunkRules;
            for (SvnSymbolicRuleType trunkRule : trunkRules = symbolic.getTrunkArray()) {
                this.addTrunkRule(this.parseSymbolRule(trunkRule));
            }
            for (SvnSymbolicRuleType branchRule : branchRules = symbolic.getBranchArray()) {
                this.addBranchRule(this.parseSymbolRule(branchRule));
            }
            for (SvnSymbolicRuleType tagRule : tagRules = symbolic.getTagArray()) {
                this.addTagRule(this.parseSymbolRule(tagRule));
            }
            if (symbolic.getAutoRules()) {
                this.autorules = symbolic.getAutoRules();
                this.addAutoRules();
            }
        }
    }

    private void addAutoRules() {
        String winner = "((?:[^/]+(?<!(?:^|/)(?:trunk|branches|tags))/)*)";
        this.addTrunkRule(new SvnPathRule(Pattern.compile(winner + "trunk(/|$)"), "trunk", "${1}"));
        this.addBranchRule(new SvnPathRule(Pattern.compile(winner + "branches/([^/]+)"), "${2}", "${1}"));
        this.addTagRule(new SvnPathRule(Pattern.compile(winner + "tags/([^/]+)"), "${2}", "${1}"));
    }

    private SvnPathRule parseSymbolRule(SvnSymbolicRuleType rule) throws ConfigException {
        Pattern p2;
        try {
            p2 = Pattern.compile(rule.getRegex());
        }
        catch (PatternSyntaxException e2) {
            throw new ConfigException(e2);
        }
        return new SvnPathRule(p2, rule.getName(), rule.getLogical());
    }

    public void addTrunkRule(SvnPathRule rule) {
        if (!rule.isEmpty()) {
            this.trunkRules.add(rule);
        }
    }

    public void addBranchRule(SvnPathRule rule) {
        if (!rule.isEmpty()) {
            this.branchRules.add(rule);
        }
    }

    public void addTagRule(SvnPathRule rule) {
        if (!rule.isEmpty()) {
            this.tagRules.add(rule);
        }
    }

    public String getTag(Path path) {
        String tagName = null;
        String containerId = this.getContainerId(path);
        if (containerId.startsWith(TAG_ID)) {
            tagName = this.getFromNameCache(containerId);
        }
        return tagName;
    }

    public Path getTagRoot(Path path) {
        return this.isTag(path) ? this.getPhysicalRoot(path) : null;
    }

    public boolean isTagRoot(Path path) {
        return path.equals(this.getTagRoot(path));
    }

    public Path getBranchRoot(Path path) {
        return this.isBranch(path) ? this.getPhysicalRoot(path) : null;
    }

    public boolean isBranchRoot(Path path) {
        return path.equals(this.getBranchRoot(path));
    }

    @Override
    public String getBranch(Path path) {
        String branchName = null;
        String containerId = this.getContainerId(path);
        if (containerId.startsWith(BRANCH_ID)) {
            branchName = this.getFromNameCache(containerId);
        }
        return branchName;
    }

    private boolean isTrunkName(String match) {
        for (SvnPathRule trunkRule : this.trunkRules) {
            if (!match.equals(trunkRule.getNamePattern())) continue;
            return true;
        }
        return false;
    }

    public String getTrunk(Path path) {
        String trunkName = null;
        String containerId = this.getContainerId(path);
        if (containerId.startsWith(TRUNK_ID)) {
            trunkName = this.getFromNameCache(containerId);
        }
        return trunkName;
    }

    public String getBranchOrTrunk(Path path) {
        String containerId = this.getContainerId(path);
        if (containerId.startsWith(BRANCH_ID) || containerId.startsWith(TRUNK_ID)) {
            return this.getFromNameCache(containerId);
        }
        return null;
    }

    private String getFromNameCache(String containerId) {
        return (String)nameCache.intern((Object)containerId.substring(containerId.indexOf(58) + 1));
    }

    private SvnPathRule.Match findBestMatch(Path p2) {
        SvnPathRule.Match match = this.findBestMatch(this.branchRules, p2, BRANCH_ID);
        if (match != null) {
            return match;
        }
        match = this.findBestMatch(this.tagRules, p2, TAG_ID);
        if (match != null) {
            return match;
        }
        match = this.findBestMatch(this.trunkRules, p2, TRUNK_ID);
        if (match != null) {
            return match;
        }
        return null;
    }

    private SvnPathRule.Match findBestMatch(List<SvnPathRule> rules, Path path, String id) {
        SvnPathRule.Match bestMatch = null;
        int bestTailLength = 0;
        for (SvnPathRule rule : rules) {
            SvnPathRule.Match match = rule.apply(path, id);
            if (match == null) continue;
            if (bestMatch == null) {
                bestMatch = match;
                bestTailLength = match.getLogicalTail().getPath().length();
                continue;
            }
            Path tail = match.getLogicalTail();
            int length = tail.getPath().length();
            if (length >= bestTailLength) continue;
            bestMatch = match;
            bestTailLength = length;
        }
        return bestMatch;
    }

    @Override
    public Path getLogicalPath(Path physicalPath) {
        SvnPathRule.Match match = this.findBestMatch(physicalPath);
        if (match != null) {
            return (Path)pathCache.intern((Object)match.getLogicalPath());
        }
        return null;
    }

    @Override
    public Path getLogicalTail(Path physicalPath) {
        SvnPathRule.Match match = this.findBestMatch(physicalPath);
        if (match != null) {
            return (Path)pathCache.intern((Object)match.getLogicalTail());
        }
        return null;
    }

    public Path getPhysicalRoot(Path physicalPath) {
        SvnPathRule.Match match = this.findBestMatch(physicalPath);
        if (match != null) {
            return (Path)pathCache.intern((Object)match.getRoot());
        }
        return null;
    }

    public boolean isPhysicalRoot(Path physicalPath) {
        return physicalPath.equals(this.getPhysicalRoot(physicalPath));
    }

    public String getContainerId(Path p2) {
        SvnPathRule.Match match = this.findBestMatch(p2);
        if (match != null) {
            String name = match.getName();
            if (!match.getId().equals(TRUNK_ID)) {
                while (this.isTrunkName(name)) {
                    name = ":" + name;
                }
                name = name.replace('/', '-');
            }
            return match.getId() + name;
        }
        return ROOT_ID;
    }

    @Override
    public boolean isTag(Path p2) {
        return this.getContainerId(p2).startsWith(TAG_ID);
    }

    @Override
    public boolean isBranch(Path p2) {
        return this.getContainerId(p2).startsWith(BRANCH_ID);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SvnLogicalPathMatcher that = (SvnLogicalPathMatcher)o2;
        if (this.branchRules != null ? !this.branchRules.equals(that.branchRules) : that.branchRules != null) {
            return false;
        }
        if (this.tagRules != null ? !this.tagRules.equals(that.tagRules) : that.tagRules != null) {
            return false;
        }
        if (this.trunkRules != null ? !this.trunkRules.equals(that.trunkRules) : that.trunkRules != null) {
            return false;
        }
        return this.autorules == that.autorules;
    }

    public int hashCode() {
        int result = this.trunkRules != null ? this.trunkRules.hashCode() : 0;
        result = 31 * result + (this.branchRules != null ? this.branchRules.hashCode() : 0);
        result = 31 * result + (this.tagRules != null ? this.tagRules.hashCode() : 0);
        result = 31 * result + (this.autorules ? 0 : 1);
        return result;
    }

    public String getEffectiveBranch(Path path) {
        String containerId = this.getContainerId(path);
        if (containerId.startsWith(TRUNK_ID)) {
            return this.getTrunk(path);
        }
        if (containerId.startsWith(BRANCH_ID)) {
            return this.getBranch(path);
        }
        if (containerId.startsWith(TAG_ID)) {
            if (this.isTagRoot(path)) {
                return ROOT_ID;
            }
            return TAG_ID + this.getTag(path);
        }
        return ROOT_ID;
    }
}

