/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.svn.SvnChangePath;
import com.cenqua.fisheye.svn.util.SvnPropertyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.Revision;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.ISODateTimeFormat;

public class SvnLogMessage {
    private static final DateTimeFormatter REVPROP_DATE_FMT = new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateTimeParser()).toFormatter();
    private Map<String, String> revProps;
    private List<SvnChangePath> changePaths;
    private long revisionNumber;
    private String author;
    private Date date;
    private String comment;

    public SvnLogMessage(Set<ChangePath> changePaths, long revision, Map<String, byte[]> revProps) {
        if (changePaths != null) {
            this.changePaths = new ArrayList<SvnChangePath>(changePaths.size());
            for (ChangePath changePath : changePaths) {
                this.changePaths.add(new SvnChangePath(changePath));
            }
        } else {
            this.changePaths = Collections.emptyList();
        }
        this.revisionNumber = revision;
        if (revProps != null) {
            this.revProps = new HashMap<String, String>();
            for (Map.Entry entry : revProps.entrySet()) {
                this.revProps.put((String)entry.getKey(), SvnPropertyUtil.getStringValue((byte[])entry.getValue()));
            }
        }
    }

    public SvnLogMessage(long revisionNumber, Map<String, String> revProps) {
        this.changePaths = Collections.emptyList();
        this.revisionNumber = revisionNumber;
        this.revProps = revProps;
    }

    public SvnLogMessage(List<SvnChangePath> changePaths, long revision, Map<String, String> revProps) {
        this.changePaths = changePaths != null ? new ArrayList<SvnChangePath>(changePaths) : Collections.emptyList();
        this.revisionNumber = revision;
        this.revProps = revProps;
    }

    public String getAuthor() {
        if (this.author == null) {
            this.author = this.revProps.get("svn:author");
            if (this.author == null) {
                this.author = "no_author";
            }
        }
        return this.author;
    }

    public Date getDate() {
        if (this.date == null) {
            String dateString = this.revProps.get("svn:date");
            this.date = dateString != null ? this.parseDate(dateString) : new Date(0L);
        }
        return this.date;
    }

    private Date parseDate(String dateString) {
        try {
            return REVPROP_DATE_FMT.parseDateTime(dateString).toDate();
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)("Error parsing date for revision " + this.getRevisionNumber()), (Throwable)e2);
            return null;
        }
    }

    public String getMessage() {
        if (this.comment == null) {
            this.comment = this.revProps.get("svn:log");
            if (this.comment == null) {
                this.comment = "";
            }
        }
        return this.comment;
    }

    public List<SvnChangePath> getChangePaths() {
        return this.changePaths;
    }

    public int getNumChangePaths() {
        return this.changePaths.size();
    }

    public long getRevisionNumber() {
        return this.revisionNumber;
    }

    public Revision getRevision() {
        return new Revision.Number(this.revisionNumber);
    }

    public Map<String, String> getRevProps() {
        return this.revProps;
    }
}

