/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.svn.SvnPasswordSupplier;
import com.cenqua.fisheye.svn.SvnkitPasswordSupplier;
import com.cenqua.fisheye.svn.util.SvnLoader;
import com.cenqua.fisheye.svn.util.SvnLoaderConfiguration;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.SVNClient;
import org.apache.subversion.javahl.callback.UserPasswordCallback;

public class SvnClientFactory {
    private final SvnPasswordSupplier passwordSupplier;
    private final String repoURL;
    private final SvnLoaderConfiguration svnLoaderConfiguration;

    public SvnClientFactory(SvnPasswordSupplier passwordSupplier, String repoURL, SvnLoaderConfiguration svnLoaderConfiguration) {
        this.passwordSupplier = passwordSupplier;
        this.repoURL = repoURL;
        this.svnLoaderConfiguration = svnLoaderConfiguration;
    }

    public SvnClientFactory(SvnPasswordSupplier passwordSupplier, String repoURL) {
        this(passwordSupplier, repoURL, SvnLoader.getConfiguration());
    }

    public ISVNClient createSvnClient() {
        ISVNClient client = this.newClientInstance();
        if (this.repoURL != null && !this.repoURL.startsWith("svn+ssh://") && this.passwordSupplier.getUsername() != null) {
            client.username(this.passwordSupplier.getUsername());
        }
        client.setPrompt(this.getPromptCallback());
        return client;
    }

    UserPasswordCallback getPromptCallback() {
        return this.svnLoaderConfiguration.isSvnkit() ? new SvnkitPasswordSupplier(this.passwordSupplier) : this.passwordSupplier;
    }

    private ISVNClient newClientInstance() {
        return new SVNClient();
    }

    public void resetAuthCount() {
        if (this.passwordSupplier != null) {
            this.passwordSupplier.resetCount();
        }
    }
}

