/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.util.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;

public class RepositoryWalker {
    private static final FilenameFilter svnFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.equals(".svn") && !name.equals("_svn");
        }
    };
    private SvnRepositoryInfo repositoryInfo;
    private SvnThrottledClient client;
    private long revision;
    private Revision rev;
    private boolean skipTags;

    public RepositoryWalker(SvnRepositoryInfo repositoryInfo, SvnThrottledClient client, long revision) {
        this.repositoryInfo = repositoryInfo;
        this.client = client;
        this.revision = revision;
        this.rev = new Revision.Number(revision);
    }

    public void setSkipTags(boolean skipTags) {
        this.skipTags = skipTags;
    }

    public void walkDir(Path localPath, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        if (!this.repositoryInfo.isPathInRepo(localPath)) {
            return;
        }
        Logs.APP_LOG.debug((Object)("Walking filesystem " + localPath));
        String dirURL = this.repositoryInfo.getPathURL(localPath, this.revision);
        Logs.APP_LOG.debug((Object)("Getting info for " + dirURL + "@" + this.rev));
        final Info[] infos = new Info[1];
        this.client.info(dirURL, this.rev, this.rev, Depth.empty, new InfoCallback(){

            public void singleInfo(Info info) {
                infos[0] = info;
            }
        });
        boolean continueWalk = visitor.visitRemoteEntry(this.client, localPath, this.revision, infos[0]);
        if (continueWalk && infos[0].getKind() == NodeKind.dir) {
            Path dummyPath = new Path(localPath, "dummy_entry");
            String containerType = this.repositoryInfo.getPathMatcher().getContainerId(dummyPath);
            Logs.APP_LOG.debug((Object)("Container type for " + localPath + " is " + containerType));
            if (containerType.startsWith("trunk:")) {
                Logs.APP_LOG.debug((Object)("Walking trunk checkout " + localPath));
                this.checkOutAndWalk(localPath, visitor);
            } else if (containerType.startsWith("branch:")) {
                Logs.APP_LOG.debug((Object)("Walking branches dir " + localPath));
                this.walkBranchesDir(localPath, visitor);
            } else if (containerType.startsWith("tag:")) {
                if (!this.skipTags) {
                    Logs.APP_LOG.debug((Object)("Walking tags dir " + localPath));
                    this.walkTagsDir(localPath, visitor);
                }
            } else if (this.repositoryInfo.getPathMatcher().isEmpty()) {
                Logs.APP_LOG.debug((Object)("Walking checkout " + localPath));
                this.checkOutAndWalk(localPath, visitor);
            } else {
                Logs.APP_LOG.debug((Object)("Walking root " + localPath));
                this.walkRoot(localPath, visitor);
            }
        }
    }

    private boolean walkRoot(Path rootPath, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        return this.walkRemote(rootPath, visitor);
    }

    private boolean walkRemote(Path rootPath, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        String dirURL = this.repositoryInfo.getPathURL(rootPath, this.revision);
        final ArrayList rootItems = new ArrayList();
        this.client.list(dirURL, this.rev, this.rev, Depth.immediates, 1, false, new ListCallback(){

            public void doEntry(DirEntry dirEntry, Lock lock) {
                if (!dirEntry.getPath().equals("")) {
                    rootItems.add(dirEntry);
                }
            }
        });
        for (DirEntry item : rootItems) {
            Path itemPath = new Path(rootPath, item.getPath());
            if (item.getNodeKind() == NodeKind.dir) {
                this.walkDir(itemPath, visitor);
                continue;
            }
            Logs.APP_LOG.debug((Object)("Processing remote entry " + itemPath));
            final Info[] infos = new Info[1];
            this.client.info(this.repositoryInfo.getPathURL(itemPath, this.revision), this.rev, this.rev, Depth.empty, new InfoCallback(){

                public void singleInfo(Info info) {
                    infos[0] = info;
                }
            });
            boolean continueWalk = visitor.visitRemoteEntry(this.client, itemPath, this.revision, infos[0]);
            if (continueWalk) continue;
            return false;
        }
        return true;
    }

    private void walkTagsDir(Path tagsDirPath, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        String dirURL = this.repositoryInfo.getPathURL(tagsDirPath, this.revision);
        final ArrayList tagRoots = new ArrayList();
        this.client.list(dirURL, this.rev, this.rev, Depth.immediates, -1, false, new ListCallback(){

            public void doEntry(DirEntry dirEntry, Lock lock) {
                if (!dirEntry.getPath().equals("")) {
                    tagRoots.add(dirEntry);
                }
            }
        });
        for (DirEntry tagRoot : tagRoots) {
            Path tagRootPath = new Path(tagsDirPath, tagRoot.getPath());
            final Info[] infos = new Info[1];
            this.client.info(this.repositoryInfo.getPathURL(tagRootPath, this.revision), this.rev, this.rev, Depth.empty, new InfoCallback(){

                public void singleInfo(Info info) {
                    infos[0] = info;
                }
            });
            boolean continueWalk = visitor.visitRemoteEntry(this.client, tagRootPath, this.revision, infos[0]);
            if (!continueWalk || tagRoot.getNodeKind() != NodeKind.dir) continue;
            this.checkOutAndWalk(tagRootPath, visitor);
        }
    }

    private void walkBranchesDir(Path branchesDirPath, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        String dirURL = this.repositoryInfo.getPathURL(branchesDirPath, this.revision);
        final ArrayList branchRoots = new ArrayList();
        this.client.list(dirURL, this.rev, this.rev, Depth.immediates, -1, false, new ListCallback(){

            public void doEntry(DirEntry dirEntry, Lock lock) {
                if (!dirEntry.getPath().equals("")) {
                    branchRoots.add(dirEntry);
                }
            }
        });
        for (DirEntry branchRoot : branchRoots) {
            Path branchRootPath = new Path(branchesDirPath, branchRoot.getPath());
            final Info[] infos = new Info[1];
            this.client.info(this.repositoryInfo.getPathURL(branchRootPath, this.revision), this.rev, this.rev, Depth.empty, new InfoCallback(){

                public void singleInfo(Info info) {
                    infos[0] = info;
                }
            });
            boolean continueWalk = visitor.visitRemoteEntry(this.client, branchRootPath, this.revision, infos[0]);
            if (!continueWalk || branchRoot.getNodeKind() != NodeKind.dir) continue;
            this.checkOutAndWalk(branchRootPath, visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOutAndWalk(Path dirPath, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        File checkoutDir = null;
        try {
            String pathURL = this.repositoryInfo.getPathURL(dirPath, this.revision);
            checkoutDir = File.createTempFile("FEImport", null, this.repositoryInfo.getRepoTempDir());
            checkoutDir.delete();
            checkoutDir.mkdirs();
            Logs.APP_LOG.debug((Object)("Checking out " + pathURL));
            try {
                this.client.checkout(pathURL, checkoutDir.getAbsolutePath(), this.rev, this.rev, Depth.infinity, true, true);
            }
            catch (RepositoryClientException e2) {
                Logs.APP_LOG.error((Object)("Problem checking out " + pathURL + " - processing partial checkout, ignoring rest"), (Throwable)e2);
            }
            this.visitLocalCheckout(dirPath, checkoutDir, checkoutDir, visitor);
        }
        catch (Throwable throwable) {
            FileUtils.deleteTree(checkoutDir);
            throw throwable;
        }
        FileUtils.deleteTree(checkoutDir);
    }

    private void visitLocalCheckout(Path basePath, File rootDir, File dir, Visitor visitor) throws RepositoryClientException, IOException, DbException {
        File[] files;
        Logs.APP_LOG.debug((Object)("Visiting checked out dir " + dir));
        for (File file : files = dir.listFiles(svnFilter)) {
            boolean continueWalk;
            if (file.getName().equals(".svn") || file.getName().equals("_svn")) {
                Logs.APP_LOG.debug((Object)"Found a svn control dir which should have been excluded");
                continue;
            }
            boolean isLink = this.detectSymlink(file);
            final Info[] infoPtr = new Info[1];
            this.client.info(file.getAbsolutePath(), this.rev, this.rev, Depth.empty, new InfoCallback(){

                public void singleInfo(Info info) {
                    infoPtr[0] = info;
                }
            });
            Info fileInfo = infoPtr[0];
            if (!isLink && file.exists()) {
                if (fileInfo != null) {
                    Logs.APP_LOG.debug((Object)("Visiting working copy entry " + file));
                    continueWalk = visitor.visitWorkingCopyEntry(this.client, file, fileInfo, this.revision);
                } else {
                    continueWalk = true;
                }
            } else {
                String path = file.getAbsolutePath().substring(rootDir.getAbsolutePath().length());
                Path localPath = new Path(basePath, path, true);
                String pathURL = this.repositoryInfo.getPathURL(localPath, this.revision);
                final Info[] infos = new Info[1];
                this.client.info(pathURL, this.rev, this.rev, Depth.empty, new InfoCallback(){

                    public void singleInfo(Info info) {
                        infos[0] = info;
                    }
                });
                continueWalk = infos[0] != null ? visitor.visitRemoteEntry(this.client, localPath, this.revision, infos[0]) : true;
            }
            if (!continueWalk || isLink || !file.isDirectory()) continue;
            this.visitLocalCheckout(basePath, rootDir, file, visitor);
        }
    }

    private boolean detectSymlink(final File file) {
        if (file.exists()) {
            try {
                File parent = file.getParentFile().getCanonicalFile();
                File[] children = parent.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equals(file.getName());
                    }
                });
                if (children.length == 1) {
                    return !children[0].getAbsolutePath().equals(children[0].getCanonicalPath());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static interface Visitor {
        public boolean visitRemoteEntry(SvnThrottledClient var1, Path var2, long var3, Info var5) throws RepositoryClientException, IOException, DbException;

        public boolean visitWorkingCopyEntry(SvnThrottledClient var1, File var2, Info var3, long var4) throws RepositoryClientException, IOException, DbException;
    }
}

