/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.svn.Svn2Utils;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;

public class RepositoryHistoryTraversal {
    private final SortedMap<Long, String> repositoryBaseHistory = new TreeMap<Long, String>();
    private Path location;
    private String repositoryPath;
    private Revision rev;
    private boolean copied;

    public SortedMap<Long, String> traverse(SvnThrottledClient svnClient, String repositoryURL, String repositoryBase) throws ConfigException {
        this.repositoryBaseHistory.clear();
        this.rev = Revision.HEAD;
        this.repositoryPath = repositoryBase;
        do {
            this.location = new Path(this.repositoryPath);
            String urlPath = this.location.getAsUrl();
            String url = repositoryURL + "/" + urlPath;
            this.copied = false;
            try {
                List<RevisionRange> ranges = Svn2Utils.createRevisionRange((Revision)new Revision.Number(0L), this.rev);
                Logs.APP_LOG.debug((Object)("Getting first commit at " + this.location + " (" + url + ") @" + this.rev));
                svnClient.logMessages(url, this.rev, ranges, true, true, false, null, 1L, new LogMessageCallback(){

                    public void singleMessage(Set<ChangePath> changePaths, long revision, Map<String, byte[]> revProps, boolean hasChildren) {
                        if (changePaths != null) {
                            for (ChangePath changePath : changePaths) {
                                Path path = new Path(changePath.getPath());
                                if (!path.equals(RepositoryHistoryTraversal.this.location)) continue;
                                if (changePath.getCopySrcPath() == null) break;
                                RepositoryHistoryTraversal.this.repositoryBaseHistory.put(revision, RepositoryHistoryTraversal.this.repositoryPath);
                                RepositoryHistoryTraversal.this.repositoryPath = changePath.getCopySrcPath();
                                RepositoryHistoryTraversal.this.rev = (Revision)new Revision.Number(changePath.getCopySrcRevision());
                                RepositoryHistoryTraversal.this.copied = true;
                                Logs.APP_LOG.debug((Object)("Repo base was copied from " + RepositoryHistoryTraversal.this.repositoryPath + " at " + changePath.getCopySrcRevision()));
                                break;
                            }
                        }
                    }
                });
            }
            catch (RepositoryClientException e2) {
                throw new ConfigException("Exception during repository traversal", e2);
            }
        } while (this.copied);
        this.repositoryBaseHistory.put(0L, this.repositoryPath);
        return this.repositoryBaseHistory;
    }
}

