/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.rep.activity.ActivityLog;
import com.cenqua.fisheye.svn.SvnClientFactory;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.util.RecentHistory;
import com.cenqua.fisheye.util.Throttle;

public class MonitoredSvnThrottledClient
extends SvnThrottledClient {
    private RecentHistory activityLog;
    private ActivityLog currentActivity;

    public MonitoredSvnThrottledClient(RecentHistory activityLog, String repoDescriptor, Throttle throttle, SvnClientFactory clientFactory, long timeout) {
        super(repoDescriptor, throttle, clientFactory, timeout);
        this.activityLog = activityLog;
    }

    @Override
    protected void startOperation(String operationDescription) {
        if (this.currentActivity != null) {
            throw new IllegalStateException("Cannot start an new activity while another is still running (" + this.currentActivity.getActivity() + ")");
        }
        this.currentActivity = new ActivityLog(operationDescription);
        this.activityLog.add(this.currentActivity);
        super.startOperation(operationDescription);
    }

    @Override
    protected void finishOperation() {
        if (this.currentActivity != null) {
            this.currentActivity.finished();
            this.activityLog.archive(this.currentActivity);
            this.currentActivity = null;
        }
    }
}

