/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.support;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.io.IOHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ThreadDumpHelper {
    public static final int MAX_THREAD_DEPTH = Integer.MAX_VALUE;

    public static boolean canDumpThreads() {
        return ManagementFactory.getThreadMXBean() != null;
    }

    public static ThreadInfo[] getThreadInfos() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (ThreadDumpHelper.canDumpThreads()) {
            return threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), Integer.MAX_VALUE);
        }
        return null;
    }

    public static void getThreadDump(Appendable a2) throws IOException {
        if (!ThreadDumpHelper.canDumpThreads()) {
            return;
        }
        FisheyeVersionInfo v2 = new FisheyeVersionInfo();
        a2.append(MessageFormat.format("{0} {1} {2} {3}\n Thread dump taken on {4,date,medium} at {4,time,medium}:\n", AppConfig.getProductName(), v2.getReleaseNum(), v2.getBuildDate(), v2.getBuildNumber(), new Date()));
        for (ThreadInfo ti : ThreadDumpHelper.getThreadInfos()) {
            if (ti == null) continue;
            a2.append("[").append(String.valueOf(ti.getThreadId())).append("] ").append(ti.getThreadName()).append(": ").append(ti.getThreadState().toString());
            if (ti.getLockName() != null) {
                a2.append(" (waiting on ").append(ti.getLockName().trim());
                if (ti.getLockOwnerId() != -1L) {
                    a2.append(" held by ").append(String.valueOf(ti.getLockOwnerId()));
                }
                a2.append(")");
            }
            a2.append("\n");
            for (StackTraceElement ste : ti.getStackTrace()) {
                a2.append("   ").append(ste.toString()).append("\n");
            }
            a2.append("\n");
        }
    }

    public static File dumpThreadsToLogDir() throws IOException {
        String name = "threaddump_" + ThreadDumpHelper.getCurrentDateTimeForFileName() + ".txt";
        File threaddump = new File(AppConfig.getLogDir(), name);
        IOHelper.createNewFile(threaddump);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(threaddump));
            ThreadDumpHelper.getThreadDump(pw);
        }
        catch (Throwable throwable) {
            IOHelper.close(pw);
            throw throwable;
        }
        IOHelper.close(pw);
        return threaddump;
    }

    private static String getCurrentDateTimeForFileName() {
        return new SimpleDateFormat("yyyyMMddHHmmssS").format(new Date());
    }
}

