/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.support;

import com.atlassian.fecru.utils.DebugAware;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.PassivationStats;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nullable;
import javax.annotation.Resource;

public class SystemResourceMonitor
implements DebugAware {
    private static final int RESOLUTION_MS = 500;
    @Nullable
    private Method maxFileDescriptorMethod;
    @Nullable
    private Method openFileDescriptorMethod;
    private final OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    @Resource
    private RepositoryManager repositoryManager;
    private Timer monitoringTimer;

    public SystemResourceMonitor() {
        try {
            this.maxFileDescriptorMethod = this.osBean.getClass().getMethod("getMaxFileDescriptorCount", new Class[0]);
            this.maxFileDescriptorMethod.setAccessible(true);
            this.maxFileDescriptorMethod.invoke((Object)this.osBean, new Object[0]);
            this.openFileDescriptorMethod = this.osBean.getClass().getMethod("getOpenFileDescriptorCount", new Class[0]);
            this.openFileDescriptorMethod.setAccessible(true);
            this.openFileDescriptorMethod.invoke((Object)this.osBean, new Object[0]);
            this.setDebug(Logs.isDebugMode());
        }
        catch (NoSuchMethodException e2) {
            Logs.APP_LOG.debug((Object)("No resource monitoring is provided by OS MX Bean: " + this.osBean));
        }
        catch (InvocationTargetException e3) {
            Logs.APP_LOG.debug((Object)("Problem getting max file descriptor count: " + this.osBean), (Throwable)e3);
        }
        catch (IllegalAccessException e4) {
            Logs.APP_LOG.debug((Object)("Problem getting max file descriptor count: " + this.osBean), (Throwable)e4);
        }
    }

    @Override
    public synchronized void setDebug(boolean state) {
        if (state && this.monitoringTimer == null) {
            this.monitoringTimer = new Timer("Resource Monitor");
            this.monitoringTimer.schedule((TimerTask)new MonitoringTask(), 0L, 500L);
        } else if (this.monitoringTimer != null) {
            this.monitoringTimer.cancel();
            this.monitoringTimer = null;
        }
    }

    @Nullable
    public Long getMaxFileDescriptorCount() {
        try {
            return this.maxFileDescriptorMethod != null ? (Long)this.maxFileDescriptorMethod.invoke((Object)this.osBean, new Object[0]) : null;
        }
        catch (InvocationTargetException e2) {
            Logs.APP_LOG.debug((Object)("Problem getting max file descriptor count: " + this.osBean), (Throwable)e2);
        }
        catch (IllegalAccessException e3) {
            Logs.APP_LOG.debug((Object)("Problem getting max file descriptor count: " + this.osBean), (Throwable)e3);
        }
        return null;
    }

    @Nullable
    public Long getOpenFileDescriptorCount() {
        try {
            return this.openFileDescriptorMethod != null ? (Long)this.openFileDescriptorMethod.invoke((Object)this.osBean, new Object[0]) : null;
        }
        catch (InvocationTargetException e2) {
            Logs.APP_LOG.debug((Object)("Problem getting max file descriptor count: " + this.osBean), (Throwable)e2);
        }
        catch (IllegalAccessException e3) {
            Logs.APP_LOG.debug((Object)("Problem getting max file descriptor count: " + this.osBean), (Throwable)e3);
        }
        return null;
    }

    private class MonitoringTask
    extends TimerTask {
        private long pmfd;
        private long pofd;
        private long ptc;
        private InfinityDbHandle.AccessStats repoDbAccessStats;

        private MonitoringTask() {
        }

        @Override
        public void run() {
            try {
                InfinityDbHandle.AccessStats latestAccessStats;
                Long maxFileDescriptors = SystemResourceMonitor.this.getMaxFileDescriptorCount();
                Long openFileDescriptors = SystemResourceMonitor.this.getOpenFileDescriptorCount();
                long mfd = maxFileDescriptors == null ? -1L : maxFileDescriptors;
                long ofd = openFileDescriptors == null ? -1L : openFileDescriptors;
                long tc = ManagementFactory.getThreadMXBean().getThreadCount();
                if (this.pmfd != mfd || this.pofd != ofd || this.ptc != tc) {
                    Logs.APP_LOG.debug((Object)("tc=" + tc + ", ofd=" + ofd + ", mfd=" + mfd + ", fm=" + Runtime.getRuntime().freeMemory() + ", tm=" + Runtime.getRuntime().totalMemory()));
                    this.pmfd = mfd;
                    this.pofd = ofd;
                    this.ptc = tc;
                }
                if ((latestAccessStats = InfinityDbHandle.getAccessStats()).isSignificantChangeFrom(this.repoDbAccessStats)) {
                    this.repoDbAccessStats = latestAccessStats;
                    if (SystemResourceMonitor.this.repositoryManager != null) {
                        PassivationStats pStats = SystemResourceMonitor.this.repositoryManager.getPassivationStats();
                        Logs.APP_LOG.debug((Object)String.format("repos: runnable=%d, active=%d (max=%d), await_close=%d cache: per-repo=%d, used=%d, max=%d (%.2f)", pStats.getRunnableCount(), pStats.getActiveCount(), pStats.getMaxActiveRepos(), pStats.getNeedingPassivationCount(), pStats.getPerRepoCacheSize(), pStats.getActiveCacheSize(), pStats.getMaxCacheSize(), pStats.getCacheUsage()));
                    }
                    Logs.APP_LOG.debug((Object)String.format("repo-db access: hits=%d, misses=%d, total=%d, hit rate=%.2f, closes=%d", this.repoDbAccessStats.getHitCount(), this.repoDbAccessStats.getMissCount(), this.repoDbAccessStats.getTotalCount(), this.repoDbAccessStats.getHitRate(), this.repoDbAccessStats.getCloseCount()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

