/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.support;

import com.atlassian.modzdetector.Modifications;
import com.atlassian.modzdetector.ModzDetector;
import com.atlassian.modzdetector.ModzRegistryException;
import com.atlassian.modzdetector.ResourceAccessor;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ModzDetectorCache {
    private Modifications modz = null;
    private final ModzDetector detector = new ModzDetector((ResourceAccessor)new FishEyeResourceAccessor());

    public synchronized Modifications getModifications() throws ModzRegistryException {
        if (this.modz == null) {
            this.modz = this.detector.getModifiedFiles();
        }
        return this.modz;
    }

    private static class RegistryClassLoader
    extends ClassLoader {
        private static final String HASH_REGISTRY_PROPERTIES = "hash-registry.properties";

        private RegistryClassLoader() {
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            if (name.equals(HASH_REGISTRY_PROPERTIES)) {
                File registry = new File(AppConfig.getAppHome(), HASH_REGISTRY_PROPERTIES);
                try {
                    return new FileInputStream(registry);
                }
                catch (FileNotFoundException e2) {
                    Logs.APP_LOG.warn((Object)"Could not located mod registry file 'hash-registry.properties'", (Throwable)e2);
                }
            }
            return super.getResourceAsStream(name);
        }

        @Override
        public URL getResource(String name) {
            if (name.equals(HASH_REGISTRY_PROPERTIES)) {
                File registry = new File(AppConfig.getAppHome(), HASH_REGISTRY_PROPERTIES);
                try {
                    return registry.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return super.getResource(name);
        }
    }

    private static class FishEyeResourceAccessor
    implements ResourceAccessor {
        private FishEyeResourceAccessor() {
        }

        public InputStream getResourceByPath(String s2) {
            File file = new File(AppConfig.getAppHome(), s2);
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return inputStream == null ? null : new BufferedInputStream(inputStream);
        }

        public ClassLoader getClassLoader() {
            return new RegistryClassLoader();
        }
    }
}

