/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.quicksearch2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;

public final class TokenSources {
    public static TokenStream getTokenStream(TermPositionVector tpv) {
        return TokenSources.getTokenStream(tpv, false);
    }

    static TokenStream getTokenStream(TermPositionVector tpv, boolean tokenPositionsGuaranteedContiguous) {
        String[] terms = tpv.getTerms();
        int[] freq = tpv.getTermFrequencies();
        int totalTokens = 0;
        for (int t2 = 0; t2 < freq.length; ++t2) {
            totalTokens += freq[t2];
        }
        Token[] tokensInOriginalOrder = new Token[totalTokens];
        ArrayList<Token> unsortedTokens = null;
        for (int t3 = 0; t3 < freq.length; ++t3) {
            Token token;
            int tp;
            TermVectorOffsetInfo[] offsets = tpv.getOffsets(t3);
            if (offsets == null) {
                return null;
            }
            int[] pos = null;
            if (tokenPositionsGuaranteedContiguous) {
                pos = tpv.getTermPositions(t3);
            }
            if (pos == null) {
                if (unsortedTokens == null) {
                    unsortedTokens = new ArrayList<Token>();
                }
                for (tp = 0; tp < offsets.length; ++tp) {
                    token = new Token(offsets[tp].getStartOffset(), offsets[tp].getEndOffset());
                    token.setTermBuffer(terms[t3]);
                    unsortedTokens.add(token);
                }
                continue;
            }
            for (tp = 0; tp < pos.length; ++tp) {
                tokensInOriginalOrder[pos[tp]] = token = new Token(terms[t3], offsets[tp].getStartOffset(), offsets[tp].getEndOffset());
            }
        }
        if (unsortedTokens != null) {
            tokensInOriginalOrder = unsortedTokens.toArray(new Token[unsortedTokens.size()]);
            Arrays.sort(tokensInOriginalOrder, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Token t1 = (Token)o1;
                    Token t2 = (Token)o2;
                    if (t1.startOffset() >= t2.endOffset()) {
                        return 1;
                    }
                    if (t2.startOffset() >= t1.endOffset()) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        final class StoredTokenStream
        extends TokenStream {
            Token[] tokens;
            int currentToken = 0;
            CharTermAttribute termAtt;
            OffsetAttribute offsetAtt;

            StoredTokenStream(Token[] tokens) {
                this.tokens = tokens;
                this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
            }

            public boolean incrementToken() throws IOException {
                if (this.currentToken >= this.tokens.length) {
                    return false;
                }
                Token token = this.tokens[this.currentToken++];
                this.termAtt.setEmpty().append((CharTermAttribute)token);
                this.offsetAtt.setOffset(token.startOffset(), token.endOffset());
                return true;
            }

            public void reset() throws IOException {
                this.currentToken = 0;
            }
        }
        return new StoredTokenStream(tokensInOriginalOrder);
    }
}

