/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.query;

import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.search.ClauseVisitor;
import com.cenqua.fisheye.search.query.AbstractRelationalOperatorClause;
import com.cenqua.fisheye.search.query.Clause;
import com.cenqua.fisheye.search.query.NotClause;
import com.cenqua.fisheye.search.query.TaggedExactClause;
import com.cenqua.fisheye.search.query.TaggedRangeClause;
import java.io.IOException;

public class TaggedClause
extends AbstractRelationalOperatorClause {
    private final String tag;
    private final Clause delegate;

    public TaggedClause(String tag, int op) {
        super(op);
        this.tag = tag;
        if (op == 1 || op == 2) {
            TaggedExactClause clause = new TaggedExactClause(tag, this.toString());
            this.delegate = op == 1 ? clause : new NotClause(clause);
        } else {
            TaggedRangeClause clause = new TaggedRangeClause();
            if (op == 3) {
                clause.setEndTag(tag);
                clause.setEndInclusive(false);
            } else if (op == 4) {
                clause.setEndTag(tag);
                clause.setEndInclusive(true);
            } else if (op == 5) {
                clause.setStartTag(tag);
                clause.setStartInclusive(false);
            } else if (op == 6) {
                clause.setStartTag(tag);
                clause.setStartInclusive(true);
            }
            this.delegate = clause;
        }
    }

    @Override
    public void accept(ClauseVisitor visitor) throws IOException, DbException {
        this.delegate.accept(visitor);
    }

    @Override
    void toString(StringBuffer buf) {
        buf.append("tagged ");
        this.operatorToString(buf);
        buf.append(" ");
        TaggedClause.quoteString(this.tag, buf);
    }
}

