/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.query;

import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.State;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.UserActionManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.tags.MaybeReview;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.perforce.db.P4RevInfo;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.search.aggregation.ReturnFieldAggregator;
import com.cenqua.fisheye.search.query.Clause;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ReturnClause {
    public static final String PATH_FIELD_NAME = "path";
    public static final String DIR_FIELD_NAME = "dir";
    public static final String AUTHOR_FIELD_NAME = "author";
    public static final String DATE_FIELD_NAME = "date";
    public static final String COMMENT_FIELD_NAME = "comment";
    public static final String CSID_FIELD_NAME = "csid";
    public static final String CHANGESET_COMMENT_FIELD_NAME = "changeset.comment";
    private final List<Field> fields = new ArrayList<Field>();

    public void addField(Field f2) {
        this.fields.add(f2);
    }

    public int numFields() {
        return this.fields.size();
    }

    public Iterable<Field> getFields() {
        return this.fields;
    }

    public Field getField(int i2) {
        return this.fields.get(i2);
    }

    public boolean hasAggregates() {
        for (Field field : this.fields) {
            if (!(field instanceof AggregateField)) continue;
            return true;
        }
        return false;
    }

    public void toString(StringBuffer buf) {
        String sep = "";
        for (Field field : this.fields) {
            buf.append(sep);
            field.toQueryString(buf);
            sep = ", ";
        }
    }

    public static class CountDistinctField
    extends CountField {
        public CountDistinctField(Field returnField) {
            super(returnField, true);
        }

        @Override
        public ReturnFieldAggregator getAggregator() {
            return new ReturnFieldAggregator.DistinctCounter(this);
        }
    }

    public static class CountBooleansField
    extends CountField {
        public CountBooleansField(Field returnField) {
            super(returnField, false);
        }

        @Override
        public ReturnFieldAggregator getAggregator() {
            return new ReturnFieldAggregator.TrueCounter(this);
        }
    }

    public static class CountRevisionsField
    extends CountField {
        public CountRevisionsField() {
            super(new RevisionField(), false);
        }

        @Override
        public ReturnFieldAggregator getAggregator() {
            return new ReturnFieldAggregator.Counter(this);
        }
    }

    public static abstract class CountField
    extends AggregateField {
        private final boolean isDistinct;

        protected CountField(Field returnField, boolean isDistinct) {
            super("count", "count(");
            this.setReturnField(returnField);
            this.isDistinct = isDistinct;
        }

        public boolean isDistinct() {
            return this.isDistinct;
        }

        @Override
        protected void appendReturnField(StringBuffer buf) {
            if (this.isDistinct) {
                buf.append("distinct ");
            }
            super.appendReturnField(buf);
        }
    }

    public static class MinField
    extends AggregateField {
        protected MinField() {
            super("min", "min(");
        }

        @Override
        public ReturnFieldAggregator getAggregator() {
            return new ReturnFieldAggregator.Min(this);
        }
    }

    public static class MaxField
    extends AggregateField {
        protected MaxField() {
            super("max", "max(");
        }

        @Override
        public ReturnFieldAggregator getAggregator() {
            return new ReturnFieldAggregator.Max(this);
        }
    }

    public static class AverageField
    extends AggregateField {
        protected AverageField() {
            super("average", "average(");
        }

        @Override
        public ReturnFieldAggregator getAggregator() {
            return new ReturnFieldAggregator.Average(this);
        }
    }

    public static class SumField
    extends AggregateField {
        protected SumField() {
            super("sum", "sum(");
        }

        @Override
        public ReturnFieldAggregator getAggregator() {
            return new ReturnFieldAggregator.Sum(this);
        }
    }

    public static abstract class AggregateField
    extends IntTypeField {
        private Field returnField;

        protected AggregateField(String expr, String humanReadableName) {
            super(expr, humanReadableName);
        }

        @Override
        public int asInt(FileRevision fi) {
            return 0;
        }

        public Field getReferencedField() {
            return this.returnField;
        }

        public void setReturnField(Field returnField) {
            this.returnField = returnField;
        }

        @Override
        public String getColumnName() {
            if (super.getColumnName() != this.getField()) {
                return super.getColumnName();
            }
            Preconditions.checkArgument((this.returnField != null ? 1 : 0) != 0);
            String rfn = this.returnField.getColumnName();
            Preconditions.checkArgument((rfn.length() > 0 ? 1 : 0) != 0);
            if (rfn.length() == 1) {
                return super.getColumnName() + rfn.toUpperCase();
            }
            return super.getColumnName() + Character.toUpperCase(rfn.charAt(0)) + rfn.substring(1);
        }

        @Override
        public String getHumanReadableColumnName() {
            Preconditions.checkArgument((this.returnField != null ? 1 : 0) != 0);
            String humanColumnName = super.getHumanReadableColumnName();
            if (humanColumnName.endsWith("(")) {
                return humanColumnName + this.returnField.getHumanReadableColumnName() + ")";
            }
            return humanColumnName + this.returnField.getHumanReadableColumnName();
        }

        @Override
        public void toQueryString(StringBuffer buf) {
            buf.append(this.getField());
            buf.append("(");
            this.appendReturnField(buf);
            buf.append(")");
            if (!this.getField().equals(super.getColumnName())) {
                buf.append(" as ");
                Clause.quoteString(super.getColumnName(), buf);
            }
        }

        protected void appendReturnField(StringBuffer buf) {
            if ("revision".equals(this.returnField.getField())) {
                buf.append("revisions");
            } else {
                buf.append(this.returnField.getField());
            }
        }

        @Override
        public abstract ReturnFieldAggregator getAggregator();
    }

    public static class P4JobsFixedField
    extends StringArrayTypeField {
        public P4JobsFixedField() {
            super("p4:jobsFixed", "Fixed Jobs");
        }

        @Override
        public String[] asStringArray(FileRevision fi) {
            if (!(fi instanceof P4RevInfo)) {
                return new String[0];
            }
            P4RevInfo p4fi = (P4RevInfo)fi;
            String[] jobs = new String[p4fi.getFixedJobs().size()];
            p4fi.getFixedJobs().toArray(jobs);
            return jobs;
        }
    }

    public static class ReviewsField
    extends MapArrayTypeField {
        private ReviewManager reviewManager = DefaultReviewManager.get();

        public ReviewsField() {
            super("reviews", "Reviews");
        }

        public List<MaybeReview> asReviewList(FileRevision fi) {
            List<Integer> rids = fi.getReviewIds();
            LinkedList<MaybeReview> result = new LinkedList<MaybeReview>();
            for (Integer rid : rids) {
                Review r2 = this.reviewManager.getReviewById(rid);
                if (r2 == null) continue;
                result.add(new MaybeReview(r2, ReviewUtil.canDoReviewAction(UserActionManager.ACTION_VIEW, r2)));
            }
            return result;
        }

        @Override
        public List asList(FileRevision fi) {
            return this.asReviewList(fi);
        }

        @Override
        public Map[] asMapArray(FileRevision fi) {
            ArrayList results = new ArrayList();
            for (MaybeReview mr : this.asReviewList(fi)) {
                LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
                if (mr.getReview() != null) {
                    Review r2 = mr.getReview();
                    values.put("id", r2.getPermaId());
                    values.put("title", r2.getName() != null ? r2.getName().trim() : "");
                    values.put("description", r2.getDescription() != null ? r2.getDescription().trim() : "");
                    State state = r2.getState();
                    values.put("state", state.getName());
                    values.put("isDraft", state.isDraftMetaState() ? "true" : "false");
                    values.put("isOpen", state.isOpenMetaState() ? "true" : "false");
                    values.put("isClosed", state.isClosedMetaState() ? "true" : "false");
                } else {
                    values.put("id", mr.getPermaId());
                }
                results.add(values);
            }
            return results.toArray(new Map[results.size()]);
        }
    }

    public static class TagsField
    extends StringArrayTypeField {
        protected TagsField() {
            super("tags", "Tags");
        }

        @Override
        public String[] asStringArray(FileRevision fi) {
            ArrayList tagList = Lists.newArrayList(fi.getTags());
            Collections.sort(tagList);
            return (String[])Iterables.toArray((Iterable)tagList, String.class);
        }
    }

    public static class LinesRemovedField
    extends IntTypeField {
        protected LinesRemovedField() {
            super("linesRemoved", "Lines Removed");
        }

        @Override
        public int asInt(FileRevision fi) {
            return fi.getLinesRemoved();
        }
    }

    public static class LinesAddedField
    extends IntTypeField {
        protected LinesAddedField() {
            super("linesAdded", "Lines Added");
        }

        @Override
        public int asInt(FileRevision fi) {
            return fi.getLinesAdded();
        }
    }

    public static class TotalLinesField
    extends IntTypeField {
        protected TotalLinesField() {
            super("totalLines", "Total Lines");
        }

        @Override
        public int asInt(FileRevision fi) {
            return fi.getLineCount();
        }
    }

    public static class IsMovedField
    extends StringTypeField {
        public IsMovedField() {
            super("isMoved", "Is Moved");
        }

        @Override
        public String asString(FileRevision fi) {
            return String.valueOf(fi.isMove());
        }
    }

    public static class IsCopiedField
    extends StringTypeField {
        public IsCopiedField() {
            super("isCopied", "Is Copied");
        }

        @Override
        public String asString(FileRevision fi) {
            return String.valueOf(fi.isCopy());
        }
    }

    public static class IsAddedField
    extends StringTypeField {
        public IsAddedField() {
            super("isAdded", "Is Added");
        }

        @Override
        public String asString(FileRevision fi) {
            return String.valueOf(fi.isAdded());
        }
    }

    public static class IsDeletedField
    extends StringTypeField {
        public IsDeletedField() {
            super("isDeleted", "Is Deleted");
        }

        @Override
        public String asString(FileRevision fi) {
            return String.valueOf(fi.isDead());
        }
    }

    public static class IsBinaryField
    extends StringTypeField {
        public IsBinaryField() {
            super("isBinary", "Is Binary");
        }

        @Override
        public String asString(FileRevision fi) {
            return String.valueOf(fi.isBinary());
        }
    }

    public static class ChangeSetCommentField
    extends StringTypeField {
        public ChangeSetCommentField() {
            super(ReturnClause.CHANGESET_COMMENT_FIELD_NAME, "Changeset Comment");
        }

        @Override
        public String asString(FileRevision fi) {
            return "comments FAIL";
        }

        @Override
        public String asDisplayString(FileRevision fi) {
            return this.asString(fi);
        }
    }

    public static class ChangeSetField
    extends StringTypeField {
        public ChangeSetField() {
            super(ReturnClause.CSID_FIELD_NAME, "Changeset ID");
        }

        @Override
        public String asString(FileRevision fi) {
            return fi.getChangeSetId();
        }

        @Override
        public String asDisplayString(FileRevision fi) {
            return fi.getDisplayCSID();
        }
    }

    public static class CommentField
    extends StringTypeField {
        public CommentField() {
            super(ReturnClause.COMMENT_FIELD_NAME, "Comment");
        }

        @Override
        public String asString(FileRevision fi) {
            return fi.getComment();
        }
    }

    public static class DateField
    extends DateTypeField {
        public DateField() {
            super(ReturnClause.DATE_FIELD_NAME, "Date");
        }

        @Override
        public long asDate(FileRevision fi) {
            return fi.getDate();
        }

        @Override
        public ReturnFieldAggregator getAggregator() {
            return new ReturnFieldAggregator.MinDate(this);
        }
    }

    public static class AuthorField
    extends StringTypeField {
        public AuthorField() {
            super(ReturnClause.AUTHOR_FIELD_NAME, "Author");
        }

        @Override
        public String asString(FileRevision fi) {
            return fi.getAuthor();
        }
    }

    public static class AncestorField
    extends StringTypeField {
        public AncestorField() {
            super("ancestor", "Ancestor");
        }

        @Override
        public String asString(FileRevision fi) {
            if (fi.getAncestors().isEmpty()) {
                return null;
            }
            StringBuilder buffer = new StringBuilder();
            String seperator = "";
            for (RevInfoKey ancestorKey : fi.getAncestors()) {
                buffer.append(seperator).append(ancestorKey.getRev());
                seperator = ", ";
            }
            return buffer.toString();
        }
    }

    public static class RevisionField
    extends StringTypeField {
        public RevisionField() {
            super("revision", "Revision");
        }

        @Override
        public String asString(FileRevision fi) {
            return fi.getRevision();
        }

        @Override
        public String asDisplayString(FileRevision fi) {
            return fi.getDisplayRevision();
        }
    }

    public static class DirField
    extends PathTypeField {
        public DirField() {
            super(ReturnClause.DIR_FIELD_NAME, "Directory");
        }

        @Override
        public Path asPath(FileRevision fi) {
            return fi.getPath().getParent();
        }
    }

    public static class PathField
    extends PathTypeField {
        public PathField() {
            super(ReturnClause.PATH_FIELD_NAME, "Path");
        }

        @Override
        public Path asPath(FileRevision fi) {
            return fi.getPath();
        }
    }

    public static abstract class IntTypeField
    extends Field {
        protected IntTypeField(String columnName, String humanReadableName) {
            super(columnName, humanReadableName, Type.INTEGER);
        }

        @Override
        public abstract int asInt(FileRevision var1);

        @Override
        public Object asObject(FileRevision fi) {
            return this.asInt(fi);
        }
    }

    public static abstract class DateTypeField
    extends Field {
        protected DateTypeField(String columnName, String humanReadableName) {
            super(columnName, humanReadableName, Type.DATE);
        }

        @Override
        public abstract long asDate(FileRevision var1);

        @Override
        public Date asDateValue(FileRevision fi) {
            return new Date(this.asDate(fi));
        }

        @Override
        public String asString(FileRevision fi) {
            return ISO8601DateHelper.toIsoDate(this.asDate(fi));
        }

        @Override
        public Object asObject(FileRevision fi) {
            return this.asDateValue(fi);
        }
    }

    public static abstract class MapArrayTypeField
    extends Field {
        protected MapArrayTypeField(String columnName, String humanReadableName) {
            super(columnName, humanReadableName, Type.MAP_ARRAY);
        }

        @Override
        public abstract Map[] asMapArray(FileRevision var1);

        @Override
        public Object asObject(FileRevision fi) {
            return this.asMapArray(fi);
        }
    }

    public static abstract class StringArrayTypeField
    extends Field {
        protected StringArrayTypeField(String columnName, String humanReadableName) {
            super(columnName, humanReadableName, Type.STRING_ARRAY);
        }

        @Override
        public abstract String[] asStringArray(FileRevision var1);

        @Override
        public Object asObject(FileRevision fi) {
            return this.asStringArray(fi);
        }
    }

    public static abstract class StringTypeField
    extends Field {
        protected StringTypeField(String columnName, String humanReadableColumnName) {
            super(columnName, humanReadableColumnName, Type.STRING);
        }

        @Override
        public abstract String asString(FileRevision var1);

        @Override
        public Object asObject(FileRevision fi) {
            return this.asString(fi);
        }
    }

    public static abstract class PathTypeField
    extends Field {
        protected PathTypeField(String columnName, String humanReadableName) {
            super(columnName, humanReadableName, Type.PATH);
        }

        @Override
        public abstract Path asPath(FileRevision var1);

        @Override
        public Object asObject(FileRevision fi) {
            return this.asPath(fi);
        }
    }

    public static abstract class Field {
        private String columnName;
        private final String field;
        private final String humanReadableField;
        private final Type type;

        protected Field(String expr, String humanReadableName, Type type) {
            this.columnName = expr;
            this.humanReadableField = humanReadableName;
            this.field = expr;
            this.type = type;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getHumanReadableColumnName() {
            return this.humanReadableField;
        }

        public String getField() {
            return this.field;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isInt() {
            return this.getType() == Type.INTEGER;
        }

        public boolean isDate() {
            return this.getType() == Type.DATE;
        }

        public Path asPath(FileRevision fi) {
            return null;
        }

        public String asString(FileRevision fi) {
            Object o2 = this.asObject(fi);
            return o2 == null ? null : o2.toString();
        }

        public String asDisplayString(FileRevision fi) {
            return this.asString(fi);
        }

        public long asDate(FileRevision fi) {
            return 0L;
        }

        public int asInt(FileRevision fi) {
            return 0;
        }

        public Date asDateValue(FileRevision fi) {
            return null;
        }

        public String[] asStringArray(FileRevision fi) {
            return new String[0];
        }

        public Map[] asMapArray(FileRevision fi) {
            return new HashMap[0];
        }

        public List asList(FileRevision fi) {
            return Collections.EMPTY_LIST;
        }

        public abstract Object asObject(FileRevision var1);

        public ReturnFieldAggregator getAggregator() {
            return new ReturnFieldAggregator.SingleDistinctValue(this);
        }

        public void toQueryString(StringBuffer buf) {
            buf.append(this.field);
            if (!this.field.equals(this.columnName)) {
                buf.append(" as ");
                Clause.quoteString(this.columnName, buf);
            }
        }

        public String toString() {
            return this.getColumnName();
        }
    }

    public static enum Type {
        DATE,
        STRING,
        INTEGER,
        STRING_ARRAY,
        MAP_ARRAY,
        PATH;

    }
}

