/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.query;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.search.query.AddedLineClause;
import com.cenqua.fisheye.search.query.AndClause;
import com.cenqua.fisheye.search.query.AuthorsClause;
import com.cenqua.fisheye.search.query.ChangesetCommentClause;
import com.cenqua.fisheye.search.query.Clause;
import com.cenqua.fisheye.search.query.CommentClause;
import com.cenqua.fisheye.search.query.CommentExactMatchClause;
import com.cenqua.fisheye.search.query.CommentRegexClause;
import com.cenqua.fisheye.search.query.ContentClause;
import com.cenqua.fisheye.search.query.CsidExactMatchClause;
import com.cenqua.fisheye.search.query.DateClause;
import com.cenqua.fisheye.search.query.DateRangeClause;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.search.query.HeadClause;
import com.cenqua.fisheye.search.query.NotClause;
import com.cenqua.fisheye.search.query.OnBranchClause;
import com.cenqua.fisheye.search.query.OrClause;
import com.cenqua.fisheye.search.query.P4FixesClause;
import com.cenqua.fisheye.search.query.P4FixesRegexClause;
import com.cenqua.fisheye.search.query.PathClause;
import com.cenqua.fisheye.search.query.QueryLangLexer;
import com.cenqua.fisheye.search.query.QueryLangParserTokenTypes;
import com.cenqua.fisheye.search.query.RemovedLineClause;
import com.cenqua.fisheye.search.query.ReturnClause;
import com.cenqua.fisheye.search.query.ReviewClause;
import com.cenqua.fisheye.search.query.StateClause;
import com.cenqua.fisheye.search.query.TaggedClause;
import com.cenqua.fisheye.search.query.TaggedRangeClause;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class QueryLangParser
extends LLkParser
implements QueryLangParserTokenTypes {
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"select\"", "\"revisions\"", "\"from\"", "\"dir\"", "\"directory\"", "\"where\"", "\"order\"", "\"by\"", "\"date\"", "\"asc\"", "\"desc\"", "\"group\"", "\"file\"", "\"path\"", "\"changeset\"", "\"csid\"", "\"limit\"", "WORD", "COMMA", "\"offset\"", "\"return\"", "\"as\"", "\"sum\"", "\"average\"", "\"max\"", "\"min\"", "LPAREN", "RPAREN", "\"count\"", "\"distinct\"", "\"totalLines\"", "\"linesAdded\"", "\"linesRemoved\"", "\"isBinary\"", "\"isDeleted\"", "\"isAdded\"", "\"isMoved\"", "\"isCopied\"", "\"author\"", "\"tags\"", "\"reviews\"", "\"revision\"", "\"comment\"", "\"changelog\"", "\"changeset.comment\"", "\"ancestor\"", "\"p4:jobsFixed\"", "\"or\"", "\"and\"", "\"not\"", "\"like\"", "EQ", "EQEQ", "NEQ", "\"in\"", "LBRACK", "RBRACK", "LT", "LTE", "GT", "GTE", "\"matches\"", "REMATCH", "\"content\"", "\"addedLine\"", "\"removedLine\"", "\"p4:jobid\"", "\"modified\"", "\"added\"", "\"deleted\"", "\"on\"", "\"branch\"", "\"tagged\"", "\"between\"", "\"after\"", "\"tag\"", "\"before\"", "\"is\"", "\"head\"", "\"dead\"", "\"reviewed\"", "\"review\"", "\"any\"", "\"draft\"", "\"open\"", "\"closed\"", "DATE", "STRING_LITERAL", "WS", "STRING_PART", "HEX_DIGITS_4", "HEX_DIGIT", "THING", "DIGIT", "DIGITS", "DIGIT2_", "DIGIT2", "DIGIT4", "DATE_SEP", "TIME_SEP", "DATETIME", "DATECONSTANT", "DURATION"};

    private int word2PositiveInt(Token t2, String errMsg) throws RecognitionException {
        try {
            int number = Integer.parseInt(t2.getText());
            if (number < 0) {
                throw new RecognitionException(errMsg);
            }
            return number;
        }
        catch (NumberFormatException e2) {
            throw new RecognitionException(errMsg);
        }
    }

    protected QueryLangParser(TokenBuffer tokenBuf, int k2) {
        super(tokenBuf, k2);
        this.tokenNames = _tokenNames;
    }

    public QueryLangParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected QueryLangParser(TokenStream lexer, int k2) {
        super(lexer, k2);
        this.tokenNames = _tokenNames;
    }

    public QueryLangParser(TokenStream lexer) {
        this(lexer, 2);
    }

    public QueryLangParser(ParserSharedInputState state) {
        super(state, 2);
        this.tokenNames = _tokenNames;
    }

    public final FishQuery query() throws RecognitionException, TokenStreamException {
        Token limit0 = null;
        Token limit1 = null;
        Token limit2 = null;
        Token limit3 = null;
        Token limit4 = null;
        Clause whereClause = null;
        ReturnClause rt = null;
        String s2 = null;
        FishQuery qb = new FishQuery();
        this.match(4);
        this.match(5);
        switch (this.LA(1)) {
            case 6: {
                this.match(6);
                switch (this.LA(1)) {
                    case 7: {
                        this.match(7);
                        break;
                    }
                    case 8: {
                        this.match(8);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                s2 = this.word();
                qb.setFromPath(new Path(s2));
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 15: 
            case 20: 
            case 24: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 9: {
                this.match(9);
                whereClause = this.clauses();
                qb.setWhereClause(whereClause);
                break;
            }
            case 1: 
            case 10: 
            case 15: 
            case 20: 
            case 24: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        block12 : switch (this.LA(1)) {
            case 10: {
                this.match(10);
                this.match(11);
                this.match(12);
                qb.setOrderBy(FishQuery.OrderByType.DATE);
                switch (this.LA(1)) {
                    case 13: {
                        this.match(13);
                        qb.setOrderByDirection(FishQuery.OrderByDir.ASCENDING);
                        break block12;
                    }
                    case 14: {
                        this.match(14);
                        qb.setOrderByDirection(FishQuery.OrderByDir.DESCENDING);
                        break block12;
                    }
                    case 1: 
                    case 15: 
                    case 20: 
                    case 24: {
                        break block12;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 1: 
            case 15: 
            case 20: 
            case 24: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        block21 : switch (this.LA(1)) {
            case 15: {
                this.match(15);
                this.match(11);
                switch (this.LA(1)) {
                    case 16: {
                        this.match(16);
                        qb.setGroupBy(FishQuery.GroupBy.FILE);
                        break block21;
                    }
                    case 17: {
                        this.match(17);
                        qb.setGroupBy(FishQuery.GroupBy.FILE);
                        break block21;
                    }
                    case 7: {
                        this.match(7);
                        qb.setGroupBy(FishQuery.GroupBy.DIRECTORY);
                        break block21;
                    }
                    case 8: {
                        this.match(8);
                        qb.setGroupBy(FishQuery.GroupBy.DIRECTORY);
                        break block21;
                    }
                    case 18: {
                        this.match(18);
                        qb.setGroupBy(FishQuery.GroupBy.CHANGESET);
                        break block21;
                    }
                    case 19: {
                        this.match(19);
                        qb.setGroupBy(FishQuery.GroupBy.CHANGESET);
                        break block21;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 1: 
            case 20: 
            case 24: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 24: {
                rt = this.returnClause();
                qb.setReturnClause(rt);
                break;
            }
            case 1: 
            case 20: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 20: {
                int duration;
                int offset;
                this.match(20);
                String durationErr = "limit duration must be a positive integer";
                String offsetErr = "limit offset must be a positive integer";
                if (this.LA(1) == 21 && this.LA(2) == 1) {
                    limit0 = this.LT(1);
                    this.match(21);
                    offset = 0;
                    duration = this.word2PositiveInt(limit0, durationErr);
                } else if (this.LA(1) == 21 && this.LA(2) == 22) {
                    limit1 = this.LT(1);
                    this.match(21);
                    this.match(22);
                    limit2 = this.LT(1);
                    this.match(21);
                    offset = this.word2PositiveInt(limit1, offsetErr);
                    duration = this.word2PositiveInt(limit2, durationErr);
                } else if (this.LA(1) == 21 && this.LA(2) == 23) {
                    limit3 = this.LT(1);
                    this.match(21);
                    this.match(23);
                    limit4 = this.LT(1);
                    this.match(21);
                    duration = this.word2PositiveInt(limit3, durationErr);
                    offset = this.word2PositiveInt(limit4, offsetErr);
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                qb.setLimit(offset, duration);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(1);
        return qb;
    }

    protected final String word() throws RecognitionException, TokenStreamException {
        String w2;
        Token wr = null;
        Token dt = null;
        switch (this.LA(1)) {
            case 91: {
                w2 = this.string();
                break;
            }
            case 21: {
                wr = this.LT(1);
                this.match(21);
                w2 = wr.getText();
                break;
            }
            case 90: {
                dt = this.LT(1);
                this.match(90);
                w2 = dt.getText();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return w2;
    }

    public final Clause clauses() throws RecognitionException, TokenStreamException {
        Clause c2 = null;
        OrClause r2 = null;
        OrClause ret = r2 = new OrClause();
        c2 = this.clauses2();
        r2.addClause(c2);
        while (this.LA(1) == 51) {
            this.match(51);
            c2 = this.clauses2();
            r2.addClause(c2);
        }
        return ret;
    }

    public final ReturnClause returnClause() throws RecognitionException, TokenStreamException {
        ReturnClause ret = new ReturnClause();
        this.match(24);
        ReturnClause.Field field = this.returnField();
        ret.addField(field);
        while (this.LA(1) == 22) {
            this.match(22);
            field = this.returnField();
            ret.addField(field);
        }
        return ret;
    }

    public final ReturnClause.Field returnField() throws RecognitionException, TokenStreamException {
        ReturnClause.Field field;
        String name = null;
        switch (this.LA(1)) {
            case 34: 
            case 35: 
            case 36: {
                field = this.numericReturnField();
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                field = this.binaryReturnField();
                break;
            }
            case 7: 
            case 12: 
            case 17: 
            case 19: 
            case 42: 
            case 43: 
            case 44: {
                field = this.aggregableReturnField();
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                field = this.nonAggregableReturnField();
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: {
                field = this.aggregateField();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 25: {
                this.match(25);
                name = this.word();
                field.setColumnName(name);
                break;
            }
            case 1: 
            case 20: 
            case 22: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return field;
    }

    public final ReturnClause.Field numericReturnField() throws RecognitionException, TokenStreamException {
        ReturnClause.IntTypeField field;
        switch (this.LA(1)) {
            case 34: {
                this.match(34);
                field = new ReturnClause.TotalLinesField();
                break;
            }
            case 35: {
                this.match(35);
                field = new ReturnClause.LinesAddedField();
                break;
            }
            case 36: {
                this.match(36);
                field = new ReturnClause.LinesRemovedField();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return field;
    }

    public final ReturnClause.Field binaryReturnField() throws RecognitionException, TokenStreamException {
        ReturnClause.StringTypeField field;
        switch (this.LA(1)) {
            case 37: {
                this.match(37);
                field = new ReturnClause.IsBinaryField();
                break;
            }
            case 38: {
                this.match(38);
                field = new ReturnClause.IsDeletedField();
                break;
            }
            case 39: {
                this.match(39);
                field = new ReturnClause.IsAddedField();
                break;
            }
            case 40: {
                this.match(40);
                field = new ReturnClause.IsMovedField();
                break;
            }
            case 41: {
                this.match(41);
                field = new ReturnClause.IsCopiedField();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return field;
    }

    public final ReturnClause.Field aggregableReturnField() throws RecognitionException, TokenStreamException {
        ReturnClause.Field field;
        switch (this.LA(1)) {
            case 17: {
                this.match(17);
                field = new ReturnClause.PathField();
                break;
            }
            case 7: {
                this.match(7);
                field = new ReturnClause.DirField();
                break;
            }
            case 42: {
                this.match(42);
                field = new ReturnClause.AuthorField();
                break;
            }
            case 12: {
                this.match(12);
                field = new ReturnClause.DateField();
                break;
            }
            case 19: {
                this.match(19);
                field = new ReturnClause.ChangeSetField();
                break;
            }
            case 43: {
                this.match(43);
                field = new ReturnClause.TagsField();
                break;
            }
            case 44: {
                this.match(44);
                field = new ReturnClause.ReviewsField();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return field;
    }

    public final ReturnClause.Field nonAggregableReturnField() throws RecognitionException, TokenStreamException {
        ReturnClause.Field field;
        switch (this.LA(1)) {
            case 45: {
                this.match(45);
                field = new ReturnClause.RevisionField();
                break;
            }
            case 46: 
            case 47: {
                switch (this.LA(1)) {
                    case 46: {
                        this.match(46);
                        break;
                    }
                    case 47: {
                        this.match(47);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                field = new ReturnClause.CommentField();
                break;
            }
            case 48: {
                this.match(48);
                field = new ReturnClause.ChangeSetCommentField();
                break;
            }
            case 49: {
                this.match(49);
                field = new ReturnClause.AncestorField();
                break;
            }
            case 50: {
                this.match(50);
                field = new ReturnClause.P4JobsFixedField();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return field;
    }

    public final ReturnClause.AggregateField aggregateField() throws RecognitionException, TokenStreamException {
        ReturnClause.AggregateField field;
        Object name = null;
        switch (this.LA(1)) {
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                switch (this.LA(1)) {
                    case 26: {
                        this.match(26);
                        field = new ReturnClause.SumField();
                        break;
                    }
                    case 27: {
                        this.match(27);
                        field = new ReturnClause.AverageField();
                        break;
                    }
                    case 28: {
                        this.match(28);
                        field = new ReturnClause.MaxField();
                        break;
                    }
                    case 29: {
                        this.match(29);
                        field = new ReturnClause.MinField();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(30);
                ReturnClause.Field returnField = this.numericReturnField();
                field.setReturnField(returnField);
                this.match(31);
                break;
            }
            case 32: {
                this.match(32);
                this.match(30);
                switch (this.LA(1)) {
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: {
                        ReturnClause.Field returnField = this.binaryReturnField();
                        field = new ReturnClause.CountBooleansField(returnField);
                        break;
                    }
                    case 5: {
                        this.match(5);
                        field = new ReturnClause.CountRevisionsField();
                        break;
                    }
                    case 33: {
                        this.match(33);
                        ReturnClause.Field returnField = this.aggregableReturnField();
                        field = new ReturnClause.CountDistinctField(returnField);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(31);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return field;
    }

    public final Clause clauses2() throws RecognitionException, TokenStreamException {
        Clause c2 = null;
        AndClause r2 = null;
        AndClause ret = r2 = new AndClause();
        c2 = this.clause();
        r2.addClause(c2);
        while (this.LA(1) == 22 || this.LA(1) == 52) {
            switch (this.LA(1)) {
                case 52: {
                    this.match(52);
                    break;
                }
                case 22: {
                    this.match(22);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            c2 = this.clause();
            r2.addClause(c2);
        }
        return ret;
    }

    public final Clause clause() throws RecognitionException, TokenStreamException {
        Clause c2;
        switch (this.LA(1)) {
            case 30: {
                this.match(30);
                c2 = this.clauses();
                this.match(31);
                break;
            }
            case 53: {
                c2 = this.notClause();
                break;
            }
            case 17: {
                c2 = this.pathClause();
                break;
            }
            case 12: {
                c2 = this.dateClause();
                break;
            }
            case 42: {
                c2 = this.authorClause();
                break;
            }
            case 46: 
            case 47: {
                c2 = this.commentClause();
                break;
            }
            case 68: {
                c2 = this.addedLineClause();
                break;
            }
            case 69: {
                c2 = this.removedLineClause();
                break;
            }
            case 67: {
                c2 = this.contentClause();
                break;
            }
            case 19: {
                c2 = this.csidClause();
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                c2 = this.onBranchClause();
                break;
            }
            case 76: {
                c2 = this.taggedClause();
                break;
            }
            case 70: {
                c2 = this.p4JobIdClause();
                break;
            }
            case 84: {
                c2 = this.reviewedClause();
                break;
            }
            default: {
                if (!(this.LA(1) != 77 && this.LA(1) != 78 && this.LA(1) != 80 || this.LA(2) != 43 && this.LA(2) != 79)) {
                    c2 = this.taggedRangeClause();
                    break;
                }
                if (this.LA(1) == 81 && this.LA(2) == 82) {
                    c2 = this.headClause();
                    break;
                }
                if (this.LA(1) == 81 && (this.LA(2) == 73 || this.LA(2) == 83)) {
                    c2 = this.deadClause();
                    break;
                }
                if (this.LA(1) == 81 && this.LA(2) == 72) {
                    c2 = this.addedClause();
                    break;
                }
                if (!(this.LA(1) != 58 && this.LA(1) != 80 || this.LA(2) != 51 && this.LA(2) != 85 && this.LA(2) != 86)) {
                    c2 = this.reviewClause();
                    break;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return c2;
    }

    public final Clause notClause() throws RecognitionException, TokenStreamException {
        Clause sub = null;
        this.match(53);
        sub = this.clause();
        NotClause c2 = new NotClause(sub);
        return c2;
    }

    public final Clause pathClause() throws RecognitionException, TokenStreamException {
        String w2 = null;
        boolean invert = false;
        boolean glob = true;
        this.match(17);
        block0 : switch (this.LA(1)) {
            case 53: 
            case 54: {
                switch (this.LA(1)) {
                    case 53: {
                        this.match(53);
                        invert = true;
                        break;
                    }
                    case 54: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(54);
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                switch (this.LA(1)) {
                    case 55: 
                    case 56: {
                        switch (this.LA(1)) {
                            case 55: {
                                this.match(55);
                                break;
                            }
                            case 56: {
                                this.match(56);
                                break;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                        glob = false;
                        break block0;
                    }
                    case 57: {
                        this.match(57);
                        glob = false;
                        invert = true;
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        w2 = this.word();
        PathClause c2 = new PathClause(w2, glob, invert);
        return c2;
    }

    public final Clause dateClause() throws RecognitionException, TokenStreamException {
        Clause c2;
        long d1 = 0L;
        long d2 = 0L;
        int op = 1;
        DateRangeClause drc = null;
        DateClause dc = null;
        this.match(12);
        block0 : switch (this.LA(1)) {
            case 58: {
                this.match(58);
                c2 = drc = new DateRangeClause();
                switch (this.LA(1)) {
                    case 30: {
                        this.match(30);
                        drc.setMinInclusive(false);
                        break;
                    }
                    case 59: {
                        this.match(59);
                        drc.setMinInclusive(true);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                d1 = this.dateExpression();
                drc.setMin(d1);
                this.match(22);
                d2 = this.dateExpression();
                drc.setMax(d2);
                switch (this.LA(1)) {
                    case 31: {
                        this.match(31);
                        drc.setMaxInclusive(false);
                        break block0;
                    }
                    case 60: {
                        this.match(60);
                        drc.setMaxInclusive(true);
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                switch (this.LA(1)) {
                    case 61: {
                        this.match(61);
                        op = 3;
                        break;
                    }
                    case 62: {
                        this.match(62);
                        op = 4;
                        break;
                    }
                    case 63: {
                        this.match(63);
                        op = 5;
                        break;
                    }
                    case 64: {
                        this.match(64);
                        op = 6;
                        break;
                    }
                    case 57: {
                        this.match(57);
                        op = 2;
                        break;
                    }
                    case 55: 
                    case 56: {
                        switch (this.LA(1)) {
                            case 55: {
                                this.match(55);
                                break;
                            }
                            case 56: {
                                this.match(56);
                                break;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                        op = 1;
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                d1 = this.dateExpression();
                dc = new DateClause(d1, op);
                c2 = dc;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return c2;
    }

    public final Clause authorClause() throws RecognitionException, TokenStreamException {
        String s2 = null;
        ArrayList<String> l2 = null;
        this.match(42);
        switch (this.LA(1)) {
            case 55: {
                this.match(55);
                s2 = this.word();
                l2 = new ArrayList<String>(1);
                l2.add(s2);
                break;
            }
            case 58: {
                this.match(58);
                this.match(30);
                l2 = this.wordList();
                this.match(31);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        AuthorsClause c2 = new AuthorsClause(l2);
        return c2;
    }

    public final Clause commentClause() throws RecognitionException, TokenStreamException {
        Clause c2;
        String s2 = null;
        switch (this.LA(1)) {
            case 46: {
                this.match(46);
                break;
            }
            case 47: {
                this.match(47);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 65: {
                this.match(65);
                s2 = this.word();
                c2 = new CommentClause(s2);
                break;
            }
            case 66: {
                this.match(66);
                s2 = this.string();
                try {
                    c2 = new CommentRegexClause(Pattern.compile(s2));
                    break;
                }
                catch (PatternSyntaxException e2) {
                    throw new RecognitionException(e2.getMessage());
                }
            }
            case 55: {
                this.match(55);
                s2 = this.string();
                c2 = new CommentExactMatchClause(s2);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return c2;
    }

    public final Clause addedLineClause() throws RecognitionException, TokenStreamException {
        String s2 = null;
        this.match(68);
        this.match(65);
        s2 = this.word();
        AddedLineClause c2 = new AddedLineClause(s2);
        return c2;
    }

    public final Clause removedLineClause() throws RecognitionException, TokenStreamException {
        String s2 = null;
        this.match(69);
        this.match(65);
        s2 = this.word();
        RemovedLineClause c2 = new RemovedLineClause(s2);
        return c2;
    }

    public final Clause contentClause() throws RecognitionException, TokenStreamException {
        String s2 = null;
        this.match(67);
        this.match(65);
        s2 = this.word();
        ContentClause c2 = new ContentClause(s2);
        return c2;
    }

    public final Clause csidClause() throws RecognitionException, TokenStreamException {
        String s2 = null;
        this.match(19);
        this.match(55);
        s2 = this.word();
        CsidExactMatchClause c2 = new CsidExactMatchClause(s2);
        return c2;
    }

    public final Clause onBranchClause() throws RecognitionException, TokenStreamException {
        boolean modified = false;
        boolean added = false;
        boolean deleted = false;
        String b2 = null;
        switch (this.LA(1)) {
            case 71: {
                this.match(71);
                modified = true;
                break;
            }
            case 72: {
                this.match(72);
                added = true;
                break;
            }
            case 73: {
                this.match(73);
                deleted = true;
                break;
            }
            case 74: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(74);
        this.match(75);
        b2 = this.word();
        OnBranchClause c2 = new OnBranchClause(b2, modified, added, deleted);
        return c2;
    }

    public final Clause taggedClause() throws RecognitionException, TokenStreamException {
        String b2 = null;
        int op = 1;
        this.match(76);
        switch (this.LA(1)) {
            case 61: {
                this.match(61);
                op = 3;
                break;
            }
            case 62: {
                this.match(62);
                op = 4;
                break;
            }
            case 63: {
                this.match(63);
                op = 5;
                break;
            }
            case 64: {
                this.match(64);
                op = 6;
                break;
            }
            case 57: {
                this.match(57);
                op = 2;
                break;
            }
            case 55: 
            case 56: {
                switch (this.LA(1)) {
                    case 55: {
                        this.match(55);
                        break;
                    }
                    case 56: {
                        this.match(56);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                op = 1;
                break;
            }
            case 21: 
            case 90: 
            case 91: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        b2 = this.word();
        TaggedClause c2 = new TaggedClause(b2, op);
        return c2;
    }

    public final Clause taggedRangeClause() throws RecognitionException, TokenStreamException {
        TaggedRangeClause tc;
        String t2 = null;
        TaggedRangeClause c2 = tc = new TaggedRangeClause();
        block0 : switch (this.LA(1)) {
            case 77: {
                this.match(77);
                this.match(43);
                switch (this.LA(1)) {
                    case 30: {
                        this.match(30);
                        tc.setStartInclusive(false);
                        break;
                    }
                    case 59: {
                        this.match(59);
                        tc.setStartInclusive(true);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                t2 = this.word();
                tc.setStartTag(t2);
                this.match(22);
                t2 = this.word();
                tc.setEndTag(t2);
                switch (this.LA(1)) {
                    case 31: {
                        this.match(31);
                        tc.setEndInclusive(false);
                        break block0;
                    }
                    case 60: {
                        this.match(60);
                        tc.setEndInclusive(true);
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 78: {
                this.match(78);
                this.match(79);
                t2 = this.word();
                tc.setStartTag(t2);
                tc.setStartInclusive(false);
                break;
            }
            case 80: {
                this.match(80);
                this.match(79);
                t2 = this.word();
                tc.setEndTag(t2);
                tc.setEndInclusive(false);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return c2;
    }

    public final Clause headClause() throws RecognitionException, TokenStreamException {
        String br = null;
        this.match(81);
        this.match(82);
        switch (this.LA(1)) {
            case 74: {
                this.match(74);
                br = this.word();
                break;
            }
            case 1: 
            case 10: 
            case 15: 
            case 20: 
            case 22: 
            case 24: 
            case 31: 
            case 51: 
            case 52: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        HeadClause c2 = new HeadClause(br);
        return c2;
    }

    public final Clause deadClause() throws RecognitionException, TokenStreamException {
        this.match(81);
        switch (this.LA(1)) {
            case 83: {
                this.match(83);
                break;
            }
            case 73: {
                this.match(73);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        StateClause c2 = StateClause.isDeleted();
        return c2;
    }

    public final Clause addedClause() throws RecognitionException, TokenStreamException {
        this.match(81);
        this.match(72);
        StateClause c2 = StateClause.isAdded();
        return c2;
    }

    public final Clause p4JobIdClause() throws RecognitionException, TokenStreamException {
        Clause c2;
        String jobId = null;
        this.match(70);
        switch (this.LA(1)) {
            case 55: {
                this.match(55);
                jobId = this.word();
                c2 = new P4FixesClause(jobId);
                break;
            }
            case 66: {
                this.match(66);
                jobId = this.word();
                c2 = new P4FixesRegexClause(Pattern.compile(jobId));
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return c2;
    }

    public final Clause reviewClause() throws RecognitionException, TokenStreamException {
        boolean in = false;
        boolean before = false;
        String permaid = null;
        EnumSet<StateManager.MetaState> metaStates = null;
        block0 : switch (this.LA(1)) {
            case 58: {
                this.match(58);
                in = true;
                switch (this.LA(1)) {
                    case 51: {
                        this.match(51);
                        this.match(80);
                        before = true;
                        break block0;
                    }
                    case 85: 
                    case 86: {
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 80: {
                this.match(80);
                before = true;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 85: {
                this.match(85);
                permaid = this.word();
                break;
            }
            case 86: {
                metaStates = EnumSet.allOf(StateManager.MetaState.class);
                this.match(86);
                switch (this.LA(1)) {
                    case 87: 
                    case 88: 
                    case 89: {
                        metaStates = this.metaStateList();
                        break;
                    }
                    case 85: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(85);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        ReviewClause c2 = new ReviewClause(in, before, permaid, metaStates);
        return c2;
    }

    public final Clause reviewedClause() throws RecognitionException, TokenStreamException {
        EnumSet<StateManager.MetaState> metaStates = EnumSet.of(StateManager.MetaState.CLOSED);
        ReviewClause c2 = new ReviewClause(true, true, null, metaStates);
        this.match(84);
        return c2;
    }

    protected final long dateExpression() throws RecognitionException, TokenStreamException {
        Token d2 = null;
        d2 = this.LT(1);
        this.match(90);
        long ts = ((QueryLangLexer.DateToken)d2).date;
        return ts;
    }

    protected final List wordList() throws RecognitionException, TokenStreamException {
        String s2 = null;
        ArrayList<String> l2 = new ArrayList<String>();
        s2 = this.word();
        l2.add(s2);
        while (this.LA(1) == 22) {
            this.match(22);
            s2 = this.word();
            l2.add(s2);
        }
        return l2;
    }

    protected final String string() throws RecognitionException, TokenStreamException {
        Token str = null;
        str = this.LT(1);
        this.match(91);
        String w2 = ((QueryLangLexer.StringLiteralToken)str).value;
        return w2;
    }

    public final Clause changesetCommentClause() throws RecognitionException, TokenStreamException {
        String s2 = null;
        this.match(48);
        this.match(65);
        s2 = this.word();
        ChangesetCommentClause.Match c2 = new ChangesetCommentClause.Match(s2);
        return c2;
    }

    protected final EnumSet<StateManager.MetaState> metaStateList() throws RecognitionException, TokenStreamException {
        EnumSet<StateManager.MetaState> states = EnumSet.noneOf(StateManager.MetaState.class);
        StateManager.MetaState state = this.metaState();
        states.add(state);
        while (this.LA(1) == 22) {
            this.match(22);
            state = this.metaState();
            states.add(state);
        }
        return states;
    }

    protected final StateManager.MetaState metaState() throws RecognitionException, TokenStreamException {
        StateManager.MetaState state;
        switch (this.LA(1)) {
            case 87: {
                this.match(87);
                state = StateManager.MetaState.DRAFT;
                break;
            }
            case 88: {
                this.match(88);
                state = StateManager.MetaState.OPEN;
                break;
            }
            case 89: {
                this.match(89);
                state = StateManager.MetaState.CLOSED;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return state;
    }
}

