/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.query;

import antlr.NoViableAltException;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.search.query.Clause;
import com.cenqua.fisheye.search.query.QueryLangLexer;
import com.cenqua.fisheye.search.query.QueryLangParser;
import com.cenqua.fisheye.search.query.ReturnClause;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FishQuery {
    public static final int DEFAULT_INMEMORY_RESULT_LIMIT = Integer.MAX_VALUE;
    private Clause mWhereClause;
    private ReturnClause returnClause;
    private GroupBy groupByType = GroupBy.NONE;
    private OrderByType orderByType = OrderByType.NONE;
    private Path mFromPath = null;
    private OrderByDir orderByDirection = OrderByDir.ASCENDING;
    private Integer limitOffset = null;
    private Integer limitDuration = null;
    private int inMemoryResultLimit = Integer.MAX_VALUE;

    public FishQuery getShallowCopy() {
        FishQuery fq = new FishQuery();
        fq.mWhereClause = this.mWhereClause;
        fq.returnClause = this.returnClause;
        fq.groupByType = this.groupByType;
        fq.orderByType = this.orderByType;
        fq.mFromPath = this.mFromPath;
        fq.orderByDirection = this.orderByDirection;
        fq.limitOffset = this.limitOffset;
        fq.limitDuration = this.limitDuration;
        fq.inMemoryResultLimit = this.inMemoryResultLimit;
        return fq;
    }

    public void setHintInMemoryResultLimit(int size) {
        this.inMemoryResultLimit = size;
    }

    public int getHintInMemoryResultLimit() {
        return this.inMemoryResultLimit;
    }

    public Clause getWhereClause() {
        return this.mWhereClause;
    }

    public void setWhereClause(Clause whereClause) {
        this.mWhereClause = whereClause;
    }

    public void setGroupBy(GroupBy type) {
        this.groupByType = type;
    }

    public GroupBy getGroupByType() {
        return this.groupByType;
    }

    public OrderByType getOrderByType() {
        return this.orderByType;
    }

    public void setOrderBy(OrderByType orderByType) {
        this.orderByType = orderByType;
    }

    public void setLimit(Integer offset, Integer duration) {
        this.limitOffset = offset;
        this.limitDuration = duration;
    }

    public boolean isLimited() {
        return this.limitOffset != null || this.limitDuration != null;
    }

    public Integer getLimitOffset() {
        return this.limitOffset;
    }

    public Integer getLimitDuration() {
        return this.limitDuration;
    }

    public void setFromPath(Path path) {
        this.mFromPath = path;
    }

    public Path getFromPath() {
        return this.mFromPath;
    }

    public ReturnClause getReturnClause() {
        return this.returnClause;
    }

    public void setReturnClause(ReturnClause returnClause) {
        this.returnClause = returnClause;
    }

    public OrderByDir getOrderByDirection() {
        return this.orderByDirection;
    }

    public void setOrderByDirection(OrderByDir orderByDirection) {
        this.orderByDirection = orderByDirection;
    }

    public static FishQuery parse(String ql, List<String> errors) {
        QueryLangLexer lex = new QueryLangLexer(new StringReader(ql));
        lex.timezone = AppConfig.getsConfig().getTimezone();
        QueryLangParser parser = new QueryLangParser(lex);
        try {
            FishQuery fishQuery = parser.query();
            if (fishQuery.getReturnClause() != null && fishQuery.getReturnClause().hasAggregates()) {
                for (ReturnClause.Field field : fishQuery.getReturnClause().getFields()) {
                    if (fishQuery.getGroupByType().isValidWithAggregates(field)) continue;
                    if (fishQuery.getGroupByType() == GroupBy.NONE) {
                        errors.add("error parsing query: return field \"" + field.getColumnName() + "\" not compatible with aggregates");
                        continue;
                    }
                    errors.add("error parsing query: return field \"" + field.getColumnName() + "\" not compatible with aggregates and group by \"" + (Object)((Object)fishQuery.getGroupByType()) + "\"; valid non-aggregates: " + fishQuery.getGroupByType().getValidNonAggregatesWithAggregates());
                }
                if (!errors.isEmpty()) {
                    return null;
                }
            }
            return fishQuery;
        }
        catch (NoViableAltException e2) {
            if (e2.token == null || e2.token.getText() == null) {
                errors.add("error parsing query: unexpected <EOF> at character " + e2.getColumn());
            } else {
                errors.add("error parsing query: " + e2.getMessage());
            }
        }
        catch (RecognitionException e3) {
            errors.add("error parsing query: " + e3.getMessage());
        }
        catch (TokenStreamException e4) {
            errors.add("error parsing query: " + e4.getMessage());
        }
        return null;
    }

    public String makeQueryString() {
        StringBuffer buf = new StringBuffer();
        buf.append("select revisions");
        if (this.mFromPath != null) {
            buf.append(" from dir ");
            buf.append(Clause.quoteString("/" + this.mFromPath));
        }
        if (this.mWhereClause != null) {
            buf.append(" where ");
            this.mWhereClause.toString(buf);
        }
        if (this.orderByType == OrderByType.DATE) {
            buf.append(" order by date ");
            buf.append(this.orderByDirection != OrderByDir.ASCENDING ? " desc " : " asc ");
        }
        if (this.groupByType != GroupBy.NONE) {
            buf.append(" group by ").append((Object)this.groupByType);
        }
        if (this.returnClause != null) {
            buf.append(" return ");
            this.returnClause.toString(buf);
        }
        return buf.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        FishQuery fishQuery = (FishQuery)o2;
        if (this.inMemoryResultLimit != fishQuery.inMemoryResultLimit) {
            return false;
        }
        if (this.groupByType != fishQuery.groupByType) {
            return false;
        }
        if (this.limitDuration != null ? !this.limitDuration.equals(fishQuery.limitDuration) : fishQuery.limitDuration != null) {
            return false;
        }
        if (this.limitOffset != null ? !this.limitOffset.equals(fishQuery.limitOffset) : fishQuery.limitOffset != null) {
            return false;
        }
        if (this.mFromPath != null ? !this.mFromPath.equals(fishQuery.mFromPath) : fishQuery.mFromPath != null) {
            return false;
        }
        if (this.mWhereClause != null ? !this.mWhereClause.equals(fishQuery.mWhereClause) : fishQuery.mWhereClause != null) {
            return false;
        }
        if (this.orderByDirection != fishQuery.orderByDirection) {
            return false;
        }
        if (this.orderByType != fishQuery.orderByType) {
            return false;
        }
        return !(this.returnClause != null ? !this.returnClause.equals(fishQuery.returnClause) : fishQuery.returnClause != null);
    }

    public int hashCode() {
        int result = this.mWhereClause != null ? this.mWhereClause.hashCode() : 0;
        result = 31 * result + (this.returnClause != null ? this.returnClause.hashCode() : 0);
        result = 31 * result + (this.groupByType != null ? this.groupByType.hashCode() : 0);
        result = 31 * result + (this.orderByType != null ? this.orderByType.hashCode() : 0);
        result = 31 * result + (this.mFromPath != null ? this.mFromPath.hashCode() : 0);
        result = 31 * result + (this.orderByDirection != null ? this.orderByDirection.hashCode() : 0);
        result = 31 * result + (this.limitOffset != null ? this.limitOffset.hashCode() : 0);
        result = 31 * result + (this.limitDuration != null ? this.limitDuration.hashCode() : 0);
        result = 31 * result + this.inMemoryResultLimit;
        return result;
    }

    public static enum OrderByDir {
        ASCENDING,
        DESCENDING;

    }

    public static enum OrderByType {
        NONE,
        DATE;

    }

    public static enum GroupBy {
        NONE("revision", "revisions", new String[0]),
        FILE("file", "files", "path"),
        DIRECTORY("dir", "directories", "dir"),
        CHANGESET("changeset", "changesets", "csid", "author", "comment", "date");

        private static Map<String, GroupBy> nameToEnum;
        private final String aggregatesResultsType;
        private final String[] nonAggregateFields;
        private final String param;

        private GroupBy(String param, String aggregatesResultsType, String ... nonAggregateFields) {
            this.param = param;
            this.aggregatesResultsType = aggregatesResultsType;
            this.nonAggregateFields = nonAggregateFields;
        }

        public String getGroupID(FileRevision rev) {
            switch (this) {
                case CHANGESET: {
                    return rev.getChangeSetId();
                }
                case DIRECTORY: {
                    return rev.getPath().getParent().getPath();
                }
                case FILE: {
                    return rev.getPath().toString();
                }
            }
            return "None";
        }

        public boolean isValidWithAggregates(ReturnClause.Field field) {
            if (field instanceof ReturnClause.AggregateField) {
                return true;
            }
            for (String nonAggregateField : this.nonAggregateFields) {
                if (!nonAggregateField.equals(field.getColumnName())) continue;
                return true;
            }
            return false;
        }

        public String getValidNonAggregatesWithAggregates() {
            return Arrays.toString(this.nonAggregateFields);
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        public String getAggregateResultType() {
            if (this == NONE) {
                return "result";
            }
            return this.toString();
        }

        public String getAggregatesResultsType() {
            return this.aggregatesResultsType;
        }

        public static GroupBy fromString(String groupByParam) {
            if (groupByParam == null || !nameToEnum.containsKey(groupByParam)) {
                return CHANGESET;
            }
            return nameToEnum.get(groupByParam);
        }

        public String getParam() {
            return this.param;
        }

        static {
            nameToEnum = new HashMap<String, GroupBy>();
            for (GroupBy groupBy : GroupBy.values()) {
                nameToEnum.put(groupBy.param, groupBy);
            }
        }
    }
}

