/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.query;

import com.cenqua.fisheye.search.ClauseVisitor;
import com.cenqua.fisheye.search.query.Clause;
import com.cenqua.fisheye.util.ISO8601DateHelper;

public class DateRangeClause
extends Clause {
    private Long mMinDate;
    private Long mMaxDate;
    private boolean mMinInclusive = true;
    private boolean mMaxInclusive = true;

    public DateRangeClause() {
    }

    public DateRangeClause(long min, boolean minInclusive, long max, boolean maxInclusive) {
        this.mMinDate = min;
        this.mMaxDate = max;
        this.mMinInclusive = minInclusive;
        this.mMaxInclusive = maxInclusive;
    }

    public void setMin(long min) {
        this.mMinDate = min;
    }

    public void setMax(long max) {
        this.mMaxDate = max;
    }

    public Long getMinDate() {
        return this.mMinDate;
    }

    public Long getMaxDate() {
        return this.mMaxDate;
    }

    public boolean isMinInclusive() {
        return this.mMinInclusive;
    }

    public void setMinInclusive(boolean minInclusive) {
        this.mMinInclusive = minInclusive;
    }

    public boolean isMaxInclusive() {
        return this.mMaxInclusive;
    }

    public void setMaxInclusive(boolean maxInclusive) {
        this.mMaxInclusive = maxInclusive;
    }

    @Override
    public void accept(ClauseVisitor visitor) {
        visitor.visitDateClause(this);
    }

    @Override
    public void toString(StringBuffer buf) {
        boolean hasMax;
        buf.append("date ");
        boolean hasMin = this.mMinDate != null;
        boolean bl = hasMax = this.mMaxDate != null;
        if (hasMin && hasMax) {
            buf.append("in ");
            buf.append(this.mMinInclusive ? "[" : "(");
            DateRangeClause.formatDate(this.mMinDate, buf);
            buf.append(", ");
            DateRangeClause.formatDate(this.mMaxDate, buf);
            buf.append(this.mMaxInclusive ? "]" : ")");
        } else if (hasMin) {
            buf.append(this.mMinInclusive ? ">=" : ">");
            buf.append(" ");
            DateRangeClause.formatDate(this.mMinDate, buf);
        } else {
            buf.append(this.mMaxInclusive ? "<=" : "<");
            buf.append(" ");
            DateRangeClause.formatDate(this.mMaxDate, buf);
        }
    }

    private static void formatDate(Long date, StringBuffer buf) {
        buf.append(ISO8601DateHelper.toIsoDate(date));
    }
}

