/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.query;

import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.search.ClauseVisitor;
import com.cenqua.fisheye.search.query.AbstractRelationalOperatorClause;
import com.cenqua.fisheye.search.query.AbstractTermClause;
import com.cenqua.fisheye.search.query.Clause;
import com.cenqua.fisheye.search.query.DateRangeClause;
import com.cenqua.fisheye.search.query.NotClause;
import com.cenqua.fisheye.util.ISO8601DateHelper;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;

public class DateClause
extends AbstractRelationalOperatorClause {
    private final long date;
    private final Clause delegate;

    public DateClause(long date, int op) {
        super(op);
        this.date = date;
        if (op == 1 || op == 2) {
            y val = y.a().b(date);
            AbstractTermClause clause = new AbstractTermClause(CommonSchema.E_DATE_TO_REVID, val, null){

                @Override
                void toString(StringBuffer buf) {
                    DateClause.this.toString(buf);
                }
            };
            this.delegate = op == 1 ? clause : new NotClause(clause);
        } else {
            DateRangeClause clause = new DateRangeClause();
            if (op == 3) {
                clause.setMax(date);
                clause.setMaxInclusive(false);
            } else if (op == 4) {
                clause.setMax(date);
                clause.setMaxInclusive(true);
            } else if (op == 5) {
                clause.setMin(date);
                clause.setMinInclusive(false);
            } else if (op == 6) {
                clause.setMin(date);
                clause.setMinInclusive(true);
            }
            this.delegate = clause;
        }
    }

    @Override
    public void accept(ClauseVisitor visitor) throws IOException, DbException {
        this.delegate.accept(visitor);
    }

    @Override
    void toString(StringBuffer buf) {
        buf.append("date ");
        this.operatorToString(buf);
        buf.append(" ");
        buf.append(ISO8601DateHelper.toIsoDate(this.date));
    }
}

