/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.query;

import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.search.ClauseVisitor;
import com.cenqua.fisheye.search.query.Clause;
import java.io.IOException;
import java.util.regex.Pattern;

public class ChangesetCommentClause {

    public static class RegexMatch
    extends Clause {
        private final Pattern mMatch;

        private RegexMatch(Pattern match) {
            this.mMatch = match;
        }

        public Pattern getMatch() {
            return this.mMatch;
        }

        @Override
        public void toString(StringBuffer buf) {
            buf.append("changeset.comment =~ ");
            RegexMatch.quoteString(this.mMatch.pattern(), buf);
        }

        @Override
        public void accept(ClauseVisitor visitor) throws DbException {
        }
    }

    public static class Match
    extends Clause {
        private final String mMatch;
        private final boolean exact;

        public Match(String match) {
            this(match, false);
        }

        private Match(String match, boolean exact) {
            this.mMatch = match;
            this.exact = exact;
        }

        public String getMatch() {
            return this.mMatch;
        }

        @Override
        public void accept(ClauseVisitor visitor) throws IOException {
            if (this.exact) {
                // empty if block
            }
        }

        @Override
        public void toString(StringBuffer buf) {
            buf.append("changeset.comment ");
            buf.append(this.exact ? "= " : "matches ");
            Match.quoteString(this.mMatch, buf);
        }
    }
}

