/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.query;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.infinitydb.query3.Query3Params;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.search.QueryBuilder;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.SimpleGrouper;
import com.cenqua.fisheye.search.SimpleSearchResults;
import com.cenqua.fisheye.search.query.Clause;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.search.query.QueryEvaluator;
import com.cenqua.fisheye.util.CompareUtil;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.p;
import com.cenqua.obfuscate.idb.y;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;
import org.apache.lucene.queryParser.ParseException;

public class BaseQueryEvaluator
implements QueryEvaluator {
    private RepositoryEngine repoEngine;
    private QueryBuilder qb;

    public BaseQueryEvaluator(RepositoryEngine repoEngine, QueryBuilder qb) {
        this.repoEngine = repoEngine;
        this.qb = qb;
    }

    protected BaseRevisionCache<?, ?, ?> getRevisionCache() {
        return (BaseRevisionCache)this.repoEngine.getRevisionCache();
    }

    protected LuceneConnection<LuceneIndexes> getLuceneConnection() {
        return this.repoEngine.getIndexConnection();
    }

    protected LuceneConnection<CrossRepLuceneIndexes> getCrossRepLuceneConnection() {
        return this.repoEngine.getCrossRepLuceneConnection();
    }

    protected AndQuery3 createQuery3(FishQuery query) throws IOException, DbException {
        Path fromPath = query.getFromPath();
        if (fromPath == null) {
            fromPath = Path.ROOT;
        }
        AndQuery3 bq = CommonQuery3Helper.findRevisionsUnderDirAndQuery3(fromPath, this.isCaseSensitive());
        Clause where = query.getWhereClause();
        if (where != null) {
            where.accept(this.qb);
            Query3 q2 = this.qb.getQuery();
            if (q2 != null) {
                bq.addClause(q2);
            }
        }
        return bq;
    }

    protected boolean isCaseSensitive() {
        return this.getRevisionCache().isCaseSensitive();
    }

    private SimpleGrouper getGroupByAttribute(FishQuery query) {
        switch (query.getGroupByType()) {
            case FILE: {
                return new SimpleGrouper.LongAttributeGrouper(CommonSchema.RevInfo.A_REVKEY, query.getGroupByType().toString());
            }
            case DIRECTORY: {
                return new SimpleGrouper.LongAttributeGrouper(CommonSchema.RevInfo.A_FULLDIR, query.getGroupByType().toString());
            }
            case CHANGESET: {
                return new SimpleGrouper.StringAttributeGrouper(CommonSchema.RevInfo.A_CSID, query.getGroupByType().toString());
            }
        }
        return null;
    }

    @Override
    public SearchResults performQuery(FishQuery query) throws IOException, ParseException, DbException {
        long t0 = System.currentTimeMillis();
        AndQuery3 bq2 = this.createQuery3(query);
        ac db = this.getRevisionCache().getInfDb().get();
        ac result = bq2.asItemSpace(new Query3Params(db, (CommonStringTables)this.getRevisionCache().getStringTables(), this.getLuceneConnection(), this.getCrossRepLuceneConnection()));
        int limit = query.getHintInMemoryResultLimit();
        int STARTSIZE = 256;
        int count = 0;
        IntArrayList revids = new IntArrayList(256);
        y cu = y.a();
        boolean exceeded = false;
        while (result.d(cu)) {
            if (count >= limit) {
                exceeded = true;
            }
            ++count;
            int revid = (int)cu.v(0);
            revids.add(revid);
        }
        if (exceeded) {
            throw new DbException("your query sucks");
        }
        SimpleSearchResults collator = this.doInMemoryResults(query, db, (IntList)revids);
        long t1 = System.currentTimeMillis();
        Logs.APP_LOG.debug((Object)("qlsearch: inmem q=" + bq2 + " in " + (t1 - t0) + "ms"));
        return collator;
    }

    private SimpleSearchResults doInMemoryResults(FishQuery query, ac db, IntList revids) throws DbException {
        SimpleSearchResults collator;
        if (!FishQuery.OrderByType.NONE.equals((Object)query.getOrderByType())) {
            this.inMemoryOrderBy(db, revids, query.getOrderByType(), query.getOrderByDirection());
        }
        SimpleGrouper grouper = this.getGroupByAttribute(query);
        Object[] groupStarts = null;
        String type = "revision";
        if (grouper != null) {
            groupStarts = grouper.group(db, revids);
            type = grouper.getType();
        }
        if (query.isLimited()) {
            int origSize = revids.size();
            int lIndex = Math.min(query.getLimitOffset(), origSize);
            int maxDuration = origSize - lIndex;
            int lDuration = Math.min(query.getLimitDuration(), maxDuration);
            revids = revids.subList(lIndex, lIndex + lDuration);
            collator = new SimpleSearchResults(this.getRevisionCache(), query, type, revids, groupStarts, origSize, lIndex, lDuration);
        } else {
            collator = new SimpleSearchResults(this.getRevisionCache(), query, type, revids, groupStarts);
        }
        return collator;
    }

    private void inMemoryOrderBy(ac db, final IntList revids, FishQuery.OrderByType orderByType, FishQuery.OrderByDir orderByDirection) throws DbException {
        try {
            p attr = CommonSchema.RevInfo.A_DATE;
            long defaultVal = 0L;
            int revidsSize = revids.size();
            LongArrayList values = new LongArrayList(revidsSize);
            y cu = y.a();
            for (int i2 = 0; i2 < revidsSize; ++i2) {
                int revid = revids.getInt(i2);
                cu.f().a(CommonSchema.RevInfo.ENTITY).b((long)revid).a(attr);
                int pl = cu.e();
                long val = db.a(cu, pl) ? cu.v(pl) : defaultVal;
                values.add(val);
            }
            boolean reverse = FishQuery.OrderByDir.DESCENDING.equals((Object)orderByDirection);
            IntComparator comp = new IntComparator((LongList)values, reverse){
                final /* synthetic */ LongList val$values;
                final /* synthetic */ boolean val$reverse;
                {
                    this.val$values = longList;
                    this.val$reverse = bl;
                }

                public int compare(int i2, int j2) {
                    long a2 = this.val$values.getLong(i2);
                    long b2 = this.val$values.getLong(j2);
                    int r2 = CompareUtil.compareTo(a2, b2);
                    return this.val$reverse ? -r2 : r2;
                }
            };
            Swapper swapper = new Swapper((LongList)values){
                final /* synthetic */ LongList val$values;
                {
                    this.val$values = longList;
                }

                public void swap(int a2, int b2) {
                    int itmp = revids.getInt(a2);
                    revids.set(a2, revids.getInt(b2));
                    revids.set(b2, itmp);
                    long ltmp = this.val$values.getLong(a2);
                    this.val$values.set(a2, this.val$values.getLong(b2));
                    this.val$values.set(b2, ltmp);
                }
            };
            GenericSorting.mergeSort((int)0, (int)revidsSize, (IntComparator)comp, (Swapper)swapper);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }
}

