/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.query;

import com.cenqua.fisheye.search.ClauseVisitor;
import com.cenqua.fisheye.search.query.Clause;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AuthorsClause
extends Clause {
    private final List<String> mAuthors;

    public AuthorsClause(List<String> authors) {
        this.mAuthors = authors;
    }

    public AuthorsClause(String author) {
        this.mAuthors = new ArrayList<String>();
        this.mAuthors.add(author);
    }

    @Override
    public void accept(ClauseVisitor visitor) {
        visitor.visitAuthorsClause(this);
    }

    public Iterator getAuthors() {
        return this.mAuthors.iterator();
    }

    @Override
    public void toString(StringBuffer buf) {
        buf.append("author ");
        if (this.mAuthors.size() == 1) {
            buf.append("= ");
            AuthorsClause.quoteString(this.mAuthors.get(0), buf);
        } else {
            buf.append("in (");
            String sep = "";
            for (String au2 : this.mAuthors) {
                buf.append(sep);
                AuthorsClause.quoteString(au2, buf);
                sep = ", ";
            }
            buf.append(")");
        }
    }
}

