/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.aggregation;

import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.search.query.ReturnClause;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class ReturnFieldAggregator {
    protected ReturnClause.Field field;
    protected ReturnClause.Field referencedField;

    protected ReturnFieldAggregator(ReturnClause.AggregateField field) {
        this.field = field;
        this.referencedField = field.getReferencedField();
    }

    protected ReturnFieldAggregator(ReturnClause.Field field) {
        this.field = field;
        this.referencedField = field;
    }

    public abstract void process(FileRevision var1);

    public abstract Object getResult();

    protected ReturnClause.Field getReferencedField() {
        return this.referencedField;
    }

    public ReturnClause.Field getField() {
        return this.field;
    }

    public static class SingleDistinctValue
    extends ReturnFieldAggregator {
        private FileRevision revision;
        private boolean singleValue = true;

        public SingleDistinctValue(ReturnClause.Field field) {
            super(field);
        }

        @Override
        public void process(FileRevision fileRevision) {
            Object currentValue;
            Object value = this.getReferencedField().asObject(fileRevision);
            Object object = currentValue = this.revision != null ? this.getReferencedField().asObject(this.revision) : null;
            if (this.singleValue && this.revision != null) {
                this.singleValue = currentValue.equals(value);
            } else if (this.singleValue) {
                this.revision = fileRevision;
            }
            if (!this.singleValue) {
                this.revision = null;
            }
        }

        @Override
        public FileRevision getResult() {
            return this.revision;
        }
    }

    public static class DistinctCounter
    extends ReturnFieldAggregator {
        private Set<Object> distinctValues = Sets.newHashSet();

        public DistinctCounter(ReturnClause.AggregateField field) {
            super(field);
        }

        @Override
        public void process(FileRevision fileRevision) {
            ReturnClause.Field field = this.getReferencedField();
            if (field instanceof ReturnClause.ReviewsField) {
                List<Integer> reviews = fileRevision.getReviewIds();
                Iterator<Integer> iterator = reviews.iterator();
                while (iterator.hasNext()) {
                    long review = iterator.next().intValue();
                    this.distinctValues.add(review);
                }
            } else if (field instanceof ReturnClause.StringArrayTypeField) {
                String[] values;
                for (String v2 : values = ((ReturnClause.StringArrayTypeField)field).asStringArray(fileRevision)) {
                    this.distinctValues.add(v2);
                }
            } else {
                this.distinctValues.add(field.asString(fileRevision));
            }
        }

        @Override
        public Object getResult() {
            return this.distinctValues.size();
        }
    }

    public static class Counter
    extends ReturnFieldAggregator {
        private int count = 0;

        public Counter(ReturnClause.AggregateField field) {
            super(field);
        }

        @Override
        public void process(FileRevision fileRevision) {
            ++this.count;
        }

        @Override
        public Object getResult() {
            return this.count;
        }
    }

    public static class TrueCounter
    extends ReturnFieldAggregator {
        private int count = 0;

        public TrueCounter(ReturnClause.AggregateField field) {
            super(field);
        }

        @Override
        public void process(FileRevision fileRevision) {
            if (Boolean.valueOf(this.getReferencedField().asString(fileRevision)).booleanValue()) {
                ++this.count;
            }
        }

        @Override
        public Object getResult() {
            return this.count;
        }
    }

    public static class MinDate
    extends ReturnFieldAggregator {
        private long min = 0L;
        private boolean hasChecked = false;

        public MinDate(ReturnClause.Field field) {
            super(field);
        }

        @Override
        public void process(FileRevision fileRevision) {
            long value = this.getReferencedField().asDate(fileRevision);
            if (!this.hasChecked || value < this.min) {
                this.hasChecked = true;
                this.min = value;
            }
        }

        @Override
        public Object getResult() {
            return this.min;
        }
    }

    public static class Min
    extends ReturnFieldAggregator {
        private int min = 0;
        private boolean hasChecked = false;

        public Min(ReturnClause.AggregateField field) {
            super(field);
        }

        @Override
        public void process(FileRevision fileRevision) {
            int value;
            if (!this.hasChecked) {
                this.hasChecked = true;
                this.min = Integer.MAX_VALUE;
            }
            if ((value = this.getReferencedField().asInt(fileRevision)) < this.min) {
                this.min = value;
            }
        }

        @Override
        public Object getResult() {
            return this.min;
        }
    }

    public static class Max
    extends ReturnFieldAggregator {
        private int max = 0;

        public Max(ReturnClause.AggregateField field) {
            super(field);
        }

        @Override
        public void process(FileRevision fileRevision) {
            int value = this.getReferencedField().asInt(fileRevision);
            if (value > this.max) {
                this.max = value;
            }
        }

        @Override
        public Object getResult() {
            return this.max;
        }
    }

    public static class Sum
    extends ReturnFieldAggregator {
        private int totalCount = 0;

        public Sum(ReturnClause.AggregateField field) {
            super(field);
        }

        @Override
        public void process(FileRevision fileRevision) {
            this.totalCount += this.getReferencedField().asInt(fileRevision);
        }

        @Override
        public Object getResult() {
            return this.totalCount;
        }
    }

    public static class Average
    extends ReturnFieldAggregator {
        private int totalCount = 0;
        private int instanceCount = 0;

        public Average(ReturnClause.AggregateField field) {
            super(field);
        }

        @Override
        public void process(FileRevision fileRevision) {
            ++this.instanceCount;
            this.totalCount += this.getReferencedField().asInt(fileRevision);
        }

        @Override
        public Object getResult() {
            return this.totalCount / this.instanceCount;
        }
    }
}

