/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.aggregation;

import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.search.aggregation.ReturnFieldAggregator;
import com.cenqua.fisheye.search.query.ReturnClause;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReturnClauseAggregator {
    private List<ReturnFieldAggregator> fieldAggregators;
    private ReturnClause returnClause;

    public ReturnClauseAggregator(ReturnClause returnClause) {
        this.returnClause = returnClause;
        this.reset();
    }

    public void aggregate(FileRevision revision) {
        for (ReturnFieldAggregator aggregator : this.fieldAggregators) {
            aggregator.process(revision);
        }
    }

    public Map<ReturnClause.Field, Object> getCurrentResults() {
        HashMap results = Maps.newHashMap();
        for (ReturnFieldAggregator aggregator : this.fieldAggregators) {
            results.put(aggregator.getField(), aggregator.getResult());
        }
        return results;
    }

    public void reset() {
        this.fieldAggregators = Lists.newArrayListWithCapacity((int)this.returnClause.numFields());
        for (ReturnClause.Field field : this.returnClause.getFields()) {
            this.fieldAggregators.add(field.getAggregator());
        }
    }
}

