/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search;

import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.query.FishQuery;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.NoSuchElementException;

public class SimpleSearchResults
extends SearchResults {
    private Object[] groupStarts;
    private final IntList revids;
    private final String type;
    private static final int NOT_CALCULATED = -1;
    private int numGroups = -1;

    public SimpleSearchResults(RevisionCache mRep, FishQuery fishQuery, String type, IntList revids) {
        super(mRep, fishQuery);
        this.revids = revids;
        this.type = type;
    }

    public SimpleSearchResults(RevisionCache mRep, FishQuery fishQuery, String type, IntList revids, Object[] groupStarts) {
        super(mRep, fishQuery);
        this.revids = revids;
        this.type = type;
        this.groupStarts = groupStarts;
    }

    public SimpleSearchResults(RevisionCache mRep, FishQuery fishQuery, String type, IntList revids, Object[] groupStarts, int originalSize, int limitOffset, int limitDuration) {
        super(mRep, fishQuery);
        this.revids = revids;
        this.type = type;
        this.groupStarts = groupStarts;
        this.limit(originalSize, limitOffset, limitDuration);
    }

    @Override
    public int getRevisionCount() {
        return this.revids.size();
    }

    @Override
    public boolean isGrouped() {
        return this.groupStarts != null;
    }

    @Override
    public int getGroupCount() {
        if (!this.isGrouped()) {
            return 0;
        }
        if (this.numGroups == -1) {
            this.numGroups = 0;
            for (Object o2 : this.groupStarts) {
                if (o2 == null) continue;
                ++this.numGroups;
            }
        }
        return this.numGroups;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public SearchResults.RevisionResultsIterator iterateRevisions(int start) throws DbException {
        return new MyIterator(start);
    }

    @Override
    public SearchResults.RevisionResultsIterator iterateRevisionsFromGroup(int startGroup) throws DbException {
        int group = -1;
        for (int i2 = 0; i2 < this.groupStarts.length; ++i2) {
            if (this.groupStarts[i2] != null) {
                ++group;
            }
            if (group != startGroup) continue;
            return new MyIterator(i2);
        }
        return new MyIterator(this.groupStarts.length + 1);
    }

    class MyIterator
    extends SearchResults.RevisionResultsIterator {
        private int next = 0;
        private Object currentGroup;
        private boolean isGroupStart;

        MyIterator(int start) {
            this.next = start;
        }

        @Override
        public boolean hasNext() {
            return this.next < SimpleSearchResults.this.revids.size();
        }

        @Override
        public int nextItemId() throws Exception {
            if (this.next >= SimpleSearchResults.this.getRevisionCount()) {
                throw new NoSuchElementException("at end of list");
            }
            int revid = SimpleSearchResults.this.revids.getInt(this.next);
            if (SimpleSearchResults.this.groupStarts == null) {
                this.isGroupStart = true;
            } else {
                Object g2 = SimpleSearchResults.this.groupStarts[this.next];
                if (g2 == null) {
                    this.isGroupStart = false;
                } else {
                    this.isGroupStart = true;
                    this.currentGroup = g2;
                }
            }
            ++this.next;
            return revid;
        }

        @Override
        public Object currentGroup() {
            return this.currentGroup;
        }

        @Override
        public boolean isStartOfGroup() {
            return this.isGroupStart;
        }
    }
}

