/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.search.query.AddedLineClause;
import com.cenqua.fisheye.search.query.AndClause;
import com.cenqua.fisheye.search.query.AuthorsClause;
import com.cenqua.fisheye.search.query.CommentClause;
import com.cenqua.fisheye.search.query.ContentClause;
import com.cenqua.fisheye.search.query.DateRangeClause;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.search.query.HeadClause;
import com.cenqua.fisheye.search.query.OnBranchClause;
import com.cenqua.fisheye.search.query.PathClause;
import com.cenqua.fisheye.search.query.QueryLangLexer;
import com.cenqua.fisheye.search.query.QueryLangParser;
import com.cenqua.fisheye.search.query.RemovedLineClause;
import com.cenqua.fisheye.search.query.ReturnClause;
import com.cenqua.fisheye.search.query.TaggedClause;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.web.UrlHelper;
import com.google.common.collect.ImmutableList;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

public class SimpleSearchParameters {
    public static final List<String> DEFAULT_COLUMNS = ImmutableList.of((Object)"path", (Object)"revision", (Object)"author", (Object)"date", (Object)"csid");
    private final HttpServletRequest req;

    public SimpleSearchParameters(HttpServletRequest req) {
        this.req = req;
    }

    public FishQuery parseUserData(Path underPath, UrlHelper searchUrl) {
        String direction;
        String filename;
        String deletedText;
        String addedText;
        String comment;
        String contents;
        String branch;
        FishQuery qb = new FishQuery();
        qb.setFromPath(underPath);
        boolean sufficientCriteria = false;
        AndClause clauses = new AndClause();
        qb.setWhereClause(clauses);
        String[] authors = this.req.getParameterValues("author");
        if (authors != null && authors.length > 0) {
            ArrayList<String> l2 = new ArrayList<String>();
            for (String author : authors) {
                if (SimpleSearchParameters.isEmpty(author)) continue;
                l2.add(author);
                searchUrl.putMulti("author", author);
            }
            clauses.addClause(new AuthorsClause(l2));
            sufficientCriteria = true;
        }
        String head = this.req.getParameter("head");
        boolean isHead = false;
        if (!SimpleSearchParameters.isEmpty(head)) {
            isHead = "true".equals(head);
            searchUrl.getParams().put("head", "true");
            sufficientCriteria = true;
        }
        if (!SimpleSearchParameters.isEmpty(branch = this.req.getParameter("branch"))) {
            if (isHead) {
                clauses.addClause(new HeadClause(branch));
            } else {
                clauses.addClause(new OnBranchClause(branch, false, false, false));
            }
            searchUrl.getParams().put("branch", branch);
            sufficientCriteria = true;
        } else if (isHead) {
            clauses.addClause(new HeadClause(null));
        }
        String tag = this.req.getParameter("tag");
        if (!SimpleSearchParameters.isEmpty(tag)) {
            clauses.addClause(new TaggedClause(tag, 1));
            searchUrl.getParams().put("tag", tag);
            sufficientCriteria = true;
        }
        if (!SimpleSearchParameters.isEmpty(contents = this.req.getParameter("contents"))) {
            clauses.addClause(new ContentClause(contents));
            searchUrl.getParams().put("contents", contents);
            sufficientCriteria = true;
        }
        if (!SimpleSearchParameters.isEmpty(comment = this.req.getParameter("comment"))) {
            clauses.addClause(new CommentClause(comment));
            searchUrl.getParams().put("comment", comment);
            sufficientCriteria = true;
        }
        if (!SimpleSearchParameters.isEmpty(addedText = this.req.getParameter("addedText"))) {
            clauses.addClause(new AddedLineClause(addedText));
            searchUrl.getParams().put("addedText", addedText);
            sufficientCriteria = true;
        }
        if (!SimpleSearchParameters.isEmpty(deletedText = this.req.getParameter("deletedText"))) {
            clauses.addClause(new RemovedLineClause(deletedText));
            searchUrl.getParams().put("deletedText", deletedText);
            sufficientCriteria = true;
        }
        if (!SimpleSearchParameters.isEmpty(filename = this.req.getParameter("filename"))) {
            clauses.addClause(new PathClause(filename, AntGlob.containsExplicitOrImplicitWildcards(filename), false));
            searchUrl.getParams().put("filename", filename);
            sufficientCriteria = true;
        }
        String fromStr = this.req.getParameter("fromdate");
        String toStr = this.req.getParameter("todate");
        long now = System.currentTimeMillis();
        TimeZone tz = AppConfig.getsConfig().getTimezone();
        Long fromDate = DateHelper.parseDate(fromStr, now, tz);
        Long toDate = DateHelper.parseDate(toStr, now, tz);
        if (fromDate != null || toDate != null) {
            DateRangeClause dc = new DateRangeClause();
            if (fromDate != null) {
                dc.setMin(fromDate);
                dc.setMinInclusive(true);
                searchUrl.getParams().put("fromdate", fromStr);
            }
            if (toDate != null) {
                dc.setMax(toDate);
                dc.setMaxInclusive(true);
                searchUrl.getParams().put("todate", toStr);
            }
            clauses.addClause(dc);
            sufficientCriteria = true;
        }
        if ((direction = this.req.getParameter("datesortorder")) != null) {
            qb.setOrderBy(FishQuery.OrderByType.DATE);
            qb.setOrderByDirection(FishQuery.OrderByDir.valueOf(direction));
            searchUrl.getParams().put("datesortorder", direction);
        }
        FishQuery.GroupBy groupBy = FishQuery.GroupBy.fromString(this.req.getParameter("groupby"));
        qb.setGroupBy(groupBy);
        searchUrl.getParams().put("groupby", groupBy.getParam());
        String[] cols = this.req.getParameterValues("col");
        ReturnClause rc = new ReturnClause();
        if (cols == null || cols.length == 0) {
            cols = DEFAULT_COLUMNS.toArray(new String[DEFAULT_COLUMNS.size()]);
        }
        for (String col : cols) {
            ReturnClause.Field f2 = SimpleSearchParameters.parseReturnField(col);
            if (f2 == null) continue;
            rc.addField(f2);
            searchUrl.putMulti("col", col);
        }
        qb.setReturnClause(rc);
        if (sufficientCriteria) {
            return qb;
        }
        return null;
    }

    public static ReturnClause.Field parseReturnField(String col) {
        try {
            QueryLangLexer lex = new QueryLangLexer(new StringReader(col));
            QueryLangParser parser = new QueryLangParser(lex);
            return parser.returnField();
        }
        catch (Exception e2) {
            Logs.APP_LOG.debug((Object)("Problem parsing field: " + col), (Throwable)e2);
            return null;
        }
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

