/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.search.aggregation.ReturnClauseAggregator;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.search.query.ReturnClause;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class SearchResults {
    protected final RevisionCache mRep;
    private int mPreLimitSize = -1;
    private int mLimitOffset = -1;
    private int mLimitDuration = -1;
    private FishQuery query;
    private ReturnClause returnClause;

    protected SearchResults(RevisionCache mRep, FishQuery query) {
        this.mRep = mRep;
        this.query = query;
        this.returnClause = query.getReturnClause();
    }

    public boolean isLimited() {
        return this.mPreLimitSize != -1;
    }

    public int getPreLimitSize() {
        return this.isLimited() ? this.mPreLimitSize : this.getRevisionCount();
    }

    public int getPostLimitSize() {
        return this.getRevisionCount();
    }

    public int getLimitOffset() {
        return this.isLimited() ? this.mLimitOffset : 0;
    }

    public int getLimitDuration() {
        return this.isLimited() ? this.mLimitDuration : this.getRevisionCount();
    }

    public void limit(int oldSize, int offset, int duration) {
        this.mPreLimitSize = oldSize;
        this.mLimitOffset = offset;
        this.mLimitDuration = duration;
    }

    public int getTabularSize() {
        if (this.hasTabularResults() && this.returnClause.hasAggregates()) {
            if (this.query.getGroupByType() != FishQuery.GroupBy.NONE) {
                return this.getGroupCount();
            }
            return 1;
        }
        return this.getRevisionCount();
    }

    public int size() {
        return this.getRevisionCount();
    }

    public abstract RevisionResultsIterator iterateRevisions(int var1) throws DbException;

    public abstract RevisionResultsIterator iterateRevisionsFromGroup(int var1) throws DbException;

    public abstract boolean isGrouped();

    public abstract int getRevisionCount();

    public abstract int getGroupCount();

    public void setReturnClause(ReturnClause clause) {
        this.returnClause = clause;
    }

    public ReturnClause getReturnClause() {
        return this.returnClause;
    }

    public boolean hasTabularResults() {
        return this.getReturnClause() != null;
    }

    public FishQuery.GroupBy getGroupByTerm() {
        return this.query.getGroupByType();
    }

    public FishQuery getQuery() {
        return this.query;
    }

    public TabularResultsIterator iterateData(int start) throws DbException {
        if (!this.hasTabularResults()) {
            throw new DbException("Query has no return clause, so not tabular");
        }
        if (this.returnClause.hasAggregates()) {
            if (this.query.getGroupByType() != FishQuery.GroupBy.NONE) {
                return new GroupAggregateTabularResultsIterator(start);
            }
            return new TotalAggregateTabularResultsIterator();
        }
        return new FileRevisionTabularResultsIterator(start);
    }

    public abstract String getType();

    private class TotalAggregateTabularResultsIterator
    extends TabularResultsIterator {
        boolean done;

        private TotalAggregateTabularResultsIterator() {
            this.done = false;
        }

        @Override
        public boolean isStartOfGroup() {
            return false;
        }

        @Override
        public ResultRow nextRow() throws Exception {
            this.done = true;
            RevisionResultsIterator iterator = SearchResults.this.iterateRevisions(0);
            ReturnClauseAggregator aggregator = new ReturnClauseAggregator(SearchResults.this.getReturnClause());
            while (iterator.hasNext()) {
                aggregator.aggregate(iterator.nextItem());
            }
            return new AggregateResultRow(SearchResults.this.getReturnClause(), aggregator.getCurrentResults(), "Totals");
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }
    }

    private class GroupAggregateTabularResultsIterator
    extends TabularResultsIterator {
        private final RevisionResultsIterator resultsIterator;
        private ReturnClauseAggregator groupAggregator;
        private FileRevision nextRevision;

        private GroupAggregateTabularResultsIterator(int start) throws DbException {
            this.groupAggregator = new ReturnClauseAggregator(SearchResults.this.getReturnClause());
            this.nextRevision = null;
            this.resultsIterator = SearchResults.this.iterateRevisionsFromGroup(start);
        }

        @Override
        public boolean isStartOfGroup() {
            return true;
        }

        @Override
        public ResultRow nextRow() throws Exception {
            String groupTitle = null;
            if (!this.hasNext()) {
                throw new NoSuchElementException("!hasNext()");
            }
            this.groupAggregator.reset();
            Object group = null;
            if (this.nextRevision != null) {
                this.groupAggregator.aggregate(this.nextRevision);
                groupTitle = SearchResults.this.getGroupByTerm().getGroupID(this.nextRevision);
                this.nextRevision = null;
                group = this.resultsIterator.currentGroup();
            }
            boolean sameGroup = true;
            while (sameGroup && this.resultsIterator.hasNext()) {
                this.nextRevision = this.resultsIterator.nextItem();
                if (group != null) {
                    sameGroup = group.equals(this.resultsIterator.currentGroup());
                } else {
                    group = this.resultsIterator.currentGroup();
                }
                if (!sameGroup) continue;
                this.groupAggregator.aggregate(this.nextRevision);
                if (groupTitle == null) {
                    groupTitle = SearchResults.this.getGroupByTerm().getGroupID(this.nextRevision);
                }
                this.nextRevision = null;
            }
            return new AggregateResultRow(SearchResults.this.getReturnClause(), this.groupAggregator.getCurrentResults(), groupTitle);
        }

        @Override
        public boolean hasNext() {
            return this.nextRevision != null || this.resultsIterator.hasNext();
        }
    }

    private class FileRevisionTabularResultsIterator
    extends TabularResultsIterator {
        private final RevisionResultsIterator resultsIterator;

        public FileRevisionTabularResultsIterator(int start) throws DbException {
            this.resultsIterator = SearchResults.this.iterateRevisions(start);
        }

        @Override
        public boolean hasNext() {
            return this.resultsIterator.hasNext();
        }

        @Override
        public ResultRow nextRow() throws Exception {
            FileRevision fi = this.resultsIterator.nextItem();
            return new FileRevisionResultRow(fi);
        }

        @Override
        public boolean isStartOfGroup() {
            return this.resultsIterator.isStartOfGroup();
        }
    }

    public abstract class TabularResultsIterator
    implements Iterator<ResultRow> {
        public abstract boolean isStartOfGroup();

        public abstract ResultRow nextRow() throws Exception;

        @Override
        public ResultRow next() {
            try {
                return this.nextRow();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class AggregateResultRow
    implements ResultRow {
        private final ReturnClause clause;
        private final Map<ReturnClause.Field, Object> results;
        private final String groupTitle;

        public AggregateResultRow(ReturnClause clause, Map<ReturnClause.Field, Object> results, String groupTitle) {
            this.clause = clause;
            this.results = results;
            this.groupTitle = groupTitle;
        }

        @Override
        public Object get(int i2) {
            Object o2 = this.getValue(i2);
            if (o2 instanceof FileRevision) {
                return this.clause.getField(i2).asObject((FileRevision)o2);
            }
            return o2;
        }

        private Object getValue(int i2) {
            return this.results.get(this.clause.getField(i2));
        }

        @Override
        public Path getPath(int i2) {
            Object o2 = this.getValue(i2);
            if (o2 instanceof FileRevision) {
                return this.clause.getField(i2).asPath((FileRevision)o2);
            }
            return null;
        }

        @Override
        public String getString(int i2) {
            Object o2 = this.getValue(i2);
            if (o2 instanceof FileRevision) {
                return this.clause.getField(i2).asString((FileRevision)o2);
            }
            return String.valueOf(o2);
        }

        @Override
        public String getDisplayString(int i2) {
            Object o2 = this.getValue(i2);
            if (o2 instanceof FileRevision) {
                return this.clause.getField(i2).asDisplayString((FileRevision)o2);
            }
            return String.valueOf(o2);
        }

        @Override
        public int getInt(int i2) {
            Object o2 = this.getValue(i2);
            if (o2 instanceof FileRevision) {
                return this.clause.getField(i2).asInt((FileRevision)o2);
            }
            if (o2 instanceof Number) {
                return ((Number)o2).intValue();
            }
            return 0;
        }

        @Override
        public long getDate(int i2) {
            Object o2 = this.getValue(i2);
            if (o2 instanceof Long) {
                return (Long)o2;
            }
            return 0L;
        }

        @Override
        public String[] getStringArray(int i2) {
            return new String[0];
        }

        @Override
        public Map[] getMapArray(int i2) {
            return new Map[0];
        }

        @Override
        public List getList(int i2) {
            return null;
        }

        @Override
        public String getStringFromArray(int i2) {
            return null;
        }

        @Override
        public String getCurrentGroupHumanReadable() {
            return this.groupTitle;
        }
    }

    public class FileRevisionResultRow
    implements ResultRow {
        private final FileRevision fi;

        public FileRevisionResultRow(FileRevision fi) {
            this.fi = fi;
        }

        @Override
        public Object get(int i2) {
            return SearchResults.this.getReturnClause().getField(i2).asObject(this.fi);
        }

        @Override
        public Path getPath(int i2) {
            return SearchResults.this.getReturnClause().getField(i2).asPath(this.fi);
        }

        @Override
        public String getString(int i2) {
            return SearchResults.this.getReturnClause().getField(i2).asString(this.fi);
        }

        @Override
        public String getDisplayString(int i2) {
            return SearchResults.this.getReturnClause().getField(i2).asDisplayString(this.fi);
        }

        @Override
        public int getInt(int i2) {
            return SearchResults.this.getReturnClause().getField(i2).asInt(this.fi);
        }

        @Override
        public long getDate(int i2) {
            return SearchResults.this.getReturnClause().getField(i2).asDate(this.fi);
        }

        @Override
        public String[] getStringArray(int i2) {
            return SearchResults.this.getReturnClause().getField(i2).asStringArray(this.fi);
        }

        @Override
        public Map[] getMapArray(int i2) {
            return SearchResults.this.getReturnClause().getField(i2).asMapArray(this.fi);
        }

        @Override
        public List getList(int i2) {
            return SearchResults.this.getReturnClause().getField(i2).asList(this.fi);
        }

        @Override
        public String getStringFromArray(int i2) {
            CharSequence[] field = SearchResults.this.getReturnClause().getField(i2).asStringArray(this.fi);
            return String.join((CharSequence)", ", field);
        }

        @Override
        public String getCurrentGroupHumanReadable() {
            return SearchResults.this.getGroupByTerm().getGroupID(this.fi);
        }
    }

    public static interface ResultRow {
        public Object get(int var1);

        public Path getPath(int var1);

        public String getString(int var1);

        public String getDisplayString(int var1);

        public int getInt(int var1);

        public long getDate(int var1);

        public String[] getStringArray(int var1);

        public Map[] getMapArray(int var1);

        public List getList(int var1);

        public String getStringFromArray(int var1);

        public String getCurrentGroupHumanReadable();
    }

    public abstract class RevisionResultsIterator
    implements Iterator<FileRevision> {
        @Override
        public FileRevision next() {
            try {
                return this.nextItem();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }

        public abstract int nextItemId() throws Exception;

        public FileRevision nextItem() throws Exception {
            return SearchResults.this.mRep.getFileRevision(this.nextItemId());
        }

        public abstract Object currentGroup();

        public abstract boolean isStartOfGroup();

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

