/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search;

import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.search.query.QueryEvaluator;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;

public class SearchManager {
    private final LoadingCache<FishQuery, SearchResults> resultsCache = CacheBuilder.newBuilder().softValues().maximumSize(50L).build((CacheLoader)new CacheLoader<FishQuery, SearchResults>(){

        public SearchResults load(FishQuery key) throws Exception {
            return SearchManager.this.evaluator.performQuery(key);
        }
    });
    private final QueryEvaluator evaluator;

    public SearchManager(QueryEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public SearchResults runQuery(FishQuery query, boolean forceRefresh) throws Exception {
        FishQuery q2 = query.getShallowCopy();
        if (forceRefresh) {
            this.resultsCache.invalidate((Object)q2);
        }
        return (SearchResults)this.resultsCache.get((Object)q2);
    }
}

