/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search;

import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.search.AbstractBeforeAfterQuery3;
import com.cenqua.obfuscate.idb.H;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.ag;
import com.cenqua.obfuscate.idb.al;
import com.cenqua.obfuscate.idb.y;
import java.util.EnumSet;
import org.hibernate.HibernateException;

public class ReviewQuery3
extends AbstractBeforeAfterQuery3 {
    private final String permaid;
    private final EnumSet<StateManager.MetaState> metaStates;

    public ReviewQuery3(String permaid, EnumSet<StateManager.MetaState> metaStates, boolean inclusive, boolean after, boolean before) {
        super(inclusive, after, before);
        this.permaid = permaid;
        this.metaStates = metaStates;
    }

    @Override
    protected ac getInputRevids(Query3.QueryContext context) throws DbException {
        if (this.permaid != null) {
            return this.getReviewSpace(context.getSource());
        }
        if (this.metaStates != null) {
            return this.getReviewStatesSpace(context.getSource());
        }
        return new H();
    }

    private ac getReviewStatesSpace(ac db) {
        al any = new al();
        if (this.metaStates.contains((Object)StateManager.MetaState.CLOSED)) {
            any.g(new ag(db, y.a().a(CommonSchema.E_CLOSEDREVIEW_REVIDS)));
        }
        if (this.metaStates.contains((Object)StateManager.MetaState.OPEN)) {
            any.g(new ag(db, y.a().a(CommonSchema.E_OPENREVIEW_REVIDS)));
        }
        if (this.metaStates.contains((Object)StateManager.MetaState.DRAFT)) {
            any.g(new ag(db, y.a().a(CommonSchema.E_DRAFTREVIEW_REVIDS)));
        }
        return any;
    }

    private ac getReviewSpace(ac db) throws DbException {
        Review review = null;
        try {
            review = DefaultReviewManager.get().getReviewByPermaId(this.permaid);
        }
        catch (HibernateException e2) {
            throw new DbException(e2);
        }
        catch (PermaIdFormatException e3) {
            Logs.APP_LOG.warn((Object)"Query contained an invalid permaid", (Throwable)e3);
        }
        if (review == null) {
            return new H();
        }
        y prefix = y.a();
        int reviewId = review.getId();
        prefix.a(CommonSchema.E_REVIEW_TO_REVID).b((long)reviewId);
        return new ag(db, prefix);
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ReviewQuery3 that = (ReviewQuery3)o2;
        if (!this.abstractEquals(that)) {
            return false;
        }
        if (this.metaStates != null ? !this.metaStates.equals(that.metaStates) : that.metaStates != null) {
            return false;
        }
        return !(this.permaid != null ? !this.permaid.equals(that.permaid) : that.permaid != null);
    }

    @Override
    public int hashCode() {
        int result = this.permaid != null ? this.permaid.hashCode() : 0;
        result = 31 * result + (this.metaStates != null ? this.metaStates.hashCode() : 0);
        return result;
    }

    @Override
    public void toString(StringBuffer s2) {
        s2.append("Review(");
        if (this.permaid != null) {
            s2.append("permaid=").append(this.permaid).append(",");
        }
        if (this.metaStates != null) {
            s2.append("metaStates=").append(this.metaStates).append(",");
        }
        s2.append("after=").append(this.after).append(",");
        s2.append("inclusive=").append(this.inclusive).append(",");
        s2.append("before=").append(this.before).append(")");
        s2.append(")");
    }
}

