/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search;

import com.atlassian.fecru.search.index.model.ContentDocInfo;
import com.atlassian.fecru.search.index.model.DiffDocInfo;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.AntGlobQuery3;
import com.cenqua.fisheye.infinitydb.query3.AnyLongRangeQuery3;
import com.cenqua.fisheye.infinitydb.query3.BooleanQuery3;
import com.cenqua.fisheye.infinitydb.query3.CrossRepoLuceneJoinQuery3;
import com.cenqua.fisheye.infinitydb.query3.NotQuery3;
import com.cenqua.fisheye.infinitydb.query3.OrQuery3;
import com.cenqua.fisheye.infinitydb.query3.PerRepoLuceneJoinQuery3;
import com.cenqua.fisheye.infinitydb.query3.Query3;
import com.cenqua.fisheye.infinitydb.query3.RegexQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermLookupQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.impl.CommonQuery3Helper;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.search.ClauseVisitor;
import com.cenqua.fisheye.search.EmptyQuery3;
import com.cenqua.fisheye.search.OpenTagRangeQuery3;
import com.cenqua.fisheye.search.ReviewQuery3;
import com.cenqua.fisheye.search.query.AbstractTermClause;
import com.cenqua.fisheye.search.query.AddedLineClause;
import com.cenqua.fisheye.search.query.AuthorsClause;
import com.cenqua.fisheye.search.query.BoolClause;
import com.cenqua.fisheye.search.query.Clause;
import com.cenqua.fisheye.search.query.CommentClause;
import com.cenqua.fisheye.search.query.CommentExactMatchClause;
import com.cenqua.fisheye.search.query.CommentRegexClause;
import com.cenqua.fisheye.search.query.ContentClause;
import com.cenqua.fisheye.search.query.CsidExactMatchClause;
import com.cenqua.fisheye.search.query.DateRangeClause;
import com.cenqua.fisheye.search.query.HeadClause;
import com.cenqua.fisheye.search.query.NotClause;
import com.cenqua.fisheye.search.query.OnBranchClause;
import com.cenqua.fisheye.search.query.P4FixesClause;
import com.cenqua.fisheye.search.query.P4FixesRegexClause;
import com.cenqua.fisheye.search.query.PathClause;
import com.cenqua.fisheye.search.query.Query3Clause;
import com.cenqua.fisheye.search.query.RemovedLineClause;
import com.cenqua.fisheye.search.query.ReviewClause;
import com.cenqua.fisheye.search.query.TaggedExactClause;
import com.cenqua.fisheye.search.query.TaggedRangeClause;
import com.cenqua.fisheye.util.AntGlob;
import com.cenqua.obfuscate.idb.y;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Query;

public class QueryBuilder
implements ClauseVisitor {
    private final String repository;
    private Query3 query;
    private final Analyzer analyzer;
    private boolean caseSensitive;

    public QueryBuilder(RepositoryEngine engine) {
        this.analyzer = engine.getCfg().getMasterAnalyzer();
        this.caseSensitive = engine.getRevisionCache().isCaseSensitive();
        this.repository = engine.getName();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Query3 getQuery() {
        return this.query;
    }

    protected Analyzer getAnalyzer() {
        return this.analyzer;
    }

    protected void setQuery(Query3 query) {
        this.query = query;
    }

    @Override
    public void visitTermClause(AbstractTermClause termClause) {
        this.setQuery(termClause.asQuery3());
    }

    @Override
    public void visitBoolClause(BoolClause boolClause) throws DbException, IOException {
        int numClauses = boolClause.getNumSubClases();
        if (numClauses == 0) {
            this.query = new OrQuery3();
        } else if (numClauses == 1) {
            Clause c2 = (Clause)boolClause.getSubClauses().next();
            c2.accept(this);
        } else {
            BooleanQuery3 bq = boolClause.isRequired() ? new AndQuery3() : new OrQuery3();
            Iterator i2 = boolClause.getSubClauses();
            while (i2.hasNext()) {
                Clause c3 = (Clause)i2.next();
                this.query = null;
                c3.accept(this);
                bq.addClause(this.query);
            }
            this.query = bq;
        }
    }

    @Override
    public void visitAuthorsClause(AuthorsClause authorsClause) {
        OrQuery3 aq2 = new OrQuery3();
        Iterator i2 = authorsClause.getAuthors();
        while (i2.hasNext()) {
            String author = (String)i2.next();
            String au2 = author.toLowerCase(Locale.US);
            TermQuery3 t2 = new TermQuery3(CommonSchema.E_AUTHOR_TO_REVID, au2, null);
            aq2.addClause(t2);
        }
        this.setQuery(aq2);
    }

    @Override
    public void visitCommentClause(CommentClause commentClause) {
        this.crossRepoClause(((ChangesetQueryBuilder)((ChangesetQueryBuilder)ChangesetQueryBuilder.newBuilder(this.repository).changesetsOnly()).withComment(commentClause.getMatch())).build());
    }

    @Override
    public void visitDateClause(DateRangeClause dateClause) {
        Long minDate = dateClause.getMinDate();
        Long maxDate = dateClause.getMaxDate();
        long from = minDate == null ? Long.MIN_VALUE : minDate;
        long to = maxDate == null ? Long.MAX_VALUE : maxDate;
        this.setQuery(new AnyLongRangeQuery3(CommonSchema.E_DATE_TO_REVID, from, dateClause.isMinInclusive(), to, dateClause.isMaxInclusive()));
    }

    @Override
    public void visitQuery3Clause(Query3Clause clause) {
        this.setQuery(clause.getQuery());
    }

    @Override
    public void visitHeadClause(HeadClause headClause) throws IOException {
        String branch = headClause.getBranch();
        if (branch != null) {
            this.setQuery(new TermQuery3(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID, branch, null));
        } else {
            this.setQuery(new TermQuery3(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS, y.a(), null));
        }
    }

    @Override
    public void visitNotClause(NotClause notClause) throws IOException, DbException {
        notClause.getDelegate().accept(this);
        this.setQuery(new NotQuery3(this.getQuery()));
    }

    @Override
    public void visitCommentExactMatchClause(CommentExactMatchClause commentExactMatchClause) throws DbException {
        String match = commentExactMatchClause.getMatch();
        this.setQuery(new TermLookupQuery3(CommonSchema.E_COMMENTS, CommonSchema.E_COMMENT_ID_TO_REVID, match, null));
    }

    @Override
    public void visitCommentRegexClause(CommentRegexClause commentRegexClause) throws DbException {
        Pattern match = commentRegexClause.getMatch();
        this.setQuery(new RegexQuery3(CommonSchema.E_COMMENTS, CommonSchema.E_COMMENT_ID_TO_REVID, match));
    }

    @Override
    public void visitPathClause(PathClause pathClause) {
        Query3 q2;
        String pattern = pathClause.getPattern();
        if (pathClause.isGlob()) {
            boolean filename;
            boolean bl = filename = !AntGlob.containsPathSeperator(pattern);
            q2 = filename ? (AntGlob.containsExplicitWildcards(pattern) ? new AntGlobQuery3(CommonSchema.E_LCFILENAMES, CommonSchema.E_LCFILENAMEID_TO_REVID, new AntGlob(pattern)) : CommonQuery3Helper.findRevisionsForFilenameQuery3(pattern)) : (AntGlob.isExactPrefixMatcher(pattern) ? CommonQuery3Helper.findRevisionsUnderDirAndQuery3(new Path(AntGlob.trimTrailingAsterisks(pattern)), this.caseSensitive) : new AntGlobQuery3(CommonSchema.E_PATHS, CommonSchema.E_PATH_ID_TO_REVID, new AntGlob(pattern)));
        } else {
            Path p2 = new Path(pattern);
            q2 = CommonQuery3Helper.findRevisionsAtPathQuery3(p2, this.caseSensitive);
        }
        if (pathClause.isInvert()) {
            this.setQuery(new NotQuery3(q2));
        } else {
            this.setQuery(q2);
        }
    }

    @Override
    public void visitOnBranchClause(OnBranchClause onBranchClause) {
        AndQuery3 q2 = new AndQuery3();
        String branch = onBranchClause.getBranch();
        if (onBranchClause.isModified()) {
            q2.addClause(new TermQuery3(CommonSchema.E_MOD_ON_BRANCH_TO_REVID, branch, null));
        } else {
            OrQuery3 bq = new OrQuery3();
            bq.addClause(new TermQuery3(CommonSchema.E_MOD_ON_BRANCH_TO_REVID, branch, null));
            bq.addClause(new TermQuery3(CommonSchema.E_UNMOD_ON_BRANCH_TO_REVID, branch, null));
            bq.addClause(new TermQuery3(CommonSchema.E_BP_ON_BRANCH_TO_REVID, branch, null));
            q2.addClause(bq);
        }
        if (onBranchClause.isAdded()) {
            q2.addClause(new TermQuery3(CommonSchema.E_BRANCH_WITH_ADDS_TO_REVID, branch, null));
        }
        if (onBranchClause.isDeleted()) {
            q2.addClause(new TermQuery3(CommonSchema.E_BRANCH_WITH_DELETES_TO_REVID, branch, null));
        }
        this.setQuery(q2);
    }

    @Override
    public void visitTaggedClause(TaggedExactClause taggedExactClause) throws IOException {
        TermLookupQuery3 q2 = new TermLookupQuery3(CommonSchema.E_TAGS, CommonSchema.E_TAG_TO_REVID, taggedExactClause.getTag(), null);
        this.setQuery(q2);
    }

    @Override
    public void visitTaggedRangeClause(TaggedRangeClause trc) throws IOException {
        AndQuery3 q2 = new AndQuery3();
        if (trc.getStartTag() != null) {
            q2.addClause(new OpenTagRangeQuery3(trc.getStartTag(), trc.isStartInclusive(), true, false));
        }
        if (trc.getEndTag() != null) {
            q2.addClause(new OpenTagRangeQuery3(trc.getEndTag(), trc.isEndInclusive(), false, true));
        }
        this.setQuery(q2);
    }

    @Override
    public void visitContentClause(ContentClause contentClause) throws IOException {
        this.textClause(ContentDocInfo.queryByContentRaw(contentClause.getMatch()), LuceneIndexes.CONTENT);
    }

    @Override
    public void visitCsidExactMatchClause(CsidExactMatchClause csidExactMatchClause) throws IOException {
        TermQuery3 q2 = new TermQuery3(CommonSchema.E_CSID_TO_REVID, csidExactMatchClause.getMatch(), null);
        this.setQuery(q2);
    }

    @Override
    public void visitReviewClause(ReviewClause reviewClause) {
        if (AppConfig.isCrucible()) {
            this.setQuery(new ReviewQuery3(reviewClause.getPermaid(), reviewClause.getMetaStates(), reviewClause.isIn(), false, reviewClause.isBefore()));
        } else {
            this.setQuery(new EmptyQuery3());
        }
    }

    @Override
    public void visitP4FixesClause(P4FixesClause p4FixesClause) throws IOException {
        this.setQuery(new EmptyQuery3());
    }

    @Override
    public void visitP4FixesRegexClause(P4FixesRegexClause p4FixesRegexClause) {
        this.setQuery(new EmptyQuery3());
    }

    private void textClause(Query pq, LuceneIndexes requiredIndex) {
        this.setQuery(new PerRepoLuceneJoinQuery3(pq, requiredIndex));
    }

    private void crossRepoClause(Query pq) {
        this.setQuery(new CrossRepoLuceneJoinQuery3(pq, CrossRepLuceneIndexes.METADATA));
    }

    @Override
    public void visitAddedLineClause(AddedLineClause addedLineClause) {
        this.textClause(DiffDocInfo.queryByAdded(addedLineClause.getMatch()), LuceneIndexes.DIFFTEXT);
    }

    @Override
    public void visitRemovedLineClause(RemovedLineClause removedLineClause) {
        this.textClause(DiffDocInfo.queryByRemoved(removedLineClause.getMatch()), LuceneIndexes.DIFFTEXT);
    }
}

