/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.upgrade;

import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.UpgradeBranchList;
import com.cenqua.fisheye.rep.impl.UpgradeChangeSetDB;
import com.cenqua.fisheye.rep.impl.UpgradeChangesetAncestry;
import com.cenqua.fisheye.rep.impl.UpgradeDataFilenameSearch;
import com.cenqua.fisheye.rep.impl.UpgradeGitAuthorNames;
import com.cenqua.fisheye.rep.impl.UpgradeSuffixPathIndex;
import com.cenqua.fisheye.rep.impl.UpgradeTask;
import com.cenqua.fisheye.rep.upgrade.AbstractRepositoryVersionUpgradeTask;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Version26RepoUpgradeTask
extends AbstractRepositoryVersionUpgradeTask {
    public Version26RepoUpgradeTask() {
        super((Map<ScmType, Integer>)ImmutableMap.of((Object)((Object)ScmType.CVS), (Object)13, (Object)((Object)ScmType.SVN), (Object)23, (Object)((Object)ScmType.P4), (Object)3, (Object)((Object)ScmType.HG), (Object)3, (Object)((Object)ScmType.GIT), (Object)11));
    }

    @Override
    public void upgradeRepository(RepositoryEngine engine, RevisionCacheProperties props) throws IOException {
        List<UpgradeTask> upgradeTasks = Arrays.asList(new UpgradeChangeSetDB(), new UpgradeChangesetAncestry(), new UpgradeBranchList(), new UpgradeGitAuthorNames());
        InternalRevisionCache<? extends ChangeSet> cache = engine.getInternalRevisionCache();
        RepositoryStatus status = engine.getStatus();
        for (UpgradeTask task : upgradeTasks) {
            task.upgrade(engine, status);
        }
        this.upgradeSearchData(engine, cache);
        this.upgradeSuffixPathIndex(engine, cache);
        this.cleanupIdx3(engine);
        cache.commit();
        this.markUpgradeTaskComplete(cache, props);
    }

    private void cleanupIdx3(RepositoryEngine engine) {
        File idx3 = new File(engine.getCacheDir(), "idx3");
        if (idx3.exists()) {
            Logs.APP_LOG.info((Object)("Deleting outdated changeset index for repository " + engine.getName()));
            IOHelper.recursiveDelete(idx3, 10, true);
        }
    }

    private void upgradeSearchData(RepositoryEngine engine, InternalRevisionCache cache) throws DbException {
        UpgradeDataFilenameSearch up = new UpgradeDataFilenameSearch(engine.getName(), engine.getStatus(), cache.getInfDb(), cache.getStringTables(), cache.isCaseSensitive(), engine.getLinecountCalculator());
        up.upgradeIfNecessary();
        up.initAndUpgradeBuckets(cache);
    }

    private void upgradeSuffixPathIndex(RepositoryEngine engine, InternalRevisionCache cache) throws DbException {
        UpgradeSuffixPathIndex up = new UpgradeSuffixPathIndex(engine.getName(), engine.getStatus(), cache.getInfDb(), cache.getStringTables(), cache.isCaseSensitive());
        up.upgradeIfNecessary();
    }

    @Override
    public String getName() {
        return "2.6 RepositoryUpgrade";
    }
}

