/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.upgrade;

import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.db.HgChangeSetDAO;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.Tag;
import com.cenqua.fisheye.rep.upgrade.AbstractRepositoryVersionUpgradeTask;
import com.cenqua.fisheye.util.Timer;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class HgTipUpgradeTask
extends AbstractRepositoryVersionUpgradeTask {
    private static final String MAIN_BRANCH = "default";
    private static final Logger log = Logs.APP_LOG;

    public HgTipUpgradeTask() {
        super((Map<ScmType, Integer>)ImmutableMap.of((Object)((Object)ScmType.HG), (Object)11));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgradeRepository(RepositoryEngine engine, RevisionCacheProperties props) throws IOException {
        HgCache revisionCache = (HgCache)engine.getInternalRevisionCache();
        Timer t2 = new Timer(log, "HgTipUpgradeTask-" + engine.getName());
        try {
            this.doUpgrade(revisionCache);
        }
        finally {
            t2.end();
        }
        this.markUpgradeTaskComplete(revisionCache, props);
    }

    private void doUpgrade(HgCache revisionCache) {
        HgChangeSetDAO csDao = revisionCache.getChangeSetDAO();
        Branch defaultBranch = revisionCache.getBranch(MAIN_BRANCH);
        if (defaultBranch == null) {
            log.info((Object)"Repository doesn't have a default branch. Finishing without changes.");
            return;
        }
        String defaultBranchLatestChangeSetId = defaultBranch.getLatestChangeSetId();
        if (Strings.isNullOrEmpty((String)defaultBranchLatestChangeSetId)) {
            log.info((Object)"default branch doesn't point to a changeset. Finishing without changes.");
            return;
        }
        Tag previousTip = revisionCache.getTag("tip");
        if (previousTip != null) {
            log.warn((Object)("Repository had a tip tag before upgrade: " + previousTip.getChangesetId()));
        }
        log.info((Object)("Adding a tip tag: " + defaultBranchLatestChangeSetId));
        csDao.addTag(new Tag("tip", defaultBranchLatestChangeSetId));
        revisionCache.commit();
        Object latestChangesetOnDefault = csDao.getLatestChangesetOnBranch(MAIN_BRANCH);
        if (latestChangesetOnDefault == null) {
            log.warn((Object)"Failed to find the latest changeset on default. Branch will be updated on next scan.");
            return;
        }
        String latestCsidOnDefault = latestChangesetOnDefault.getId();
        if (!Objects.equal((Object)latestCsidOnDefault, (Object)defaultBranchLatestChangeSetId)) {
            log.info((Object)("Updating default lastChangesetId (" + defaultBranchLatestChangeSetId + "->" + latestCsidOnDefault));
            defaultBranch.setLatestChangeSetId(latestCsidOnDefault);
            revisionCache.getBranchDAO().store(defaultBranch, false);
            revisionCache.commit();
        } else {
            log.info((Object)("Not updating default, as it is already current (" + defaultBranchLatestChangeSetId + ")"));
        }
    }

    @Override
    public String getName() {
        return "Fixing hg 'default' branch head repository upgrade";
    }
}

