/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.upgrade;

import com.atlassian.fugue.Option;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.upgrade.AbstractRepositoryVersionUpgradeTask;
import com.cenqua.fisheye.util.Timer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GitBranchLatestMarkedChangesetsUpgradeTask
extends AbstractRepositoryVersionUpgradeTask {
    private static final Logger log = Logs.loggerFor(GitBranchLatestMarkedChangesetsUpgradeTask.class);

    public GitBranchLatestMarkedChangesetsUpgradeTask() {
        super((Map<ScmType, Integer>)ImmutableMap.of((Object)((Object)ScmType.GIT), (Object)20));
    }

    @Override
    public String getName() {
        return "Setting last marked changesets on branches repository upgrade";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgradeRepository(RepositoryEngine engine, RevisionCacheProperties props) throws IOException {
        InternalRevisionCache<? extends ChangeSet> cache = engine.getInternalRevisionCache();
        Timer t2 = new Timer(log, "GitBranchLatestMarkedChangesetsUpgradeTask-" + cache.getRepositoryName());
        try {
            Set<Branch> branches = cache.getBranches();
            log.info((Object)("Upgrading " + branches.size() + " branches in " + cache.getRepositoryName()));
            for (Branch branch : branches) {
                String headCsId = branch.getLatestChangeSetId();
                if (headCsId == null) continue;
                Object headChangeset = cache.getChangeSet(headCsId);
                if (headChangeset != null && headChangeset.getBranches().contains(branch.getName())) {
                    branch.setLatestMarkedChangesetId((Option<String>)Option.some((Object)headCsId));
                    cache.storeBranch(branch);
                    continue;
                }
                log.info((Object)("Branch " + branch.getName() + " has head set to " + headCsId + " but that changeset " + (headChangeset == null ? "doesn't exist. " : "doesn't have the branch set. ") + "Will re-mark the branch on next indexing."));
            }
        }
        finally {
            t2.end();
        }
        this.markUpgradeTaskComplete(cache, props);
    }
}

